/*
 * Decompiled with CFR 0.152.
 */
package dan200.quantum.shared;

import dan200.QCraft;
import dan200.quantum.shared.BlockQBlock;
import dan200.quantum.shared.EntanglementRegistry;
import java.util.List;
import java.util.Random;

public class TileEntityQBlock
extends asp {
    public static int FUZZ_TIME = 9;
    public static Random s_random = new Random();
    public static EntanglementRegistry<TileEntityQBlock> QBlockRegistry = new EntanglementRegistry();
    public static EntanglementRegistry<TileEntityQBlock> ClientQBlockRegistry = new EntanglementRegistry();
    private int m_entanglementFrequency = -1;
    private int[] m_sideBlockTypes = new int[6];
    private long m_timeLastUpdated;
    private boolean m_currentlyObserved;
    private int m_currentDisplayedSide;
    private int m_currentlyForcedSide;
    private boolean[] m_forceObserved = new boolean[6];
    public int m_timeSinceLastChange;
    private boolean m_goggles;
    private boolean m_wet;

    public static EntanglementRegistry<TileEntityQBlock> getEntanglementRegistry(abw world) {
        if (!world.I) {
            return QBlockRegistry;
        }
        return ClientQBlockRegistry;
    }

    public TileEntityQBlock() {
        for (int i = 0; i < 6; ++i) {
            this.m_sideBlockTypes[i] = 0;
            this.m_forceObserved[i] = false;
        }
        this.m_currentlyObserved = false;
        this.m_currentlyForcedSide = -1;
        this.m_currentDisplayedSide = -1;
        this.m_timeLastUpdated = -99L;
        this.m_timeSinceLastChange = FUZZ_TIME;
        this.m_goggles = false;
        this.m_wet = false;
    }

    public EntanglementRegistry<TileEntityQBlock> getEntanglementRegistry() {
        return TileEntityQBlock.getEntanglementRegistry(this.k);
    }

    public void s() {
        super.s();
        if (this.m_entanglementFrequency >= 0) {
            this.getEntanglementRegistry().register(this.m_entanglementFrequency, this);
        }
    }

    public void w_() {
        if (this.m_entanglementFrequency >= 0) {
            this.getEntanglementRegistry().unregister(this.m_entanglementFrequency, this);
        }
        super.w_();
    }

    public void setTypes(int[] types) {
        this.m_sideBlockTypes = types;
    }

    public int[] getTypes() {
        return this.m_sideBlockTypes;
    }

    public void setEntanglementFrequency(int frequency) {
        if (frequency != this.m_entanglementFrequency) {
            if (this.m_entanglementFrequency >= 0) {
                this.getEntanglementRegistry().unregister(this.m_entanglementFrequency, this);
            }
            this.m_entanglementFrequency = frequency;
            if (this.m_entanglementFrequency >= 0) {
                this.getEntanglementRegistry().register(this.m_entanglementFrequency, this);
            }
        }
    }

    public int getEntanglementFrequency() {
        return this.m_entanglementFrequency;
    }

    public int getSubType() {
        return QCraft.Blocks.qBlock.getSubType((acf)this.k, this.l, this.m, this.n);
    }

    private void blockUpdate() {
        this.k.j(this.l, this.m, this.n);
        this.k.a(this.l, this.m, this.n, QCraft.Blocks.qBlock.cF, QCraft.Blocks.qBlock.a(this.k));
        this.k.f(this.l, this.m, this.n, QCraft.Blocks.qBlock.cF);
    }

    public boolean isForceObserved(int side) {
        return this.m_forceObserved[side];
    }

    public void setForceObserved(int side, boolean enable) {
        if (this.k.I) {
            return;
        }
        this.m_forceObserved[side] = enable;
    }

    private void setDisplayedSide(boolean observed, boolean forced, int side) {
        this.m_currentlyObserved = observed;
        int n = this.m_currentlyForcedSide = forced ? side : -1;
        if (this.m_currentDisplayedSide != side) {
            int oldSide = this.m_currentDisplayedSide;
            int oldType = this.getObservedType();
            int newSide = this.m_currentDisplayedSide = side;
            int newType = this.getObservedType();
            if (newType != oldType || oldSide < 0 != newSide < 0) {
                this.m_timeSinceLastChange = 0;
                this.blockUpdate();
            }
        }
    }

    public int getObservedType() {
        if (this.m_currentDisplayedSide < 0) {
            return this.m_sideBlockTypes[1];
        }
        return this.m_sideBlockTypes[this.m_currentDisplayedSide];
    }

    public BlockQBlock.Appearance getAppearance() {
        if (this.m_goggles) {
            return BlockQBlock.Appearance.Fuzz;
        }
        if (this.m_currentDisplayedSide < 0 || this.m_timeSinceLastChange < FUZZ_TIME) {
            return BlockQBlock.Appearance.Swirl;
        }
        int type = this.m_sideBlockTypes[this.m_currentDisplayedSide];
        if (type == 0 && this.m_wet) {
            return BlockQBlock.Appearance.Fuzz;
        }
        return BlockQBlock.Appearance.Block;
    }

    private boolean checkRayClear(atc playerPos, atc blockPos) {
        ata position = this.k.a(playerPos, blockPos);
        if (position == null) {
            return true;
        }
        return position.a == atb.a && position.b == this.l && position.c == this.m && position.d == this.n;
    }

    private int[] collectVotes() {
        int[] votes = new int[6];
        double centerX = (double)this.l + 0.5;
        double centerY = (double)this.m + 0.5;
        double centerZ = (double)this.n + 0.5;
        List players = this.k.h;
        for (int i = 0; i < players.size(); ++i) {
            boolean flip;
            float f8;
            double fz;
            float f6;
            double fy;
            float f5;
            double z;
            double y;
            double x;
            double distance;
            ye headGear;
            uf player = (uf)players.get(i);
            if (player == null || QCraft.isPlayerWearingGoggles(player) || (headGear = player.bn.f(3)) != null && headGear.b().cv == aqz.bf.cF || !((distance = Math.sqrt((x = player.u - centerX) * x + (y = player.v + 1.62 - (double)player.N - centerY) * y + (z = player.w - centerZ) * z)) < 96.0)) continue;
            double dx = x / distance;
            double dy = y / distance;
            double dz = z / distance;
            float pitch = player.B;
            float yaw = player.A;
            float f3 = ls.b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = ls.a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f7 = f4 * (f5 = -ls.b((float)(-pitch * ((float)Math.PI / 180))));
            double fx = f7;
            double dot = fx * dx + (fy = (double)(f6 = ls.a((float)(-pitch * ((float)Math.PI / 180))))) * dy + (fz = (double)(f8 = f3 * f5)) * dz;
            if (!(dot < -0.4)) continue;
            if (QCraft.enableQBlockOcclusionTesting) {
                atc playerPos = this.k.V().a(centerX + x, centerY + y, centerZ + z);
                boolean lineOfSightFound = false;
                for (int side = 0; side < 6; ++side) {
                    atc sideNormal = this.k.V().a(0.49 * (double)s.b[side], 0.49 * (double)s.c[side], 0.49 * (double)s.d[side]);
                    atc blockPos = this.k.V().a(centerX + sideNormal.c, centerY + sideNormal.d, centerZ + sideNormal.e);
                    atc playerPosLocal = playerPos.c(-blockPos.c, -blockPos.d, -blockPos.e);
                    atc playerPos2 = playerPos.c(0.0, 0.0, 0.0);
                    if (!this.checkRayClear(playerPos2, blockPos)) continue;
                    lineOfSightFound = true;
                    break;
                }
                if (!lineOfSightFound) continue;
            }
            int majoraxis = -1;
            double majorweight = 0.0;
            if (-dy >= majorweight) {
                majoraxis = 0;
                majorweight = -dy;
            }
            if (dy >= majorweight) {
                majoraxis = 1;
                majorweight = dy;
            }
            if (-dz >= majorweight) {
                majoraxis = 2;
                majorweight = -dz;
            }
            if (dz >= majorweight) {
                majoraxis = 3;
                majorweight = dz;
            }
            if (-dx >= majorweight) {
                majoraxis = 4;
                majorweight = -dx;
            }
            if (dx >= majorweight) {
                majoraxis = 5;
                majorweight = dx;
            }
            if (majoraxis < 0) continue;
            if (this.getSubType() == 1 && (flip = s_random.nextBoolean())) {
                majoraxis = s.a[majoraxis];
            }
            int n = majoraxis;
            votes[n] = votes[n] + 1;
        }
        return votes;
    }

    private static int[] addVotes(int[] a, int[] b) {
        int[] c = new int[6];
        for (int i = 0; i < 6; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    private static int tallyVotes(int[] votes) {
        int winner = 0;
        int winnerVotes = 0;
        for (int i = 0; i < 6; ++i) {
            int vote = votes[i];
            if (vote <= winnerVotes) continue;
            winner = i;
            winnerVotes = vote;
        }
        if (winnerVotes > 0) {
            return winner;
        }
        return -1;
    }

    private int getObservationResult(long currentTime) {
        List<TileEntityQBlock> twins;
        int[] votes = new int[6];
        if (this.m_entanglementFrequency >= 0 && (twins = this.getEntanglementRegistry().getEntangledObjects(this.m_entanglementFrequency)) != null) {
            for (TileEntityQBlock twin : twins) {
                if (twin == this) continue;
                if (twin.m_currentlyObserved && twin.m_timeLastUpdated == currentTime) {
                    if (twin.m_currentlyForcedSide >= 0) {
                        return twin.m_currentlyForcedSide + 6;
                    }
                    return twin.m_currentDisplayedSide;
                }
                if (twin.m_currentlyForcedSide >= 0 && twin.m_forceObserved[this.m_currentlyForcedSide]) {
                    return twin.m_currentlyForcedSide + 6;
                }
                for (int i = 0; i < 6; ++i) {
                    if (!twin.m_forceObserved[i]) continue;
                    return i + 6;
                }
                votes = TileEntityQBlock.addVotes(votes, twin.collectVotes());
            }
        }
        if (this.m_currentlyForcedSide >= 0 && this.m_forceObserved[this.m_currentlyForcedSide]) {
            return this.m_currentlyForcedSide + 6;
        }
        for (int i = 0; i < 6; ++i) {
            if (!this.m_forceObserved[i]) continue;
            return i + 6;
        }
        votes = TileEntityQBlock.addVotes(votes, this.collectVotes());
        return TileEntityQBlock.tallyVotes(votes);
    }

    private void redetermineObservedSide() {
        long currentTime = this.k.N().f();
        int winner = this.getObservationResult(currentTime);
        if (winner >= 6) {
            this.setDisplayedSide(true, true, winner -= 6);
        } else if (winner >= 0) {
            if (this.m_currentlyForcedSide >= 0 || !this.m_currentlyObserved) {
                this.setDisplayedSide(true, false, winner);
            }
        } else if (this.m_currentlyObserved) {
            if (this.m_currentlyForcedSide >= 0) {
                this.setDisplayedSide(false, false, -1);
            } else {
                this.setDisplayedSide(false, false, this.m_currentDisplayedSide);
            }
        }
        this.m_timeLastUpdated = currentTime;
    }

    private boolean isTouchingLiquid() {
        for (int i = 1; i < 6; ++i) {
            int x = this.l + s.b[i];
            int y = this.m + s.c[i];
            int z = this.n + s.d[i];
            int id = this.k.a(x, y, z);
            aqz block = aqz.s[id];
            if (block == null || !(block instanceof apc)) continue;
            return true;
        }
        return false;
    }

    public void h() {
        if (!this.k.I) {
            this.redetermineObservedSide();
        }
        ++this.m_timeSinceLastChange;
        boolean goggles = this.k.I && QCraft.isLocalPlayerWearingQuantumGoggles();
        boolean wet = this.isTouchingLiquid();
        if (this.m_goggles != goggles || this.m_wet != wet || this.m_timeSinceLastChange == FUZZ_TIME) {
            this.m_wet = wet;
            this.m_goggles = goggles;
            this.blockUpdate();
        }
    }

    public void a(by nbttagcompound) {
        super.a(nbttagcompound);
        this.m_currentlyObserved = nbttagcompound.n("o");
        this.m_currentDisplayedSide = nbttagcompound.e("d");
        this.m_entanglementFrequency = nbttagcompound.b("f") ? nbttagcompound.e("f") : -1;
        this.m_currentlyForcedSide = nbttagcompound.b("c") ? nbttagcompound.e("c") : -1;
        for (int i = 0; i < 6; ++i) {
            this.m_sideBlockTypes[i] = nbttagcompound.e("s" + i);
            this.m_forceObserved[i] = nbttagcompound.n("c" + i);
        }
    }

    public void b(by nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("o", this.m_currentlyObserved);
        nbttagcompound.a("d", this.m_currentDisplayedSide);
        nbttagcompound.a("f", this.m_entanglementFrequency);
        nbttagcompound.a("c", this.m_currentlyForcedSide);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.a("s" + i, this.m_sideBlockTypes[i]);
            nbttagcompound.a("c" + i, this.m_forceObserved[i]);
        }
    }

    public ey m() {
        by nbttagcompound = new by();
        this.b(nbttagcompound);
        return new ge(this.l, this.m, this.n, 0, nbttagcompound);
    }

    public void onDataPacket(cm net, ge packet) {
        switch (packet.d) {
            case 0: {
                int oldSide = this.m_currentDisplayedSide;
                int oldType = this.getObservedType();
                by nbttagcompound = packet.e;
                this.a(nbttagcompound);
                int newType = this.getObservedType();
                if (newType == oldType && oldSide >= 0) break;
                this.m_timeSinceLastChange = 0;
                this.blockUpdate();
                break;
            }
        }
    }
}

