/*
 * Decompiled with CFR 0.152.
 */
package dan200.quantum.shared;

import dan200.QCraft;
import dan200.quantum.shared.EncryptionRegistry;
import dan200.quantum.shared.EntanglementRegistry;
import dan200.quantum.shared.ItemQBlock;
import dan200.quantum.shared.ItemQuantumComputer;
import dan200.quantum.shared.PortalRegistry;
import dan200.quantum.shared.QuantumTeleporter;
import dan200.quantum.shared.TileEntityQBlock;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public class TileEntityQuantumComputer
extends asp {
    public static final EntanglementRegistry<TileEntityQuantumComputer> ComputerRegistry = new EntanglementRegistry();
    public static final EntanglementRegistry<TileEntityQuantumComputer> ClientComputerRegistry = new EntanglementRegistry();
    public static final int RANGE = 8;
    private boolean m_powered = false;
    private int m_entanglementFrequency = -1;
    private int m_timeSinceEnergize = 0;
    private AreaData m_storedData = null;
    private String m_portalID = null;
    private boolean m_portalNameConflict = false;
    private String m_remoteServerAddress = null;
    private String m_remoteServerName = null;
    private String m_remotePortalID = null;

    public static EntanglementRegistry<TileEntityQuantumComputer> getEntanglementRegistry(abw world) {
        if (!world.I) {
            return ComputerRegistry;
        }
        return ClientComputerRegistry;
    }

    private EntanglementRegistry<TileEntityQuantumComputer> getEntanglementRegistry() {
        return TileEntityQuantumComputer.getEntanglementRegistry(this.k);
    }

    private PortalRegistry getPortalRegistry() {
        return PortalRegistry.getPortalRegistry(this.k);
    }

    public void s() {
        super.s();
        this.register();
    }

    public void w_() {
        this.unregister();
        super.w_();
    }

    public void onDestroy() {
        PortalLocation location = this.getPortal();
        if (location != null && this.isPortalDeployed(location)) {
            this.undeployPortal(location);
        }
        this.unregisterPortal();
    }

    private void register() {
        if (this.m_entanglementFrequency >= 0) {
            this.getEntanglementRegistry().register(this.m_entanglementFrequency, this);
        }
    }

    private void unregister() {
        if (this.m_entanglementFrequency >= 0) {
            this.getEntanglementRegistry().unregister(this.m_entanglementFrequency, this);
        }
    }

    public void setEntanglementFrequency(int frequency) {
        if (this.m_entanglementFrequency != frequency) {
            this.unregister();
            this.m_entanglementFrequency = frequency;
            this.register();
        }
    }

    public int getEntanglementFrequency() {
        return this.m_entanglementFrequency;
    }

    private TileEntityQuantumComputer findEntangledTwin() {
        List<TileEntityQuantumComputer> twins;
        if (this.m_entanglementFrequency >= 0 && (twins = ComputerRegistry.getEntangledObjects(this.m_entanglementFrequency)) != null) {
            for (TileEntityQuantumComputer computer : twins) {
                if (computer == this) continue;
                return computer;
            }
        }
        return null;
    }

    public void setStoredData(AreaData data) {
        this.m_storedData = data;
    }

    public AreaData getStoredData() {
        return this.m_storedData;
    }

    private boolean isPillarBase(int x, int y, int z, int side) {
        if (y < 0 || y >= 256) {
            return false;
        }
        asp entity = this.k.r(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock quantum = (TileEntityQBlock)entity;
            int[] types = quantum.getTypes();
            for (int i = 0; i < 6; ++i) {
                if (!(i == side ? types[i] != 31 : types[i] != 21)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isPillar(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        aqz block = aqz.s[this.k.a(x, y, z)];
        return block == aqz.au;
    }

    private boolean isGlass(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        aqz block = aqz.s[this.k.a(x, y, z)];
        return block == aqz.R;
    }

    private AreaShape calculateShape() {
        int i;
        AreaShape shape = new AreaShape();
        shape.m_xMin = -99;
        shape.m_xMax = -99;
        shape.m_yMin = 0;
        shape.m_yMax = 0;
        shape.m_zMin = -99;
        shape.m_zMax = -99;
        for (i = 0; i < 8; ++i) {
            if (shape.m_xMin == -99 && this.isPillarBase(this.l - i - 1, this.m, this.n, 5)) {
                shape.m_xMin = -i;
            }
            if (shape.m_xMax == -99 && this.isPillarBase(this.l + i + 1, this.m, this.n, 4)) {
                shape.m_xMax = i;
            }
            if (shape.m_zMin == -99 && this.isPillarBase(this.l, this.m, this.n - i - 1, 3)) {
                shape.m_zMin = -i;
            }
            if (shape.m_zMax != -99 || !this.isPillarBase(this.l, this.m, this.n + i + 1, 2)) continue;
            shape.m_zMax = i;
        }
        if (shape.m_xMin != -99 && shape.m_xMax != -99 && shape.m_zMin != -99 && shape.m_zMax != -99) {
            for (i = 1; i < 8 && this.isPillar(this.l + shape.m_xMin - 1, this.m - i, this.n) && this.isPillar(this.l + shape.m_xMax + 1, this.m - i, this.n) && this.isPillar(this.l, this.m - i, this.n + shape.m_zMin - 1) && this.isPillar(this.l, this.m - i, this.n + shape.m_zMax + 1); ++i) {
                shape.m_yMin = -i;
            }
            i = 1;
            while (i < 8 && this.isPillar(this.l + shape.m_xMin - 1, this.m + i, this.n) && this.isPillar(this.l + shape.m_xMax + 1, this.m + i, this.n) && this.isPillar(this.l, this.m + i, this.n + shape.m_zMin - 1) && this.isPillar(this.l, this.m + i, this.n + shape.m_zMax + 1)) {
                shape.m_yMax = i++;
            }
            int top = this.m + shape.m_yMax + 1;
            if (this.isGlass(this.l + shape.m_xMin - 1, top, this.n) && this.isGlass(this.l + shape.m_xMax + 1, top, this.n) && this.isGlass(this.l, top, this.n + shape.m_zMin - 1) && this.isGlass(this.l, top, this.n + shape.m_zMax + 1)) {
                return shape;
            }
        }
        return null;
    }

    private AreaData storeArea() {
        AreaShape shape = this.calculateShape();
        if (shape == null) {
            return null;
        }
        AreaData storedData = new AreaData();
        int minX = shape.m_xMin;
        int maxX = shape.m_xMax;
        int minY = shape.m_yMin;
        int maxY = shape.m_yMax;
        int minZ = shape.m_zMin;
        int maxZ = shape.m_zMax;
        int size = (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
        int index = 0;
        storedData.m_shape = shape;
        storedData.m_blockData = new int[size];
        storedData.m_metaData = new int[size];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int worldX = this.l + x;
                    int worldY = this.m + y;
                    int worldZ = this.n + z;
                    if (worldX != this.l || worldY != this.m || worldZ != this.n) {
                        asp tileentity = this.k.r(worldX, worldY, worldZ);
                        if (tileentity != null) {
                            return null;
                        }
                        int bid = this.k.a(worldX, worldY, worldZ);
                        int meta = this.k.h(worldX, worldY, worldZ);
                        storedData.m_blockData[index] = bid;
                        storedData.m_metaData[index] = meta;
                    }
                    ++index;
                }
            }
        }
        return storedData;
    }

    private void notifyBlockOfNeighborChange(int x, int y, int z) {
        int bid = this.k.a(x, y, z);
        this.k.g(x, y, z, bid);
    }

    private void notifyEdgeBlocks(AreaShape shape) {
        int z;
        int x;
        int minX = shape.m_xMin;
        int maxX = shape.m_xMax;
        int minY = shape.m_yMin;
        int maxY = shape.m_yMax;
        int minZ = shape.m_zMin;
        int maxZ = shape.m_zMax;
        for (x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                this.notifyBlockOfNeighborChange(this.l + x, this.m + y, this.n + minZ);
                this.notifyBlockOfNeighborChange(this.l + x, this.m + y, this.n + maxZ);
                this.notifyBlockOfNeighborChange(this.l + x, this.m + y, this.n + minZ);
                this.notifyBlockOfNeighborChange(this.l + x, this.m + y, this.n + maxZ + 1);
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.notifyBlockOfNeighborChange(this.l + x, this.m + minY, this.n + z);
                this.notifyBlockOfNeighborChange(this.l + x, this.m + maxY, this.n + z);
                this.notifyBlockOfNeighborChange(this.l + x, this.m + minY - 1, this.n + z);
                this.notifyBlockOfNeighborChange(this.l + x, this.m + maxY + 1, this.n + z);
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (z = minZ; z <= maxZ; ++z) {
                this.notifyBlockOfNeighborChange(this.l + minX, this.m + y, this.n + z);
                this.notifyBlockOfNeighborChange(this.l + maxX, this.m + y, this.n + z);
                this.notifyBlockOfNeighborChange(this.l + minX - 1, this.m + y, this.n + z);
                this.notifyBlockOfNeighborChange(this.l + maxX + 1, this.m + y, this.n + z);
            }
        }
    }

    private Set<ss> getEntityItemsInArea(AreaShape shape) {
        asx aabb = asx.a().a((double)(this.l + shape.m_xMin), (double)(this.m + shape.m_yMin), (double)(this.n + shape.m_zMin), (double)(this.l + shape.m_xMax + 1), (double)(this.m + shape.m_yMax + 1), (double)(this.n + shape.m_zMax + 1));
        List list = this.k.b(null, aabb);
        HashSet<ss> set = new HashSet<ss>();
        for (int i = 0; i < list.size(); ++i) {
            nn entity = (nn)list.get(i);
            if (!(entity instanceof ss) || entity.M) continue;
            set.add((ss)entity);
        }
        return set;
    }

    private void killNewItems(Set<ss> before, Set<ss> after) {
        for (ss item : after) {
            if (item.M || before.contains(item)) continue;
            item.x();
        }
    }

    private void clearArea(AreaShape shape) {
        Set<ss> before = this.getEntityItemsInArea(shape);
        int minX = shape.m_xMin;
        int maxX = shape.m_xMax;
        int minY = shape.m_yMin;
        int maxY = shape.m_yMax;
        int minZ = shape.m_zMin;
        int maxZ = shape.m_zMax;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int worldX = this.l + x;
                    int worldY = this.m + y;
                    int worldZ = this.n + z;
                    if (worldX == this.l && worldY == this.m && worldZ == this.n) continue;
                    this.k.f(worldX, worldY, worldZ, 0, 0, 2);
                }
            }
        }
        Set<ss> after = this.getEntityItemsInArea(shape);
        this.killNewItems(before, after);
        this.notifyEdgeBlocks(shape);
    }

    private void unpackArea(AreaData storedData) {
        Set<ss> before = this.getEntityItemsInArea(storedData.m_shape);
        int index = 0;
        int minX = storedData.m_shape.m_xMin;
        int maxX = storedData.m_shape.m_xMax;
        int minY = storedData.m_shape.m_yMin;
        int maxY = storedData.m_shape.m_yMax;
        int minZ = storedData.m_shape.m_zMin;
        int maxZ = storedData.m_shape.m_zMax;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int worldX = this.l + x;
                    int worldY = this.m + y;
                    int worldZ = this.n + z;
                    if (worldX != this.l || worldY != this.m || worldZ != this.n) {
                        int bid = storedData.m_blockData[index];
                        int meta = storedData.m_metaData[index];
                        this.k.f(worldX, worldY, worldZ, bid, meta, 2);
                    }
                    ++index;
                }
            }
        }
        Set<ss> after = this.getEntityItemsInArea(storedData.m_shape);
        this.killNewItems(before, after);
        this.notifyEdgeBlocks(storedData.m_shape);
    }

    private boolean checkCooling() {
        for (int i = 0; i < 6; ++i) {
            int x = this.l + s.b[i];
            int y = this.m + s.c[i];
            int z = this.n + s.d[i];
            aqz block = aqz.s[this.k.a(x, y, z)];
            if (block != aqz.aY) continue;
            return true;
        }
        return false;
    }

    private int canTeleport() {
        AreaData twinData;
        TileEntityQuantumComputer twin = null;
        if (this.m_entanglementFrequency >= 0 && (twin = this.findEntangledTwin()) == null) {
            return 1;
        }
        AreaShape localShape = this.calculateShape();
        if (localShape == null) {
            return 2;
        }
        if (twin != null) {
            AreaShape twinShape = twin.calculateShape();
            if (twinShape == null) {
                return 3;
            }
            if (!localShape.equals(twinShape)) {
                return 4;
            }
        } else if (this.m_storedData != null && !localShape.equals(this.m_storedData.m_shape)) {
            return 4;
        }
        if (!this.checkCooling()) {
            return 6;
        }
        AreaData localData = this.storeArea();
        if (localData == null) {
            return 7;
        }
        if (twin != null && (twinData = twin.storeArea()) == null) {
            return 8;
        }
        return 0;
    }

    private int tryTeleport() {
        int error = this.canTeleport();
        if (error == 0) {
            if (this.m_entanglementFrequency >= 0) {
                TileEntityQuantumComputer twin = this.findEntangledTwin();
                if (twin != null) {
                    AreaData localData = this.storeArea();
                    AreaData twinData = twin.storeArea();
                    if (localData != null && twinData != null) {
                        this.unpackArea(twinData);
                        twin.unpackArea(localData);
                    }
                }
            } else {
                AreaData localData = this.storeArea();
                if (this.m_storedData != null) {
                    this.unpackArea(this.m_storedData);
                } else {
                    this.clearArea(localData.m_shape);
                }
                this.m_storedData = localData;
            }
            this.k.a((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        }
        return error;
    }

    private void registerPortal() {
        PortalLocation location = this.findPortal();
        if (location != null) {
            if (this.m_portalID == null) {
                this.m_portalID = this.getPortalRegistry().getUnusedID();
                this.k.j(this.l, this.m, this.n);
            }
            this.m_portalNameConflict = !this.getPortalRegistry().register(this.m_portalID, location);
        }
    }

    private void unregisterPortal() {
        if (this.m_portalID != null) {
            if (!this.m_portalNameConflict) {
                this.getPortalRegistry().unregister(this.m_portalID);
            }
            this.m_portalNameConflict = false;
        }
    }

    public void setPortalID(String id) {
        this.unregisterPortal();
        this.m_portalID = id;
        this.registerPortal();
    }

    public String getPortalID() {
        return this.m_portalID;
    }

    public void setRemoteServerAddress(String address) {
        this.m_remoteServerAddress = address;
        this.m_remoteServerName = this.getPortalRegistry().getServerName(address);
    }

    public String getRemoteServerAddress() {
        return this.m_remoteServerAddress;
    }

    public String getRemoteServerName() {
        return this.m_remoteServerName;
    }

    public void cycleRemoteServerAddress(String previousAddress) {
        this.m_remoteServerAddress = this.getPortalRegistry().getServerAddressAfter(previousAddress);
        this.m_remoteServerName = this.getPortalRegistry().getServerName(this.m_remoteServerAddress);
    }

    public void setRemotePortalID(String id) {
        this.m_remotePortalID = id;
    }

    public String getRemotePortalID() {
        return this.m_remotePortalID;
    }

    public boolean isTeleporter() {
        if (this.m_entanglementFrequency >= 0) {
            return false;
        }
        if (!QCraft.canAnybodyCreatePortals()) {
            return false;
        }
        PortalLocation location = this.getPortal();
        return location != null;
    }

    public boolean isTeleporterEnergized() {
        return this.canDeactivatePortal() == 0;
    }

    private boolean isPortalCorner(int x, int y, int z, int dir) {
        if (y < 0 || y >= 256) {
            return false;
        }
        asp entity = this.k.r(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock quantum = (TileEntityQBlock)entity;
            int[] types = quantum.getTypes();
            for (int i = 0; i < 6; ++i) {
                if (!(i == dir || i == s.a[dir] ? types[i] != 31 : types[i] != 21)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean portalExistsAt(PortalLocation location) {
        int y;
        if (location.m_xLength > 0) {
            for (y = location.m_yOrigin; y < location.m_yOrigin + location.m_yLength; ++y) {
                if (!this.isGlass(location.m_xOrigin - 1, y, location.m_zOrigin)) {
                    return false;
                }
                if (this.isGlass(location.m_xOrigin + location.m_xLength, y, location.m_zOrigin)) continue;
                return false;
            }
            for (int x = location.m_xOrigin; x < location.m_xOrigin + location.m_xLength; ++x) {
                if (!this.isGlass(x, location.m_yOrigin - 1, location.m_zOrigin)) {
                    return false;
                }
                if (this.isGlass(x, location.m_yOrigin + location.m_yLength, location.m_zOrigin)) continue;
                return false;
            }
            if (!this.isPortalCorner(location.m_xOrigin - 1, location.m_yOrigin - 1, location.m_zOrigin, 2)) {
                return false;
            }
            if (!this.isPortalCorner(location.m_xOrigin + location.m_xLength, location.m_yOrigin - 1, location.m_zOrigin, 2)) {
                return false;
            }
            if (!this.isPortalCorner(location.m_xOrigin - 1, location.m_yOrigin + location.m_yLength, location.m_zOrigin, 2)) {
                return false;
            }
            if (!this.isPortalCorner(location.m_xOrigin + location.m_xLength, location.m_yOrigin + location.m_yLength, location.m_zOrigin, 2)) {
                return false;
            }
        }
        if (location.m_zLength > 0) {
            for (y = location.m_yOrigin; y < location.m_yOrigin + location.m_yLength; ++y) {
                if (!this.isGlass(location.m_xOrigin, y, location.m_zOrigin - 1)) {
                    return false;
                }
                if (this.isGlass(location.m_xOrigin, y, location.m_zOrigin + location.m_zLength)) continue;
                return false;
            }
            for (int z = location.m_zOrigin; z < location.m_zOrigin + location.m_zLength; ++z) {
                if (!this.isGlass(location.m_xOrigin, location.m_yOrigin - 1, z)) {
                    return false;
                }
                if (this.isGlass(location.m_xOrigin, location.m_yOrigin + location.m_yLength, z)) continue;
                return false;
            }
            if (!this.isPortalCorner(location.m_xOrigin, location.m_yOrigin - 1, location.m_zOrigin - 1, 4)) {
                return false;
            }
            if (!this.isPortalCorner(location.m_xOrigin, location.m_yOrigin - 1, location.m_zOrigin + location.m_zLength, 4)) {
                return false;
            }
            if (!this.isPortalCorner(location.m_xOrigin, location.m_yOrigin + location.m_yLength, location.m_zOrigin - 1, 4)) {
                return false;
            }
            if (!this.isPortalCorner(location.m_xOrigin, location.m_yOrigin + location.m_yLength, location.m_zOrigin + location.m_zLength, 4)) {
                return false;
            }
        }
        return true;
    }

    private PortalLocation getPortalAt(int x, int y, int z, int xlen, int ylen, int zlen) {
        PortalLocation result = new PortalLocation();
        result.m_dimensionID = this.k.t.i;
        result.m_xOrigin = x;
        result.m_yOrigin = y;
        result.m_zOrigin = z;
        result.m_xLength = xlen;
        result.m_yLength = ylen;
        result.m_zLength = zlen;
        if (this.portalExistsAt(result)) {
            return result;
        }
        return null;
    }

    private PortalLocation getPortal() {
        if (this.m_portalID != null) {
            if (!this.m_portalNameConflict) {
                PortalLocation portal = this.getPortalRegistry().getPortal(this.m_portalID);
                if (portal != null) {
                    return portal;
                }
            } else {
                PortalLocation portal = this.findPortal();
                if (portal != null) {
                    return portal;
                }
            }
        }
        return null;
    }

    private PortalLocation findPortal() {
        for (int dir = 0; dir < 6; ++dir) {
            int x = this.l + s.b[dir];
            int y = this.m + s.c[dir];
            int z = this.n + s.d[dir];
            if (!this.isGlass(x, y, z) && !this.isPortalCorner(x, y, z, 2) && !this.isPortalCorner(x, y, z, 4)) continue;
            PortalLocation result = this.getPortalAt(x, y + 1, z, 2, 3, 0);
            if (result != null) {
                return result;
            }
            result = this.getPortalAt(x - 1, y + 1, z, 2, 3, 0);
            if (result != null) {
                return result;
            }
            result = this.getPortalAt(x, y - 3, z, 2, 3, 0);
            if (result != null) {
                return result;
            }
            result = this.getPortalAt(x - 1, y - 3, z, 2, 3, 0);
            if (result != null) {
                return result;
            }
            result = this.getPortalAt(x, y + 1, z, 0, 3, 2);
            if (result != null) {
                return result;
            }
            result = this.getPortalAt(x, y + 1, z - 1, 0, 3, 2);
            if (result != null) {
                return result;
            }
            result = this.getPortalAt(x, y - 3, z, 0, 3, 2);
            if (result != null) {
                return result;
            }
            result = this.getPortalAt(x, y - 3, z - 1, 0, 3, 2);
            if (result != null) {
                return result;
            }
            for (int yy = y - 3; yy <= y + 1; ++yy) {
                result = this.getPortalAt(x + 1, yy, z, 2, 3, 0);
                if (result != null) {
                    return result;
                }
                result = this.getPortalAt(x - 2, yy, z, 2, 3, 0);
                if (result != null) {
                    return result;
                }
                result = this.getPortalAt(x, yy, z + 1, 0, 3, 2);
                if (result != null) {
                    return result;
                }
                result = this.getPortalAt(x, yy, z - 2, 0, 3, 2);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private boolean isPortalClear(PortalLocation portal) {
        for (int y = portal.m_yOrigin; y < portal.m_yOrigin + portal.m_yLength; ++y) {
            for (int x = portal.m_xOrigin; x < portal.m_xOrigin + portal.m_xLength; ++x) {
                if (this.k.c(x, y, portal.m_zOrigin)) continue;
                return false;
            }
            for (int z = portal.m_zOrigin; z < portal.m_zOrigin + portal.m_zLength; ++z) {
                if (this.k.c(portal.m_xOrigin, y, z)) continue;
                return false;
            }
        }
        return true;
    }

    private void deployPortal(PortalLocation portal) {
        for (int y = portal.m_yOrigin; y < portal.m_yOrigin + portal.m_yLength; ++y) {
            for (int x = portal.m_xOrigin; x < portal.m_xOrigin + portal.m_xLength; ++x) {
                this.k.f(x, y, portal.m_zOrigin, QCraft.Blocks.quantumPortal.cF, 0, 2);
            }
            for (int z = portal.m_zOrigin; z < portal.m_zOrigin + portal.m_zLength; ++z) {
                this.k.f(portal.m_xOrigin, y, z, QCraft.Blocks.quantumPortal.cF, 0, 2);
            }
        }
    }

    private void undeployPortal(PortalLocation portal) {
        for (int y = portal.m_yOrigin; y < portal.m_yOrigin + portal.m_yLength; ++y) {
            for (int x = portal.m_xOrigin; x < portal.m_xOrigin + portal.m_xLength; ++x) {
                this.k.i(x, y, portal.m_zOrigin);
            }
            for (int z = portal.m_zOrigin; z < portal.m_zOrigin + portal.m_zLength; ++z) {
                this.k.i(portal.m_xOrigin, y, z);
            }
        }
    }

    private boolean isPortalDeployed(PortalLocation portal) {
        for (int y = portal.m_yOrigin; y < portal.m_yOrigin + portal.m_yLength; ++y) {
            for (int x = portal.m_xOrigin; x < portal.m_xOrigin + portal.m_xLength; ++x) {
                if (this.k.a(x, y, portal.m_zOrigin) == QCraft.Blocks.quantumPortal.cF) continue;
                return false;
            }
            for (int z = portal.m_zOrigin; z < portal.m_zOrigin + portal.m_zLength; ++z) {
                if (this.k.a(portal.m_xOrigin, y, z) == QCraft.Blocks.quantumPortal.cF) continue;
                return false;
            }
        }
        return true;
    }

    private int canActivatePortal() {
        if (this.m_entanglementFrequency >= 0) {
            return 2;
        }
        if (!QCraft.canAnybodyCreatePortals()) {
            return 2;
        }
        PortalLocation location = this.getPortal();
        if (location == null) {
            return 2;
        }
        if (this.isPortalDeployed(location)) {
            return 9;
        }
        if (this.m_portalNameConflict) {
            return 10;
        }
        if (!this.isPortalClear(location)) {
            return 5;
        }
        if (!this.checkCooling()) {
            return 6;
        }
        return 0;
    }

    private int tryActivatePortal() {
        int error = this.canActivatePortal();
        if (error == 0) {
            PortalLocation location = this.getPortal();
            if (location != null) {
                this.deployPortal(location);
            }
            this.k.a((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        }
        return error;
    }

    public int canDeactivatePortal() {
        if (this.m_entanglementFrequency >= 0) {
            return 2;
        }
        PortalLocation location = this.getPortal();
        if (location == null) {
            return 2;
        }
        if (!this.isPortalDeployed(location)) {
            return 2;
        }
        return 0;
    }

    private int tryDeactivatePortal() {
        int error = this.canDeactivatePortal();
        if (error == 0) {
            PortalLocation location = this.getPortal();
            if (location != null) {
                this.undeployPortal(location);
            }
            this.k.a((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        }
        return error;
    }

    public void setRedstonePowered(boolean powered) {
        if (this.m_powered != powered) {
            this.m_powered = powered;
            if (!this.k.I && this.m_powered && this.m_timeSinceEnergize >= 4) {
                this.tryEnergize();
            }
        }
    }

    public int canEnergize() {
        int error = this.canTeleport();
        if (error == 0) {
            return error;
        }
        int serverError = this.canActivatePortal();
        if (serverError == 0) {
            return serverError;
        }
        int deactivateError = this.canDeactivatePortal();
        if (deactivateError == 0) {
            return deactivateError;
        }
        return Math.max(error, serverError);
    }

    public int tryEnergize() {
        int error = this.tryTeleport();
        if (error == 0) {
            this.m_timeSinceEnergize = 0;
            return error;
        }
        int serverError = this.tryActivatePortal();
        if (serverError == 0) {
            this.m_timeSinceEnergize = 0;
            return serverError;
        }
        int deactivateError = this.tryDeactivatePortal();
        if (deactivateError == 0) {
            return deactivateError;
        }
        return Math.max(error, serverError);
    }

    public void h() {
        ++this.m_timeSinceEnergize;
        if (!this.k.I) {
            asx aabb;
            List entities;
            PortalLocation location;
            if (this.m_portalNameConflict) {
                this.registerPortal();
            }
            if ((location = this.getPortal()) != null) {
                if (!this.portalExistsAt(location)) {
                    if (this.isPortalDeployed(location)) {
                        this.undeployPortal(location);
                    }
                    this.unregisterPortal();
                    location = null;
                } else if (!this.checkCooling() && this.isPortalDeployed(location)) {
                    this.undeployPortal(location);
                }
            } else {
                this.unregisterPortal();
                location = null;
            }
            if (location == null) {
                this.registerPortal();
                location = this.getPortal();
            }
            if (location != null && this.isPortalDeployed(location) && (entities = this.k.a(uf.class, aabb = asx.a().a((double)location.m_xOrigin, (double)location.m_yOrigin, (double)location.m_zOrigin, (double)(location.m_xOrigin + Math.max(location.m_xLength, 1)), (double)(location.m_yOrigin + location.m_yLength), (double)(location.m_zOrigin + Math.max(location.m_zLength, 1))))) != null && entities.size() > 0) {
                for (Object next : entities) {
                    if (next == null || !(next instanceof uf)) continue;
                    uf player = (uf)next;
                    if (player.ao > 0 || player.ac < 200 || player.o != null || player.n != null) continue;
                    this.teleportPlayer(player);
                }
            }
        }
    }

    private void teleportPlayer(uf player) {
        if (this.m_remoteServerAddress != null) {
            this.queryTeleportPlayerRemote(player);
        } else {
            TileEntityQuantumComputer.teleportPlayerLocal(player, this.m_remotePortalID);
        }
    }

    private void queryTeleportPlayerRemote(uf player) {
        QCraft.requestQueryGoToServer(player, this);
        player.ao = 50;
    }

    public void teleportPlayerRemote(uf player, boolean takeItems) {
        TileEntityQuantumComputer.teleportPlayerRemote(player, this.m_remoteServerAddress, this.m_remotePortalID, takeItems);
    }

    public static void teleportPlayerRemote(uf player, String remoteServerAddress, String remotePortalID, boolean takeItems) {
        QCraft.log("Sending player " + player.bu + " to server \"" + remoteServerAddress + "\"");
        by luggage = new by();
        if (takeItems) {
            cg items = new cg();
            ud playerInventory = player.bn;
            for (int i = 0; i < playerInventory.j_(); ++i) {
                ye stack = playerInventory.a(i);
                if (stack == null || stack.b <= 0 || stack.b().cv == QCraft.Blocks.quantumComputer.cF && ItemQuantumComputer.getEntanglementFrequency(stack) >= 0 || stack.b().cv == QCraft.Blocks.qBlock.cF && ItemQBlock.getEntanglementFrequency(stack) >= 0) continue;
                by itemTag = new by();
                stack.b(itemTag);
                items.a((cl)itemTag);
                playerInventory.a(i, null);
            }
            if (items.c() > 0) {
                QCraft.log("Removed " + items.c() + " items from " + player.bu + "'s inventory.");
                playerInventory.e();
                luggage.a("items", (cl)items);
            }
        }
        if (remotePortalID != null) {
            luggage.a("destinationPortal", remotePortalID);
        }
        try {
            luggage.a("uuid", UUID.randomUUID().toString());
            byte[] luggageData = ci.a((by)luggage);
            byte[] luggageSignature = EncryptionRegistry.Instance.signData(luggageData);
            by signedLuggage = new by();
            signedLuggage.a("key", EncryptionRegistry.Instance.encodePublicKey(EncryptionRegistry.Instance.getLocalKeyPair().getPublic()));
            signedLuggage.a("luggage", luggageData);
            signedLuggage.a("signature", luggageSignature);
            byte[] signedLuggageData = ci.a((by)signedLuggage);
            QCraft.requestGoToServer(player, remoteServerAddress, signedLuggageData);
        }
        catch (IOException e) {
            throw new RuntimeException("Error encoding inventory");
        }
        finally {
            player.ao = 200;
        }
    }

    public void teleportPlayerLocal(uf player) {
        TileEntityQuantumComputer.teleportPlayerLocal(player, this.m_remotePortalID);
    }

    public static void teleportPlayerLocal(uf player, String portalID) {
        PortalLocation location;
        PortalLocation portalLocation = location = portalID != null ? PortalRegistry.PortalRegistry.getPortal(portalID) : null;
        if (location != null) {
            double xPos = (double)location.m_xOrigin + 0.5 + (location.m_xLength > 0 ? (double)(location.m_xLength - 1) * 0.5 : 0.0);
            double yPos = location.m_yOrigin;
            double zPos = (double)location.m_zOrigin + 0.5 + (location.m_zLength > 0 ? (double)(location.m_zLength - 1) * 0.5 : 0.0);
            if (location.m_dimensionID == player.ar) {
                player.ao = 50;
                player.a(xPos, yPos, zPos);
            } else if (player instanceof jv) {
                player.ao = 50;
                MinecraftServer.F().af().transferPlayerToDimension((jv)player, location.m_dimensionID, (acj)new QuantumTeleporter(MinecraftServer.F().a(location.m_dimensionID), xPos, yPos, zPos));
            }
        }
    }

    public void a(by nbttagcompound) {
        super.a(nbttagcompound);
        this.m_powered = nbttagcompound.n("p");
        this.m_timeSinceEnergize = nbttagcompound.e("tse");
        this.m_entanglementFrequency = nbttagcompound.e("f");
        if (nbttagcompound.b("d")) {
            this.m_storedData = AreaData.decode(nbttagcompound.l("d"));
        }
        if (nbttagcompound.b("portalID")) {
            this.m_portalID = nbttagcompound.i("portalID");
        }
        this.m_portalNameConflict = nbttagcompound.n("portalNameConflict");
        if (nbttagcompound.b("remoteIPAddress")) {
            this.m_remoteServerAddress = nbttagcompound.i("remoteIPAddress");
        }
        this.m_remoteServerName = nbttagcompound.b("remoteIPName") ? nbttagcompound.i("remoteIPName") : this.m_remoteServerAddress;
        if (nbttagcompound.b("remotePortalID")) {
            this.m_remotePortalID = nbttagcompound.i("remotePortalID");
        }
    }

    public void b(by nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("p", this.m_powered);
        nbttagcompound.a("tse", this.m_timeSinceEnergize);
        nbttagcompound.a("f", this.m_entanglementFrequency);
        if (this.m_storedData != null) {
            nbttagcompound.a("d", this.m_storedData.encode());
        }
        if (this.m_portalID != null) {
            nbttagcompound.a("portalID", this.m_portalID);
        }
        nbttagcompound.a("portalNameConflict", this.m_portalNameConflict);
        if (this.m_remoteServerAddress != null) {
            nbttagcompound.a("remoteIPAddress", this.m_remoteServerAddress);
        }
        if (this.m_remoteServerName != null) {
            nbttagcompound.a("remoteIPName", this.m_remoteServerName);
        }
        if (this.m_remotePortalID != null) {
            nbttagcompound.a("remotePortalID", this.m_remotePortalID);
        }
    }

    public ey m() {
        by nbttagcompound = new by();
        nbttagcompound.a("f", this.m_entanglementFrequency);
        if (this.m_portalID != null) {
            nbttagcompound.a("portalID", this.m_portalID);
        }
        nbttagcompound.a("portalNameConflict", this.m_portalNameConflict);
        if (this.m_remoteServerAddress != null) {
            nbttagcompound.a("remoteIPAddress", this.m_remoteServerAddress);
        }
        if (this.m_remoteServerName != null) {
            nbttagcompound.a("remoteIPName", this.m_remoteServerName);
        }
        if (this.m_remotePortalID != null) {
            nbttagcompound.a("remotePortalID", this.m_remotePortalID);
        }
        return new ge(this.l, this.m, this.n, 0, nbttagcompound);
    }

    public void onDataPacket(cm net, ge packet) {
        switch (packet.d) {
            case 0: {
                by nbttagcompound = packet.e;
                this.setEntanglementFrequency(nbttagcompound.e("f"));
                this.m_portalID = nbttagcompound.b("portalID") ? nbttagcompound.i("portalID") : null;
                this.m_portalNameConflict = nbttagcompound.n("portalNameConflict");
                this.m_remoteServerAddress = nbttagcompound.b("remoteIPAddress") ? nbttagcompound.i("remoteIPAddress") : null;
                this.m_remoteServerName = nbttagcompound.b("remoteIPName") ? nbttagcompound.i("remoteIPName") : null;
                if (nbttagcompound.b("remotePortalID")) {
                    this.m_remotePortalID = nbttagcompound.i("remotePortalID");
                    break;
                }
                this.m_remotePortalID = null;
                break;
            }
        }
    }

    public static class PortalLocation {
        public int m_dimensionID;
        public int m_xOrigin;
        public int m_yOrigin;
        public int m_zOrigin;
        public int m_xLength;
        public int m_yLength;
        public int m_zLength;

        public by encode() {
            by nbttagcompound = new by();
            nbttagcompound.a("dimensionID", this.m_dimensionID);
            nbttagcompound.a("xOrigin", this.m_xOrigin);
            nbttagcompound.a("yOrigin", this.m_yOrigin);
            nbttagcompound.a("zOrigin", this.m_zOrigin);
            nbttagcompound.a("xLength", this.m_xLength);
            nbttagcompound.a("yLength", this.m_yLength);
            nbttagcompound.a("zLength", this.m_zLength);
            return nbttagcompound;
        }

        public static PortalLocation decode(by nbttagcompound) {
            PortalLocation location = new PortalLocation();
            location.m_dimensionID = nbttagcompound.b("dimensionID") ? nbttagcompound.e("dimensionID") : 0;
            location.m_xOrigin = nbttagcompound.e("xOrigin");
            location.m_yOrigin = nbttagcompound.e("yOrigin");
            location.m_zOrigin = nbttagcompound.e("zOrigin");
            location.m_xLength = nbttagcompound.e("xLength");
            location.m_yLength = nbttagcompound.e("yLength");
            location.m_zLength = nbttagcompound.e("zLength");
            return location;
        }
    }

    public static class TeleportError {
        public static final int Ok = 0;
        public static final int NoTwin = 1;
        public static final int FrameIncomplete = 2;
        public static final int DestinationFrameIncomplete = 3;
        public static final int FrameMismatch = 4;
        public static final int FrameObstructed = 5;
        public static final int InsufficientCooling = 6;
        public static final int AreaNotTransportable = 7;
        public static final int DestinationNotTransportable = 8;
        public static final int FrameDeployed = 9;
        public static final int NameConflict = 10;

        public static String decode(int error) {
            switch (error) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "No destination";
                }
                case 2: {
                    return "Frame incomplete";
                }
                case 3: {
                    return "Destination frame incomplete";
                }
                case 4: {
                    return "Frame mismatch";
                }
                case 5: {
                    return "Frame obstructed";
                }
                case 6: {
                    return "Insufficient cooling";
                }
                case 7: {
                    return "Area not transportable";
                }
                case 8: {
                    return "Destination not transportable";
                }
                case 9: {
                    return "Frame is energized";
                }
                case 10: {
                    return "Portal name in use";
                }
            }
            return "";
        }
    }

    public static class AreaData {
        public AreaShape m_shape;
        public int[] m_blockData;
        public int[] m_metaData;

        public by encode() {
            by nbttagcompound = new by();
            nbttagcompound.a("xmin", this.m_shape.m_xMin);
            nbttagcompound.a("xmax", this.m_shape.m_xMax);
            nbttagcompound.a("ymin", this.m_shape.m_yMin);
            nbttagcompound.a("ymax", this.m_shape.m_yMax);
            nbttagcompound.a("zmin", this.m_shape.m_zMin);
            nbttagcompound.a("zmax", this.m_shape.m_zMax);
            nbttagcompound.a("blockData", this.m_blockData);
            nbttagcompound.a("metaData", this.m_metaData);
            return nbttagcompound;
        }

        public static AreaData decode(by nbttagcompound) {
            AreaData storedData = new AreaData();
            storedData.m_shape = new AreaShape();
            storedData.m_shape.m_xMin = nbttagcompound.e("xmin");
            storedData.m_shape.m_xMax = nbttagcompound.e("xmax");
            storedData.m_shape.m_yMin = nbttagcompound.e("ymin");
            storedData.m_shape.m_yMax = nbttagcompound.e("ymax");
            storedData.m_shape.m_zMin = nbttagcompound.e("zmin");
            storedData.m_shape.m_zMax = nbttagcompound.e("zmax");
            storedData.m_blockData = nbttagcompound.k("blockData");
            storedData.m_metaData = nbttagcompound.k("metaData");
            return storedData;
        }
    }

    public static class AreaShape {
        public int m_xMin;
        public int m_xMax;
        public int m_yMin;
        public int m_yMax;
        public int m_zMin;
        public int m_zMax;

        public boolean equals(AreaShape o) {
            return o.m_xMin == this.m_xMin && o.m_xMax == this.m_xMax && o.m_yMin == this.m_yMin && o.m_yMax == this.m_yMax && o.m_zMin == this.m_zMin && o.m_zMax == this.m_zMax;
        }
    }
}

