/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import cofh.render.IconRegistry;
import cofh.util.ServerHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.ForgeSubscribe;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.conduit.TileConduitBase;
import thermalexpansion.block.conduit.energy.TileConduitEnergy;
import thermalexpansion.block.conduit.fluid.TileConduitFluid;
import thermalexpansion.block.conduit.item.TileConduitItem;
import thermalexpansion.core.TEProps;
import thermalexpansion.part.conduit.ItemConduitPart;
import thermalexpansion.util.Utils;

public class BlockConduit
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"energyBasic", "energyHardened", "energyReinforced", "fluidTrans", "fluidOpaque", "itemTrans", "itemOpaque", "itemFastTrans", "itemFastOpaque"};
    public static final int[] RESISTANCE = new int[]{15, 90, 120, 120, 15, 120, 15, 120, 15};
    public static byte[] internalTypeMap = new byte[]{0, 1, 2, 0, 1, 0, 1, 2, 3};
    public static ItemStack conduitEnergyBasic;
    public static ItemStack conduitEnergyHardened;
    public static ItemStack conduitEnergyReinforced;
    public static ItemStack conduitFluidTrans;
    public static ItemStack conduitFluidOpaque;
    public static ItemStack conduitItemTrans;
    public static ItemStack conduitItemOpaque;
    public static ItemStack conduitItemFastTrans;
    public static ItemStack conduitItemFastOpaque;

    public BlockConduit(int id) {
        super(id, Material.field_76264_q);
        this.func_71848_c(1.0f);
        this.func_71894_b(150.0f);
        this.func_71864_b("thermalexpansion.conduit");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= ConduitTypes.values().length) {
            return null;
        }
        if (metadata == ConduitTypes.ENERGY_BASIC.ordinal()) {
            return new TileConduitEnergy(metadata);
        }
        if (metadata == ConduitTypes.ENERGY_HARDENED.ordinal()) {
            return new TileConduitEnergy(metadata);
        }
        if (metadata == ConduitTypes.ENERGY_REINFORCED.ordinal()) {
            return new TileConduitEnergy(metadata);
        }
        if (metadata == ConduitTypes.FLUID_TRANS.ordinal()) {
            return new TileConduitFluid(metadata);
        }
        if (metadata == ConduitTypes.FLUID_OPAQUE.ordinal()) {
            return new TileConduitFluid(metadata);
        }
        if (metadata == ConduitTypes.ITEM_TRANS.ordinal()) {
            return new TileConduitItem(metadata);
        }
        if (metadata == ConduitTypes.ITEM_OPAQUE.ordinal()) {
            return new TileConduitItem(metadata);
        }
        if (metadata == ConduitTypes.ITEM_FAST_TRANS.ordinal()) {
            return new TileConduitItem(metadata);
        }
        if (metadata == ConduitTypes.ITEM_FAST_OPAQUE.ordinal()) {
            return new TileConduitItem(metadata);
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
    }

    public void onNeighborTileChange(World world, int x, int y, int z, int tileX, int tileY, int tileZ) {
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player, x, y, z)) {
                if (ServerHelper.isServerWorld((World)world)) {
                    this.dismantleBlock(player, world, x, y, z, false);
                }
                ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_71861_g(World world, int x, int y, int z) {
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        switch (metadata) {
            case 0: {
                ret.add(ItemConduitPart.conduitEnergyBasic.func_77946_l());
                break;
            }
            case 1: {
                ret.add(ItemConduitPart.conduitEnergyHardened.func_77946_l());
                break;
            }
            case 2: {
                ret.add(ItemConduitPart.conduitEnergyReinforced.func_77946_l());
                break;
            }
            case 3: {
                ret.add(ItemConduitPart.conduitFluidTrans.func_77946_l());
                break;
            }
            case 4: {
                ret.add(ItemConduitPart.conduitFluidOpaque.func_77946_l());
                break;
            }
            case 5: {
                ret.add(ItemConduitPart.conduitItemTrans.func_77946_l());
                break;
            }
            case 6: {
                ret.add(ItemConduitPart.conduitItemOpaque.func_77946_l());
                break;
            }
            case 7: {
                ret.add(ItemConduitPart.conduitItemFastTrans.func_77946_l());
                break;
            }
            case 8: {
                ret.add(ItemConduitPart.conduitItemFastOpaque.func_77946_l());
            }
        }
        return ret;
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        this.func_71905_a(0.3f, 0.3f, 0.3f, 0.7f, 0.7f, 0.7f);
        super.func_71871_a(world, x, y, z, axis, list, entity);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return RESISTANCE[world.func_72805_g(x, y, z)];
    }

    public int func_71856_s_() {
        return 1;
    }

    public int func_71857_b() {
        return TEProps.renderIdConduit;
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileConduitBase theTile = (TileConduitBase)world.func_72796_p(x, y, z);
        if (theTile == null) {
            return null;
        }
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        theTile.addTraceableCuboids(cuboids);
        return RayTracer.instance().rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(x, y, z), (Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.target.field_72313_a == EnumMovingObjectType.TILE && event.player.field_70170_p.func_72798_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d) == this.field_71990_ca) {
            RayTracer.retraceBlock((World)event.player.field_70170_p, (EntityPlayer)event.player, (int)event.target.field_72311_b, (int)event.target.field_72312_c, (int)event.target.field_72309_d);
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        double[] min = new double[]{x, y, z};
        double[] max = new double[]{x + 1, y + 1, z + 1};
        return AxisAlignedBB.func_72330_a((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"ConduitEnergy00", (String)"thermalexpansion:conduit/energy/ConduitEnergy00", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitEnergy10", (String)"thermalexpansion:conduit/energy/ConduitEnergy10", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitEnergy20", (String)"thermalexpansion:conduit/energy/ConduitEnergy20", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitFluid00", (String)"thermalexpansion:conduit/fluid/ConduitFluid00", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitFluid10", (String)"thermalexpansion:conduit/fluid/ConduitFluid10", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem00", (String)"thermalexpansion:conduit/item/ConduitItem00", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem10", (String)"thermalexpansion:conduit/item/ConduitItem10", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem20", (String)"thermalexpansion:conduit/item/ConduitItem20", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem30", (String)"thermalexpansion:conduit/item/ConduitItem30", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem01", (String)"thermalexpansion:conduit/item/ConduitItem01", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem02", (String)"thermalexpansion:conduit/item/ConduitItem02", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem03", (String)"thermalexpansion:conduit/item/ConduitItem03", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem11", (String)"thermalexpansion:conduit/item/ConduitItem11", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem12", (String)"thermalexpansion:conduit/item/ConduitItem12", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem13", (String)"thermalexpansion:conduit/item/ConduitItem13", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem21", (String)"thermalexpansion:conduit/item/ConduitItem21", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem22", (String)"thermalexpansion:conduit/item/ConduitItem22", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem23", (String)"thermalexpansion:conduit/item/ConduitItem23", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem31", (String)"thermalexpansion:conduit/item/ConduitItem31", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem32", (String)"thermalexpansion:conduit/item/ConduitItem32", (IconRegister)ir);
        IconRegistry.addIcon((String)"ConduitItem33", (String)"thermalexpansion:conduit/item/ConduitItem33", (IconRegister)ir);
        IconRegistry.addIcon((String)("Connection" + ConnectionTypes.ENERGY_BASIC.ordinal()), (String)"thermalexpansion:conduit/energy/ConnectionEnergy00", (IconRegister)ir);
        IconRegistry.addIcon((String)("Connection" + ConnectionTypes.ENERGY_HARDENED.ordinal()), (String)"thermalexpansion:conduit/energy/ConnectionEnergy10", (IconRegister)ir);
        IconRegistry.addIcon((String)("Connection" + ConnectionTypes.ENERGY_REINFORCED.ordinal()), (String)"thermalexpansion:conduit/energy/ConnectionEnergy20", (IconRegister)ir);
        IconRegistry.addIcon((String)("Connection" + ConnectionTypes.FLUID_NORMAL.ordinal()), (String)"thermalexpansion:conduit/fluid/ConnectionFluid00", (IconRegister)ir);
        IconRegistry.addIcon((String)("Connection" + ConnectionTypes.FLUID_INPUT_ON.ordinal()), (String)"thermalexpansion:conduit/fluid/ConnectionFluid01", (IconRegister)ir);
        IconRegistry.addIcon((String)("Connection" + ConnectionTypes.ITEM_NORMAL.ordinal()), (String)"thermalexpansion:conduit/item/ConnectionItem00", (IconRegister)ir);
        IconRegistry.addIcon((String)("Connection" + ConnectionTypes.ITEM_INPUT_ON.ordinal()), (String)"thermalexpansion:conduit/item/ConnectionItem01", (IconRegister)ir);
        IconRegistry.addIcon((String)("Connection" + ConnectionTypes.ITEM_STUFFED_ON.ordinal()), (String)"thermalexpansion:conduit/item/ConnectionItem02", (IconRegister)ir);
    }

    public boolean initialize() {
        TileConduitEnergy.initialize();
        TileConduitFluid.initialize();
        TileConduitItem.initialize();
        conduitEnergyBasic = new ItemStack((Block)this, 1, ConduitTypes.ENERGY_BASIC.ordinal());
        conduitEnergyHardened = new ItemStack((Block)this, 1, ConduitTypes.ENERGY_HARDENED.ordinal());
        conduitEnergyReinforced = new ItemStack((Block)this, 1, ConduitTypes.ENERGY_REINFORCED.ordinal());
        conduitFluidTrans = new ItemStack((Block)this, 1, ConduitTypes.FLUID_TRANS.ordinal());
        conduitFluidOpaque = new ItemStack((Block)this, 1, ConduitTypes.FLUID_OPAQUE.ordinal());
        conduitItemTrans = new ItemStack((Block)this, 1, ConduitTypes.ITEM_TRANS.ordinal());
        conduitItemOpaque = new ItemStack((Block)this, 1, ConduitTypes.ITEM_OPAQUE.ordinal());
        conduitItemFastTrans = new ItemStack((Block)this, 1, ConduitTypes.ITEM_FAST_TRANS.ordinal());
        conduitItemFastOpaque = new ItemStack((Block)this, 1, ConduitTypes.ITEM_FAST_OPAQUE.ordinal());
        return true;
    }

    public boolean postInit() {
        return true;
    }

    public static enum ConnectionTypes {
        NONE(false),
        CONDUIT,
        ENERGY_BASIC,
        ENERGY_BASIC_BLOCKED(false),
        ENERGY_HARDENED,
        ENERGY_HARDENED_BLOCKED(false),
        ENERGY_REINFORCED,
        ENERGY_REINFORCED_BLOCKED(false),
        FLUID_NORMAL,
        FLUID_BLOCKED(false),
        FLUID_INPUT_ON,
        FLUID_INPUT_OFF,
        ITEM_NORMAL,
        ITEM_BLOCKED(false),
        ITEM_INPUT_ON,
        ITEM_INPUT_OFF,
        ITEM_STUFFED_ON,
        ITEM_STUFFED_OFF;

        private final boolean renderConduit;

        private ConnectionTypes() {
            this.renderConduit = true;
        }

        private ConnectionTypes(boolean renderConduit) {
            this.renderConduit = renderConduit;
        }

        public boolean renderConduit() {
            return this.renderConduit;
        }
    }

    public static enum RenderTypes {
        ENERGY_BASIC,
        ENERGY_HARDENED,
        ENERGY_REINFORCED,
        FLUID_TRANS,
        FLUID_OPAQUE,
        ITEM_TRANS,
        ITEM_OPAQUE,
        ITEM_FAST_TRANS,
        ITEM_FAST_OPAQUE,
        ITEM_TRANS_SHORT,
        ITEM_TRANS_LONG,
        ITEM_TRANS_ROUNDROBIN,
        ITEM_OPAQUE_SHORT,
        ITEM_OPAQUE_LONG,
        ITEM_OPAQUE_ROUNDROBIN,
        ITEM_FAST_TRANS_SHORT,
        ITEM_FAST_TRANS_LONG,
        ITEM_FAST_TRANS_ROUNDROBIN,
        ITEM_FAST_OPAQUE_SHORT,
        ITEM_FAST_OPAQUE_LONG,
        ITEM_FAST_OPAQUE_ROUNDROBIN;

    }

    public static enum ConduitTypes {
        ENERGY_BASIC,
        ENERGY_HARDENED,
        ENERGY_REINFORCED,
        FLUID_TRANS,
        FLUID_OPAQUE,
        ITEM_TRANS,
        ITEM_OPAQUE,
        ITEM_FAST_TRANS,
        ITEM_FAST_OPAQUE;

    }
}

