/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.Payload;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TileMachineEnergized;
import thermalexpansion.core.TEProps;

public class TileIceGen
extends TileMachineEnergized
implements IFluidHandler {
    public static final int TYPE = BlockMachine.Types.ICE_GEN.ordinal();
    static int[] processWater = new int[]{500, 500, 1000};
    static int[] processEnergy = new int[]{800, 800, 1600};
    static ItemStack[] processItems = new ItemStack[3];
    FluidTank tank = new FluidTank(4000);
    byte curSelection;
    byte prevSelection;
    int outputTracker;

    public static void initialize() {
        TileIceGen.processItems[0] = new ItemStack(Item.field_77768_aD, 4, 0);
        TileIceGen.processItems[1] = new ItemStack(Block.field_72039_aU);
        TileIceGen.processItems[2] = new ItemStack(Block.field_72036_aT);
        TileIceGen.sideData[TileIceGen.TYPE] = new TileMachineBase.SideConfig();
        TileIceGen.sideData[TileIceGen.TYPE].numGroup = 3;
        TileIceGen.sideData[TileIceGen.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}};
        TileIceGen.sideData[TileIceGen.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileIceGen.sideData[TileIceGen.TYPE].allowExtraction = new boolean[]{false, false, true};
        TileIceGen.sideData[TileIceGen.TYPE].sideTex = new int[]{0, 1, 4};
        TileIceGen.energyData[TileIceGen.TYPE] = new TileMachineEnergized.EnergyConfig();
        energyData[TYPE].setEnergyParams(20);
        TileIceGen.guiIds[TileIceGen.TYPE] = ThermalExpansion.proxy.registerGui("IceGen", "machine", true);
        GameRegistry.registerTileEntity(TileIceGen.class, (String)"cofh.thermalexpansion.IceGen");
    }

    public TileIceGen() {
        this.sideCache = new byte[]{2, 2, 1, 1, 1, 1};
        this.inventory = new ItemStack[5];
        this.inventory[2] = processItems[0];
        this.inventory[3] = processItems[1];
        this.inventory[4] = processItems[2];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getChargeSlot() {
        return 1;
    }

    @Override
    public boolean canStart() {
        if (this.energyStorage.getEnergyStored() < processEnergy[this.curSelection] || this.tank.getFluidAmount() < processWater[this.curSelection]) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(processItems[this.curSelection])) {
            return false;
        }
        return this.inventory[0].field_77994_a + TileIceGen.processItems[this.curSelection].field_77994_a <= processItems[this.prevSelection].func_77976_d();
    }

    @Override
    public boolean canFinish() {
        return this.processRem <= 0;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = processEnergy[this.curSelection];
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void processFinish() {
        if (this.inventory[0] == null) {
            this.inventory[0] = processItems[this.prevSelection].func_77946_l();
        } else {
            this.inventory[0].field_77994_a += TileIceGen.processItems[this.prevSelection].field_77994_a;
        }
        this.tank.getFluid().amount -= processWater[this.prevSelection];
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void transferProducts() {
        if (this.inventory[0] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.transferItem(0, 4, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public Payload getModePayload() {
        Payload payload = super.getModePayload();
        payload.addByte(this.curSelection);
        return payload;
    }

    public void setMode(int i) {
        this.curSelection = (byte)i;
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.sendModePacket();
        }
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.isActive = payload.getBool();
                this.processMax = payload.getInt();
                this.processRem = payload.getInt();
                this.energyStorage.setEnergyStored(payload.getInt());
                return;
            }
            case MODE: {
                this.curSelection = payload.getByte();
                if (!this.isActive) {
                    this.prevSelection = this.curSelection;
                }
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
                return;
            }
        }
    }

    public int getCurSelection() {
        return this.curSelection;
    }

    public int getPrevSelection() {
        return this.prevSelection;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.curSelection = (byte)j;
            }
            case 1: {
                this.prevSelection = (byte)j;
                return;
            }
            case 2: {
                if (this.tank.getFluid() == null) {
                    this.tank.setFluid(new FluidStack(FluidRegistry.WATER, j));
                } else {
                    this.tank.getFluid().amount = j;
                }
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        super.sendGuiNetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, 0, (int)this.curSelection);
        iCrafting.func_71112_a(container, 1, (int)this.prevSelection);
        iCrafting.func_71112_a(container, 2, this.tank.getFluidAmount());
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTracker = nbt.func_74762_e("Tracker");
        this.prevSelection = nbt.func_74771_c("Prev");
        this.curSelection = nbt.func_74771_c("Sel");
        this.tank.readFromNBT(nbt);
        this.inventory[2] = processItems[0];
        this.inventory[3] = processItems[1];
        this.inventory[4] = processItems[2];
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Tracker", this.outputTracker);
        nbt.func_74774_a("Prev", this.prevSelection);
        nbt.func_74774_a("Sel", this.curSelection);
        this.tank.writeToNBT(nbt);
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.length - 3;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 1) {
            return 0;
        }
        if (resource.getFluid() != FluidRegistry.WATER) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

