/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.strongbox;

import cofh.api.tileentity.ISecureTile;
import cofh.util.CoreUtils;
import cofh.util.UpgradeRecipe;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.strongbox.TileStrongbox;
import thermalexpansion.block.strongbox.TileStrongboxCreative;

public class BlockStrongbox
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static final float[] HARDNESS = new float[]{-1.0f, 5.0f, 15.0f, 20.0f, 20.0f};
    public static final int[] RESISTANCE = new int[]{1200, 15, 90, 120, 120};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack strongboxCreative;
    public static ItemStack strongboxBasic;
    public static ItemStack strongboxHardened;
    public static ItemStack strongboxReinforced;
    public static ItemStack strongboxResonant;

    public BlockStrongbox(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(20.0f);
        this.func_71894_b(120.0f);
        this.func_71864_b("thermalexpansion.strongbox");
        this.func_71905_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= Types.values().length) {
            return null;
        }
        if (metadata == Types.CREATIVE.ordinal()) {
            return new TileStrongboxCreative(metadata);
        }
        return new TileStrongbox(metadata);
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        if (stack.field_77990_d != null) {
            TileStrongbox tile = (TileStrongbox)world.func_72796_p(x, y, z);
            if (stack.field_77990_d.func_74764_b("Owner")) {
                tile.setOwnerName(stack.field_77990_d.func_74779_i("Owner"));
                tile.setAccess(ISecureTile.AccessMode.values()[stack.field_77990_d.func_74771_c("Access")]);
                tile.readInventoryFromNBT(stack.field_77990_d);
            }
        }
        super.func_71860_a(world, x, y, z, living, stack);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        NBTTagCompound tag = null;
        if (!secureOwner.equals("[None]")) {
            tag = new NBTTagCompound();
            tag.func_74778_a("Owner", secureOwner);
            tag.func_74774_a("Access", secureAccess);
            secureOwner = "[None]";
            secureAccess = 0;
        }
        ItemStack retStack = new ItemStack(this.field_71990_ca, 1, this.func_71899_b(metadata));
        retStack.func_77982_d(tag);
        ret.add(retStack);
        return ret;
    }

    public float func_71934_m(World world, int x, int y, int z) {
        return -1.0f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return RESISTANCE[world.func_72805_g(x, y, z)];
    }

    public int func_71857_b() {
        return -1;
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int x, int y, int z) {
        TileStrongbox tile = (TileStrongbox)world.func_72796_p(x, y, z);
        NBTTagCompound tag = super.getItemStackTag(world, x, y, z);
        if (tile != null) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74778_a("Owner", tile.getOwnerName());
            tag.func_74774_a("Access", (byte)tile.getAccess().ordinal());
            tile.writeInventoryToNBT(tag);
        }
        return tag;
    }

    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        NBTTagCompound tag = this.getItemStackTag(world, x, y, z);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileInventory) {
            ((TileInventory)tile).inventory = new ItemStack[((TileInventory)tile).inventory.length];
        }
        return super.dismantleBlock(player, tag, world, x, y, z, returnBlock, false);
    }

    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)player)) {
            return false;
        }
        return super.canDismantle(player, world, x, y, z);
    }

    public boolean initialize() {
        TileStrongbox.initialize();
        TileStrongboxCreative.initialize();
        strongboxCreative = new ItemStack((Block)this, 1, Types.CREATIVE.ordinal());
        strongboxBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        strongboxHardened = new ItemStack((Block)this, 1, Types.HARDENED.ordinal());
        strongboxReinforced = new ItemStack((Block)this, 1, Types.REINFORCED.ordinal());
        strongboxResonant = new ItemStack((Block)this, 1, Types.RESONANT.ordinal());
        GameRegistry.registerCustomItemStack((String)"strongboxCreative", (ItemStack)strongboxCreative);
        GameRegistry.registerCustomItemStack((String)"strongboxBasic", (ItemStack)strongboxBasic);
        GameRegistry.registerCustomItemStack((String)"strongboxHardened", (ItemStack)strongboxHardened);
        GameRegistry.registerCustomItemStack((String)"strongboxReinforced", (ItemStack)strongboxReinforced);
        GameRegistry.registerCustomItemStack((String)"strongboxResonant", (ItemStack)strongboxResonant);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(strongboxBasic, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotTin", Character.valueOf('X'), Block.field_72077_au}));
        }
        if (enable[Types.HARDENED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(strongboxHardened, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), strongboxBasic}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(strongboxHardened, new Object[]{"IYI", "YXY", "IYI", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), Block.field_72077_au, Character.valueOf('Y'), "ingotTin"}));
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(strongboxReinforced, new Object[]{" G ", "GXG", " G ", Character.valueOf('X'), strongboxHardened, Character.valueOf('G'), "glassHardened"}));
        }
        if (enable[Types.RESONANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(strongboxResonant, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), strongboxReinforced}));
        }
        return true;
    }

    static {
        String category = "block.feature";
        BlockStrongbox.enable[Types.CREATIVE.ordinal()] = ThermalExpansion.config.get(category, "Strongbox.Creative", true);
        BlockStrongbox.enable[Types.BASIC.ordinal()] = ThermalExpansion.config.get(category, "Strongbox.Basic", true);
        BlockStrongbox.enable[Types.HARDENED.ordinal()] = ThermalExpansion.config.get(category, "Strongbox.Hardened", true);
        BlockStrongbox.enable[Types.REINFORCED.ordinal()] = ThermalExpansion.config.get(category, "Strongbox.Reinforced", true);
        BlockStrongbox.enable[Types.RESONANT.ordinal()] = ThermalExpansion.config.get(category, "Strongbox.Resonant", true);
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

