/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tank;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.block.tank.TileTank;

public class TileTankCreative
extends TileTank {
    public static void initialize() {
        GameRegistry.registerTileEntity(TileTankCreative.class, (String)"cofh.thermalexpansion.TankCreative");
    }

    public TileTankCreative() {
    }

    public TileTankCreative(int metadata) {
        super(metadata);
    }

    @Override
    protected void transferFluid() {
        if (this.tank.getFluidAmount() <= 0 || this.adjacentHandlers[0] == null) {
            return;
        }
        this.adjacentHandlers[0].fill(ForgeDirection.VALID_DIRECTIONS[1], new FluidStack(this.tank.getFluid(), 1000), true);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from.ordinal() == 0 && this.mode == 1) {
            return 0;
        }
        if (from.ordinal() > 1 && from.ordinal() < 6) {
            return 0;
        }
        if (resource == null || resource.getFluid() == null || resource.isFluidEqual(this.tank.getFluid())) {
            return 0;
        }
        this.tank.setFluid(new FluidStack(resource.getFluid(), 1000));
        this.updateRender();
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from.ordinal() == 0 && this.mode == 1) {
            return null;
        }
        if (from.ordinal() > 1 && from.ordinal() < 6) {
            return null;
        }
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return resource.copy();
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.ordinal() == 0 && this.mode == 1) {
            return null;
        }
        if (from.ordinal() > 1 && from.ordinal() < 6) {
            return null;
        }
        if (this.tank.getFluid() == null) {
            return null;
        }
        return new FluidStack(this.tank.getFluid(), maxDrain);
    }
}

