/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.item;

import cofh.util.ItemHelper;
import cofh.util.StringHelper;
import cofh.util.inventory.InventoryCraftingFalse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thermalexpansion.item.TEItems;

public class SchematicHelper {
    public static NBTTagCompound getNBTForSchematic(IInventory craftSlots, ItemStack output) {
        NBTTagCompound theComp = new NBTTagCompound();
        for (int i = 0; i < 9 && i < craftSlots.func_70302_i_(); ++i) {
            if (craftSlots.func_70301_a(i) != null) {
                theComp.func_74768_a("Slot" + i + "Id", craftSlots.func_70301_a((int)i).field_77993_c);
                theComp.func_74768_a("Slot" + i + "Meta", craftSlots.func_70301_a(i).func_77960_j());
                theComp.func_74778_a("Slot" + i + "Name", craftSlots.func_70301_a(i).func_82833_r());
                String OreName = ItemHelper.getOreName((ItemStack)craftSlots.func_70301_a(i));
                if (OreName.equals("Unknown") || ItemHelper.isBlacklist((ItemStack)output)) continue;
                theComp.func_74778_a("Slot" + i + "Ore", OreName);
                continue;
            }
            theComp.func_74768_a("Slot" + i + "Id", -1);
            theComp.func_74768_a("Slot" + i + "Meta", -1);
            theComp.func_74778_a("Slot" + i + "Name", "");
        }
        theComp.func_74778_a("OutputName", output.field_77994_a + "x " + output.func_82833_r());
        return theComp;
    }

    public static ItemStack getSchematic(NBTTagCompound nbt) {
        ItemStack returnStack = TEItems.diagramSchematic.func_77946_l();
        returnStack.field_77990_d = nbt;
        return returnStack;
    }

    public static String getOutputName(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("OutputName")) {
            return ": " + stack.field_77990_d.func_74779_i("OutputName");
        }
        return "";
    }

    public static ItemStack getOutput(ItemStack schematic, World world) {
        InventoryCraftingFalse tempCraft = new InventoryCraftingFalse(3, 3);
        for (int i = 0; i < 9; ++i) {
            tempCraft.func_70299_a(i, SchematicHelper.getSchematicSlot(schematic, i));
        }
        return ItemHelper.findMatchingRecipe((InventoryCrafting)tempCraft, (World)world);
    }

    public static ItemStack getSchematicSlot(ItemStack schematic, int slot) {
        if (schematic == null) {
            return null;
        }
        if (schematic.field_77990_d != null && schematic.field_77990_d.func_74764_b("Slot" + slot + "Id") && schematic.field_77990_d.func_74762_e("Slot" + slot + "Id") > -1) {
            return new ItemStack(schematic.field_77990_d.func_74762_e("Slot" + slot + "Id"), 1, schematic.field_77990_d.func_74762_e("Slot" + slot + "Meta"));
        }
        return null;
    }

    public static String getSchematicOreSlot(ItemStack schematic, int slot) {
        if (schematic.field_77990_d != null && schematic.field_77990_d.func_74764_b("Slot" + slot + "Ore")) {
            return schematic.field_77990_d.func_74779_i("Slot" + slot + "Ore");
        }
        return null;
    }

    public static boolean isSchematic(ItemStack stack) {
        return stack == null ? false : stack.field_77993_c == TEItems.diagramSchematic.field_77993_c && stack.func_77960_j() == 0;
    }

    public static void addSchematicInformation(List list, ItemStack schematic) {
        if (schematic.field_77990_d == null) {
            list.add(StringHelper.getInfoText((String)"info.cofh.blank"));
            return;
        }
        boolean hasOre = false;
        HashMap<String, Integer> aMap = new HashMap<String, Integer>();
        for (int i = 0; i < 9; ++i) {
            String curName;
            if (!schematic.field_77990_d.func_74764_b("Slot" + i + "Name") || schematic.field_77990_d.func_74779_i("Slot" + i + "Name").equalsIgnoreCase("")) continue;
            if (schematic.field_77990_d.func_74764_b("Slot" + i + "Ore")) {
                hasOre = true;
                if (StringHelper.isShiftKeyDown()) {
                    curName = schematic.field_77990_d.func_74779_i("Slot" + i + "Ore");
                    if (aMap.containsKey(curName)) {
                        aMap.put(curName, (Integer)aMap.get(curName) + 1);
                        continue;
                    }
                    aMap.put(curName, 1);
                    continue;
                }
            }
            if (aMap.containsKey(curName = schematic.field_77990_d.func_74779_i("Slot" + i + "Name"))) {
                aMap.put(curName, (Integer)aMap.get(curName) + 1);
                continue;
            }
            aMap.put(curName, 1);
        }
        for (Map.Entry entry : aMap.entrySet()) {
            list.add("\u00a77" + entry.getValue() + "x " + (String)entry.getKey());
        }
        if (hasOre && StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForInfo);
        }
    }
}

