/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.fluid;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.FluidHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.Grid;
import thermalexpansion.part.conduit.GridTickHandler;
import thermalexpansion.part.conduit.IConduit;
import thermalexpansion.part.conduit.fluid.GridFluid;

public class ConduitFluid
extends ConduitBase
implements IFluidHandler {
    protected static int guiId;
    public boolean isWhitelist;
    public boolean useNBT;
    public FluidStack[] filterStacks;
    IFluidHandler[] importantCache = new IFluidHandler[6];
    GridFluid myGrid;
    public FluidStack mySavedFluid;
    public FluidStack myRenderFluid = new FluidStack(0, 0);
    public FluidStack fluidForGrid;
    public FluidStack myConnectionFluid;
    static int[] sideTypes;
    static int[] modeTypes;
    static int[] modeTypesPowered;
    boolean passFilter;
    FluidStack lastFluid;
    static boolean[] _DOES_RENDER;
    static int[] _TYPE;
    static int[] _RENDER_TYPE;

    public static void initialize() {
        guiId = ThermalExpansion.proxy.registerGui("FluidFilter", "conduit", "TEBase", null, true);
    }

    public ConduitFluid(byte type) {
        super(type);
    }

    @Override
    public boolean isImportant(TileEntity curTile, int side) {
        return FluidHelper.isFluidHandler((TileEntity)curTile) && !(curTile instanceof IConduit);
    }

    @Override
    public boolean isConduit(TileEntity curTile) {
        return curTile instanceof IConduit && ((IConduit)curTile).isFluidConduit() && FluidHelper.isFluidEqualOrNull((FluidStack)this.getConnectionFluid(), (FluidStack)((IConduit)curTile).getConduitFluid().getConnectionFluid());
    }

    public FluidStack getConnectionFluid() {
        return this.myGrid == null ? this.myConnectionFluid : this.myGrid.getFluid();
    }

    @Override
    public void cacheImportant(TileEntity theTile, int side) {
        this.importantCache[side] = (IFluidHandler)theTile;
        this.cacheType[side] = ConduitBase.CacheTypes.IMPORTANT;
    }

    @Override
    public Grid createNewGrid() {
        return new GridFluid(this);
    }

    @Override
    public void tileUnloading() {
        if (this.isNode && this.mySavedFluid != null && this.myGrid != null) {
            this.myGrid.myTank.drain(this.mySavedFluid.amount, true);
        }
    }

    @Override
    public void setGrid(Grid newGrid) {
        super.setGrid(newGrid);
        this.myGrid = (GridFluid)newGrid;
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        byte type = payload.getByte();
        if (type == PacketIds.SET_FILTER.ordinal()) {
            if (this.filterStacks == null) {
                this.filterStacks = new FluidStack[9];
            }
            this.filterStacks[payload.getByte()] = payload.getFluidStack();
            this.sendFilterPacket(handler.getPlayer());
            this.checkEmptyFilters();
            this.lastFluid = null;
        } else if (type == PacketIds.FILTERS.ordinal()) {
            this.filterStacks = new FluidStack[9];
            for (int i = 0; i < this.filterStacks.length; ++i) {
                this.filterStacks[i] = payload.getFluidStack();
            }
        } else if (type == PacketIds.GUI_BUTTON.ordinal()) {
            this.isWhitelist = payload.getBool();
            this.useNBT = payload.getBool();
            this.lastFluid = null;
        } else if (type == PacketIds.UPDATE_RENDER.ordinal()) {
            this.myRenderFluid = payload.getFluidStack();
            this.tile().markRender();
            this.world().func_72969_x(this.x(), this.y(), this.z());
        }
    }

    @Override
    public void writeDesc(MCDataOutput payload) {
        super.writeDesc(payload);
        if (this.myGrid != null) {
            payload.writeFluidStack(this.myGrid.getRenderFluid());
        } else {
            payload.writeFluidStack(new FluidStack(0, 0));
        }
        payload.writeBoolean(this.isWhitelist);
        payload.writeBoolean(this.useNBT);
    }

    @Override
    public void readDesc(MCDataInput payload) {
        super.readDesc(payload);
        this.myRenderFluid = payload.readFluidStack();
        this.isWhitelist = payload.readBoolean();
        this.useNBT = payload.readBoolean();
        if (this.world() != null) {
            this.world().func_72969_x(this.x(), this.y(), this.z());
        }
    }

    @Override
    public void doOutput() {
        if (this.myGrid == null) {
            return;
        }
        if (this.isOutput && this.fluidPassesFiltering(this.myGrid.myTank.getFluid())) {
            int i;
            int fluid = this.myGrid.toDistribute;
            for (i = this.sideTracker; i < 6 && fluid > 0; fluid -= this.transfer(i, fluid), ++i) {
            }
            for (i = 0; i < this.sideTracker && fluid > 0; fluid -= this.transfer(i, fluid), ++i) {
            }
        }
        this.increaseTracker();
    }

    protected int transfer(int bSide, int available) {
        IFluidHandler theTile;
        if (this.sideType[bSide] == 2 && this.sideMode[bSide] == 1 && (theTile = this.getImportant(bSide)) != null && this.myGrid.myTank.getFluid() != null) {
            FluidStack tempFluid = this.myGrid.myTank.getFluid().copy();
            tempFluid.amount = available;
            int amountSent = theTile.fill(ForgeDirection.VALID_DIRECTIONS[bSide ^ 1], tempFluid, false);
            if (amountSent > 0) {
                return theTile.fill(ForgeDirection.VALID_DIRECTIONS[bSide ^ 1], this.myGrid.myTank.drain(amountSent, true), true);
            }
        }
        return 0;
    }

    @Override
    public void doInput() {
        if (this.myGrid == null) {
            return;
        }
        if (this.isInput) {
            if (this.redstoneControlOrDisable()) {
                int i;
                for (i = this.sideTracker; i < 6; ++i) {
                    this.inputFluid(i);
                }
                for (i = 0; i < this.sideTracker; ++i) {
                    this.inputFluid(i);
                }
            }
            if (!this.isOutput) {
                this.increaseTracker();
            }
        }
    }

    public void inputFluid(int side) {
        int maxInput;
        FluidStack returned;
        if (this.sideType[side] != 2 || this.sideMode[side] != 2) {
            return;
        }
        IFluidHandler theTile = this.getImportant(side);
        if (theTile != null && this.fluidPassesFiltering(returned = theTile.drain(ForgeDirection.VALID_DIRECTIONS[side ^ 1], maxInput = Math.min(this.myGrid.myTank.getSpace(), this.myGrid.myTank.fluidThroughput), false))) {
            if (this.myGrid.myTank.getFluid() == null || this.myGrid.myTank.getFluid().fluidID == 0) {
                this.myGrid.myTank.setFluid(theTile.drain(ForgeDirection.VALID_DIRECTIONS[side ^ 1], maxInput, true).copy());
            } else if (this.myGrid.myTank.getFluid().isFluidEqual(returned)) {
                this.myGrid.myTank.getFluid().amount += theTile.drain((ForgeDirection)ForgeDirection.VALID_DIRECTIONS[side ^ 1], (int)maxInput, (boolean)true).copy().amount;
            }
        }
    }

    public IFluidHandler getImportant(int side) {
        if (this.cacheType[side] == ConduitBase.CacheTypes.NOT_SET) {
            TileEntity adjTile = BlockHelper.getAdjacentTileEntity((TileEntity)this.tile(), (int)side);
            if (adjTile instanceof IFluidHandler) {
                this.importantCache[side] = (IFluidHandler)adjTile;
                this.cacheType[side] = ConduitBase.CacheTypes.IMPORTANT;
            } else {
                this.sideType[side] = 0;
            }
        }
        return this.importantCache[side];
    }

    @Override
    public void getTileInfo(List<String> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        if (debug) {
            info.add(this.gridBase == null ? "Grid Null" : "Conduits: " + this.gridBase.conduitSet.size() + ", Nodes: " + this.gridBase.nodeSet.size());
            info.add("isInput: " + this.isInput + " - isOutput: " + this.isOutput);
            info.add("SideCache: " + Arrays.toString(this.sideType));
            if (this.gridBase != null) {
                info.add("Grid Ticking: " + GridTickHandler.tickingGrids.contains(this.gridBase));
            }
            return;
        }
        if (this.gridBase == null) {
            info.add("Null Grid");
            return;
        }
        if (this.myGrid.myTank.getFluid() == null || this.myGrid.myTank.getFluid().fluidID == 0) {
            info.add("Fluid: Empty");
            return;
        }
        info.add("Fluid: " + StringHelper.getFluidName((FluidStack)this.myGrid.myTank.getFluid()));
        info.add("Amount: " + this.myGrid.myTank.getFluidAmount() + "/" + this.myGrid.myTank.getCapacity() + " mB");
        info.add("Throughput: " + this.myGrid.myTank.fluidThroughput + "mB/t");
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.myGrid != null && this.myGrid.hasValidFluid()) {
            if (this.isNode) {
                this.mySavedFluid = this.myGrid.getNodeShare(this);
                this.mySavedFluid.writeToNBT(nbt);
            } else {
                this.mySavedFluid = null;
            }
            nbt.func_74766_a("ConnFluid", new NBTTagCompound());
            this.myConnectionFluid = this.myGrid.getFluid().copy();
            this.myConnectionFluid.writeToNBT(nbt.func_74775_l("ConnFluid"));
        } else {
            this.mySavedFluid = null;
            this.myConnectionFluid = null;
        }
        if (this.hasServo) {
            if (this.filterStacks != null) {
                for (int i = 0; i < this.filterStacks.length; ++i) {
                    if (this.filterStacks[i] == null) continue;
                    nbt.func_74766_a("Filter" + i, this.filterStacks[i].writeToNBT(new NBTTagCompound()));
                }
            }
            nbt.func_74757_a("isWhitelist", this.isWhitelist);
            nbt.func_74757_a("useNBT", this.useNBT);
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.fluidForGrid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        if (nbt.func_74764_b("ConnFluid")) {
            this.myConnectionFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("ConnFluid"));
        }
        if (this.fluidForGrid != null && this.fluidForGrid.fluidID == 0) {
            this.fluidForGrid = null;
        }
        if (this.hasServo) {
            for (int i = 0; i < 9; ++i) {
                if (!nbt.func_74764_b("Filter" + i)) continue;
                if (this.filterStacks == null) {
                    this.filterStacks = new FluidStack[9];
                }
                this.filterStacks[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Filter" + i));
            }
            this.isWhitelist = nbt.func_74767_n("isWhitelist");
            this.useNBT = nbt.func_74767_n("useNBT");
        }
        this.updateInternalTypes();
    }

    @Override
    public void servoInstalled(int side) {
        if (this.isOutput && !this.isInput) {
            this.setRedstoneConfig(true, false);
            this.sendDescUpdate();
        }
    }

    @Override
    public boolean punchMiddle(EntityPlayer player, int hitSide) {
        if (CoreUtils.isFakePlayer((EntityPlayer)player) || !this.hasServo) {
            return false;
        }
        if (this.isNode) {
            this.sendFilterPacket(player);
            player.openGui((Object)ThermalExpansion.instance, guiId, this.world(), this.x(), this.y(), this.z());
            return true;
        }
        return false;
    }

    @Override
    public void wrenchSide(EntityPlayer player, int subHit) {
        if (this.sideType[subHit] == 2) {
            int n = subHit;
            byte by = (byte)(this.sideMode[n] + 1);
            this.sideMode[n] = by;
            this.sideMode[subHit] = (byte)(by % 3);
            this.updateInternalTypes();
            this.onNeighborChangedRS();
            this.sendDescUpdate();
        }
    }

    @Override
    public boolean isFluidConduit() {
        return true;
    }

    @Override
    public ConduitFluid getConduitFluid() {
        return this;
    }

    public FluidStack getRenderFluid() {
        return this.myRenderFluid;
    }

    public int getRenderFluidLevel() {
        return this.myRenderFluid == null ? 0 : this.myRenderFluid.amount;
    }

    @Override
    public int getRenderType() {
        return _RENDER_TYPE[this.conduitType];
    }

    @Override
    public int getConnectionType(int side) {
        return this.sideType[side] == 2 ? (this.redstoneControlOrDisable() ? modeTypesPowered[this.sideMode[side]] : modeTypes[this.sideMode[side]]) : sideTypes[this.sideType[side]];
    }

    public int getLightValue() {
        if (!_DOES_RENDER[this.conduitType]) {
            return 0;
        }
        if (ServerHelper.isClientWorld((World)this.world())) {
            return FluidHelper.getFluidLuminosity((FluidStack)this.myRenderFluid);
        }
        if (this.myGrid != null) {
            return FluidHelper.getFluidLuminosity((FluidStack)this.myGrid.getFluid());
        }
        return 0;
    }

    public void updateFluid() {
        if (_DOES_RENDER[this.conduitType]) {
            this.sendRenderPacket();
        }
    }

    public void sendRenderPacket() {
        if (this.myGrid == null) {
            return;
        }
        Payload myPayload = Payload.getInfoPayload((TileEntity)this.tile());
        myPayload.addByte(PacketIds.UPDATE_RENDER.ordinal());
        myPayload.addFluidStack(this.myGrid.getRenderFluid());
        PacketUtils.sendToPlayers((Packet)myPayload.getPacket(), (TileEntity)this.tile());
    }

    public boolean fluidPassesFiltering(FluidStack theFluid) {
        if (theFluid == null || theFluid.fluidID == 0) {
            return false;
        }
        if (!this.hasServo) {
            return true;
        }
        if (!this.redstoneControlOrDisable()) {
            return false;
        }
        if (this.filterStacks == null) {
            return true;
        }
        if (theFluid.isFluidEqual(this.lastFluid)) {
            return this.passFilter;
        }
        boolean isNull = true;
        this.lastFluid = theFluid.copy();
        this.passFilter = this.isWhitelist;
        for (int i = 0; i < this.filterStacks.length; ++i) {
            if (this.filterStacks[i] == null) continue;
            isNull = false;
            if (!(this.useNBT ? this.filterStacks[i].isFluidEqual(theFluid) : this.filterStacks[i].fluidID == theFluid.fluidID)) continue;
            return this.passFilter;
        }
        this.passFilter = !this.isWhitelist || isNull;
        return this.passFilter;
    }

    public boolean isExistingFilter(FluidStack theFluid) {
        if (theFluid == null) {
            return true;
        }
        if (this.filterStacks == null) {
            return false;
        }
        for (int i = 0; i < this.filterStacks.length; ++i) {
            if (this.filterStacks[i] == null || !(this.useNBT ? this.filterStacks[i].isFluidEqual(theFluid) : this.filterStacks[i].fluidID == theFluid.fluidID)) continue;
            return true;
        }
        return false;
    }

    public void setFilter(int slotID, FluidStack theStack) {
        if (!this.isExistingFilter(theStack) || theStack == null) {
            Payload myPayload = Payload.getInfoPayload((TileEntity)this.tile());
            myPayload.addByte(PacketIds.SET_FILTER.ordinal());
            myPayload.addByte(slotID);
            myPayload.addFluidStack(theStack);
            PacketUtils.sendToServer((Packet)myPayload.getPacket());
        }
    }

    public void checkEmptyFilters() {
        if (this.filterStacks == null) {
            return;
        }
        for (int i = 0; i < this.filterStacks.length; ++i) {
            if (this.filterStacks[i] == null) continue;
            return;
        }
        this.filterStacks = null;
    }

    public void sendFilterPacket(EntityPlayer thePlayer) {
        if (this.filterStacks == null) {
            return;
        }
        Payload myPayload = Payload.getInfoPayload((TileEntity)this.tile());
        myPayload.addByte(PacketIds.FILTERS.ordinal());
        for (int i = 0; i < this.filterStacks.length; ++i) {
            myPayload.addFluidStack(this.filterStacks[i]);
        }
        PacketUtils.sendToPlayer((Packet)myPayload.getPacket(), (EntityPlayer)thePlayer);
    }

    @Override
    public String getType() {
        return "ConduitFluid" + this.conduitType;
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack((Item)TEItems.itemConduits, 1, this.conduitType + 2048);
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        LinkedList<ItemStack> myList = new LinkedList<ItemStack>();
        if (this.hasServo) {
            myList.add(TEItems.pneumaticServo.func_77946_l());
        }
        myList.add(new ItemStack((Item)TEItems.itemConduits, 1, this.conduitType + 2048));
        return myList;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.myGrid != null && this.sideType[from.ordinal()] == 2 && this.sideMode[from.ordinal()] == 1 && this.fluidPassesFiltering(resource)) {
            return this.myGrid.myTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.myGrid != null && this.sideType[from.ordinal()] == 2 && this.sideMode[from.ordinal()] == 1 && this.fluidPassesFiltering(resource)) {
            return this.myGrid.myTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.myGrid != null && this.sideType[from.ordinal()] == 2 && this.sideMode[from.ordinal()] == 1) {
            return this.myGrid.myTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.sideType[from.ordinal()] == 2 && this.sideMode[from.ordinal()] != 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.sideType[from.ordinal()] == 2 && this.sideMode[from.ordinal()] == 1;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (this.myGrid != null) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.myGrid.myTank.getInfo();
        } else {
            fluidTankInfoArray = TEProps.EMPTY_TANK_INFO;
        }
        return fluidTankInfoArray;
    }

    static {
        sideTypes = new int[3];
        modeTypes = new int[3];
        modeTypesPowered = new int[3];
        ConduitFluid.sideTypes[1] = BlockConduit.ConnectionTypes.CONDUIT.ordinal();
        ConduitFluid.sideTypes[0] = BlockConduit.ConnectionTypes.NONE.ordinal();
        ConduitFluid.modeTypes[0] = BlockConduit.ConnectionTypes.FLUID_BLOCKED.ordinal();
        ConduitFluid.modeTypes[1] = BlockConduit.ConnectionTypes.FLUID_NORMAL.ordinal();
        ConduitFluid.modeTypes[2] = BlockConduit.ConnectionTypes.FLUID_INPUT_OFF.ordinal();
        ConduitFluid.modeTypesPowered[0] = BlockConduit.ConnectionTypes.FLUID_BLOCKED.ordinal();
        ConduitFluid.modeTypesPowered[1] = BlockConduit.ConnectionTypes.FLUID_NORMAL.ordinal();
        ConduitFluid.modeTypesPowered[2] = BlockConduit.ConnectionTypes.FLUID_INPUT_ON.ordinal();
        _DOES_RENDER = new boolean[]{true, false};
        _TYPE = new int[]{BlockConduit.ConduitTypes.FLUID_TRANS.ordinal(), BlockConduit.ConduitTypes.FLUID_OPAQUE.ordinal()};
        _RENDER_TYPE = new int[]{BlockConduit.RenderTypes.FLUID_TRANS.ordinal(), BlockConduit.RenderTypes.FLUID_OPAQUE.ordinal()};
    }

    public static enum PacketIds {
        SET_FILTER,
        GUI_BUTTON,
        FILTERS,
        UPDATE_RENDER;

    }
}

