/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.fluid;

import cofh.util.MathHelper;
import cofh.util.fluid.FluidTankAdv;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.part.conduit.fluid.GridFluid;

public class FluidTankGrid
extends FluidTankAdv {
    public int fluidThroughput = 120;
    public int fluidPerConduit = 3000;
    public GridFluid myMaster;

    public FluidTankGrid(int capacity, GridFluid theGrid) {
        super(capacity);
        this.myMaster = theGrid;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid != null) {
            this.setFluidData(fluid);
        }
        super.setFluid(fluid);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.fluid == null && resource != null) {
            this.setFluidData(resource);
        }
        return super.fill(resource, doFill);
    }

    public void setFluidData(FluidStack fluid) {
        int viscosity = 0;
        if (fluid != null) {
            viscosity = FluidRegistry.getFluid((int)fluid.fluidID).getViscosity();
        }
        this.fluidThroughput = MathHelper.clampI((int)(120000 / viscosity), (int)80, (int)400);
        Integer flowRate = TEFluids.fluidFlowrate.get(fluid.getFluid().getName());
        if (flowRate != null) {
            this.fluidThroughput = flowRate;
        }
        this.fluidPerConduit = 25 * this.fluidThroughput;
        this.myMaster.fluidChanged();
    }
}

