/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;

public class RenderDynamo
implements ISimpleBlockRenderingHandler {
    public static final RenderDynamo instance = new RenderDynamo();
    static Icon textureCoil;
    static Icon[] textureBase;
    static CCModel[][] modelCoil;
    static CCModel[][] modelBase;
    static CCModel[] modelAnimation;

    public static void initialize() {
        textureCoil = IconRegistry.getIcon((String)"DynamoCoilRedstone");
        for (int i = 0; i < textureBase.length; ++i) {
            RenderDynamo.textureBase[i] = IconRegistry.getIcon((String)"Dynamo", (int)i);
        }
    }

    private static void generateModels() {
        int i;
        double d1 = 0.001953125;
        double d2 = 0.375;
        double d3 = 0.625;
        RenderDynamo.modelCoil[0][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 0.0, -4.0, 8.0, 8.0, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0).computeNormals();
        RenderDynamo.modelCoil[1][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 0.0, -4.0, 8.0, 8.0, 8.0, 0.0, 16.0, 32.0, 32.0, 16.0).computeNormals();
        RenderDynamo.modelBase[0][1] = CCModel.quadModel((int)24).generateBox(0, -8.0, -8.0, -8.0, 16.0, 10.0, 16.0, 0.0, 0.0, 64.0, 64.0, 16.0).computeNormals();
        RenderDynamo.modelBase[1][1] = CCModel.quadModel((int)24).generateBox(0, -8.0, -8.0, -8.0, 16.0, 10.0, 16.0, 0.0, 32.0, 64.0, 64.0, 16.0).computeNormals();
        RenderDynamo.modelAnimation[0] = CCModel.quadModel((int)16).generateBlock(0, d1, d2 - d1, d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 3).computeNormals();
        RenderDynamo.modelAnimation[1] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, 1.0 - d1, d3 - d1, 1.0 - d1, 3).computeNormals();
        RenderDynamo.modelAnimation[2] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d2 - d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 12).computeNormals();
        RenderDynamo.modelAnimation[3] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, 1.0 - d1, 1.0 - d1, d3 - d1, 12).computeNormals();
        RenderDynamo.modelAnimation[4] = CCModel.quadModel((int)16).generateBlock(0, d2 - d1, d1, d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 48).computeNormals();
        RenderDynamo.modelAnimation[5] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, d3 - d1, 1.0 - d1, 1.0 - d1, 48).computeNormals();
        for (i = 0; i < modelCoil.length; ++i) {
            CCModel.generateSidedModels((CCModel[])modelCoil[i], (int)1, (Vector3)new Vector3());
        }
        for (i = 0; i < modelBase.length; ++i) {
            CCModel.generateSidedModels((CCModel[])modelBase[i], (int)1, (Vector3)new Vector3());
        }
    }

    public void renderCoil(int facing, boolean active, double x, double y, double z) {
        Translation trans = RenderUtils.getRenderVector((double)(x += 0.5), (double)(y += 0.5), (double)(z += 0.5)).translation();
        if (active) {
            modelCoil[0][facing].render((Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureCoil));
        } else {
            modelCoil[1][facing].render((Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureCoil));
        }
    }

    public void renderBase(int facing, boolean active, int type, double x, double y, double z) {
        Translation trans = RenderUtils.getRenderVector((double)(x += 0.5), (double)(y += 0.5), (double)(z += 0.5)).translation();
        if (active) {
            modelBase[0][facing].render((Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureBase[type]));
        } else {
            modelBase[1][facing].render((Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureBase[type]));
        }
    }

    public void renderAnimation(int facing, boolean active, int type, Icon icon, double x, double y, double z) {
        if (active) {
            modelAnimation[facing].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)icon));
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.renderCoil(1, false, -0.5, -0.5, -0.5);
        this.renderBase(1, false, metadata, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileDynamoBase)) {
            return false;
        }
        TileDynamoBase theTile = (TileDynamoBase)tile;
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        this.renderCoil(theTile.getFacing(), theTile.isActive(), x, y, z);
        this.renderAnimation(theTile.getFacing(), theTile.isActive(), theTile.getType(), theTile.getActiveIcon(), x, y, z);
        this.renderBase(theTile.getFacing(), theTile.isActive(), theTile.getType(), x, y, z);
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdDynamo;
    }

    static {
        textureBase = new Icon[BlockDynamo.Types.values().length];
        modelCoil = new CCModel[2][6];
        modelBase = new CCModel[2][6];
        modelAnimation = new CCModel[6];
        TEProps.renderIdDynamo = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        RenderDynamo.generateModels();
    }
}

