/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.ItemHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.StatBase;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.core.TEAchievements;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;

public class TECraftingHandler
implements ICraftingHandler {
    public static TECraftingHandler instance = new TECraftingHandler();

    public static void initialize() {
        GameRegistry.registerCraftingHandler((ICraftingHandler)instance);
    }

    public void onCrafting(EntityPlayer player, ItemStack stack, IInventory craftMatrix) {
        if (stack == null) {
            return;
        }
        this.checkAchievements(player, stack, craftMatrix);
    }

    public void onSmelting(EntityPlayer player, ItemStack stack) {
    }

    private void checkAchievements(EntityPlayer player, ItemStack stack, IInventory craftMatrix) {
        if (!TEProps.enableAchievements) {
            return;
        }
        if (stack.func_77969_a(BlockMachine.machineFrame)) {
            player.func_71064_a((StatBase)TEAchievements.machineFrame, 1);
        } else if (stack.func_77969_a(BlockMachine.furnace)) {
            player.func_71064_a((StatBase)TEAchievements.furnace, 1);
        } else if (stack.func_77969_a(BlockMachine.pulverizer)) {
            player.func_71064_a((StatBase)TEAchievements.pulverizer, 1);
        } else if (stack.func_77969_a(BlockMachine.sawmill)) {
            player.func_71064_a((StatBase)TEAchievements.sawmill, 1);
        } else if (stack.func_77969_a(BlockMachine.smelter)) {
            player.func_71064_a((StatBase)TEAchievements.smelter, 1);
        } else if (stack.func_77969_a(BlockMachine.crucible)) {
            player.func_71064_a((StatBase)TEAchievements.crucible, 1);
        } else if (stack.func_77969_a(BlockMachine.transposer)) {
            player.func_71064_a((StatBase)TEAchievements.transposer, 1);
        } else if (stack.func_77969_a(BlockMachine.iceGen)) {
            player.func_71064_a((StatBase)TEAchievements.iceGen, 1);
        } else if (stack.func_77969_a(BlockMachine.rockGen)) {
            player.func_71064_a((StatBase)TEAchievements.rockGen, 1);
        } else if (stack.func_77969_a(BlockMachine.waterGen)) {
            player.func_71064_a((StatBase)TEAchievements.waterGen, 1);
        } else if (stack.func_77969_a(BlockMachine.assembler)) {
            player.func_71064_a((StatBase)TEAchievements.assembler, 1);
        } else if (stack.func_77969_a(BlockMachine.charger)) {
            player.func_71064_a((StatBase)TEAchievements.charger, 1);
        }
    }

    public static void loadRecipes() {
        String[] oreNameList = OreDictionary.getOreNames();
        String oreType = "";
        for (int i = 0; i < oreNameList.length; ++i) {
            if (!oreNameList[i].startsWith("ore")) continue;
            oreType = oreNameList[i].substring(3, oreNameList[i].length());
            String oreName = "ore" + StringHelper.titleCase((String)oreType);
            String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
            ArrayList registeredOre = OreDictionary.getOres((String)oreName);
            ArrayList registeredIngot = OreDictionary.getOres((String)ingotName);
            if (registeredOre.size() <= 0 || registeredIngot.size() <= 0) continue;
            ItemStack ingot = ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)1);
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(ingot, new Object[]{oreName, TEItems.dustPyrotheum}));
        }
    }
}

