/*
 * Decompiled with CFR 0.152.
 */
package com.voidzm.novamenu.asm;

import com.voidzm.novamenu.asm.ClassMethodVisitor;
import com.voidzm.novamenu.asm.DisplayGuiScreenMethodVisitor;
import com.voidzm.novamenu.asm.NovamenuPlugin;
import com.voidzm.novamenu.asm.ReobfuscationMappingHelper;
import cpw.mods.fml.common.asm.transformers.AccessTransformer;
import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class NovamenuTransformer
extends AccessTransformer {
    protected static boolean doVerboseTransformer;
    private boolean minecraftTransformed = false;

    public NovamenuTransformer() throws IOException {
        System.out.println("[Novamenu] ASM transformer initializing.");
        doVerboseTransformer = Boolean.parseBoolean(System.getProperty("novamenu.doVerboseTransformer", "false"));
        if (doVerboseTransformer) {
            System.out.println("[Novamenu] Verbose ASM transformer enabled as a JVM parameter.");
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        try {
            bytes = this.transformMinecraft(name, bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    private byte[] transformMinecraft(String name, byte[] bytes) {
        String className;
        if (this.minecraftTransformed) {
            return bytes;
        }
        String string = className = NovamenuPlugin.isDevEnvironment ? "net.minecraft.client.Minecraft" : ReobfuscationMappingHelper.getInstance().attemptRemapClassName("net.minecraft.client.Minecraft");
        if (doVerboseTransformer) {
            System.out.println("Locating Minecraft.class; comparing " + name + " to target " + className + ".");
        }
        if (name.equals(className)) {
            if (doVerboseTransformer) {
                System.out.println("Minecraft.class located under " + name);
            }
            ClassReader cr = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(0);
            String methodName = NovamenuPlugin.isDevEnvironment ? "displayGuiScreen" : ReobfuscationMappingHelper.getInstance().attemptRemapMethodName("net.minecraft.client.Minecraft/displayGuiScreen");
            String methodDesc = NovamenuPlugin.isDevEnvironment ? "(Lnet/minecraft/client/gui/GuiScreen;)V" : "(L" + ReobfuscationMappingHelper.getInstance().attemptRemapClassName("net.minecraft.client.gui.GuiScreen") + ";)V";
            ClassMethodVisitor cv = new ClassMethodVisitor((ClassVisitor)cw, methodName, methodDesc, DisplayGuiScreenMethodVisitor.class);
            cr.accept((ClassVisitor)cv, 0);
            bytes = cw.toByteArray();
            this.minecraftTransformed = true;
        }
        return bytes;
    }
}

