/*
 * Decompiled with CFR 0.152.
 */
package com.voidzm.novamenu.asm;

import com.voidzm.novamenu.asm.NovamenuPlugin;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public class ReobfuscationMappingHelper {
    private static ReobfuscationMappingHelper instance;
    private HashMap<String, String> classes = new HashMap();
    private HashMap<String, String> methods = new HashMap();
    private HashMap<String, String> fields = new HashMap();

    public static ReobfuscationMappingHelper getInstance() {
        if (instance == null) {
            instance = new ReobfuscationMappingHelper();
        }
        return instance;
    }

    public ReobfuscationMappingHelper() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            InputStream istream = this.getClass().getResourceAsStream("/remap.csv");
            BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
            String current = null;
            while ((current = reader.readLine()) != null) {
                lines.add(current);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String versionIdentifier = (String)lines.remove(0);
        if (!versionIdentifier.equals(NovamenuPlugin.minecraftVersion)) {
            throw new RuntimeException("The mappings in remap.csv DO NOT match the current Minecraft version! This version of Novamenu is likely out of date.");
        }
        for (String line : lines) {
            String[] values = line.split(",");
            if (values[0].equals("class")) {
                this.classes.put(values[1], values[2]);
                continue;
            }
            if (values[0].equals("method")) {
                this.methods.put(values[1], values[2]);
                continue;
            }
            if (!values[0].equals("field")) continue;
            this.fields.put(values[1], values[2]);
        }
    }

    public String attemptRemapClassName(String deobfName) {
        if (this.classes.containsKey(deobfName)) {
            return this.classes.get(deobfName);
        }
        return deobfName;
    }

    public String attemptRemapMethodName(String deobfName) {
        if (this.methods.containsKey(deobfName)) {
            return this.methods.get(deobfName);
        }
        return deobfName;
    }

    public String attemptRemapFieldName(String deobfName) {
        if (this.fields.containsKey(deobfName)) {
            return this.fields.get(deobfName);
        }
        return deobfName;
    }
}

