/*
 * Decompiled with CFR 0.152.
 */
package com.github.AbrarSyed.secretroomsmod.blocks;

import com.github.AbrarSyed.secretroomsmod.blocks.BlockCamoFull;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCamoWire
extends BlockCamoFull {
    private boolean shouldPower = true;

    public BlockCamoWire(int id) {
        super(id, Material.field_76265_p);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.field_94336_cN = par1IconRegister.func_94245_a("secretroomsmod:CamoRedstone");
    }

    @Override
    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        if (world.field_72995_K) {
            return;
        }
        this.calcPower(world, x, y, z);
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        super.func_71863_a(world, x, y, z, blockID);
        if (world.field_72995_K) {
            return;
        }
        this.calcPower(world, x, y, z);
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        super.func_71852_a(world, x, y, z, par5, par6);
        if (world.field_72995_K) {
            return;
        }
        world.func_72898_h(x, y, z, this.field_71990_ca);
    }

    private void calcPower(World world, int x, int y, int z) {
        int oldPower = world.func_72805_g(x, y, z);
        BlockCamoWire.setRedstoneProvidePower(false);
        this.shouldPower = false;
        int nonWirePower = world.func_94572_D(x, y, z);
        this.shouldPower = true;
        BlockCamoWire.setRedstoneProvidePower(true);
        int power = this.getInputPower(world, x, y, z);
        if (nonWirePower > 0 && nonWirePower > power - 1) {
            power = nonWirePower;
        } else if (power > 0) {
            --power;
        }
        if (oldPower != power) {
            world.func_72921_c(x, y, z, power, 2);
            world.func_72898_h(x, y, z, this.field_71990_ca);
        }
    }

    private int getInputPower(World world, int x, int y, int z) {
        int[] powers = new int[6];
        int power = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            power = 0;
            int pX = dir.offsetX + x;
            int pY = dir.offsetY + y;
            int pZ = dir.offsetZ + z;
            if (world.func_72799_c(pX, pY, pZ)) continue;
            Block block = Block.field_71973_m[world.func_72798_a(pX, pY, pZ)];
            if (block.field_71990_ca == Block.field_72075_av.field_71990_ca || block.field_71990_ca == this.field_71990_ca) {
                power = world.func_72805_g(pX, pY, pZ);
            } else if (block.func_96468_q_()) {
                power = block.func_94328_b_(world, pX, pY, pZ, dir.getOpposite().ordinal());
            } else if (block.func_71853_i()) {
                power = Math.max(block.func_71855_c((IBlockAccess)world, pX, pY, pZ, dir.getOpposite().ordinal()), block.func_71865_a((IBlockAccess)world, pX, pY, pZ, dir.getOpposite().ordinal()));
            }
            powers[dir.ordinal()] = power;
        }
        power = 0;
        for (int p : powers) {
            power = Math.max(power, p);
        }
        power = Math.max(power, world.func_94572_D(x, y, z));
        return power;
    }

    public static void setRedstoneProvidePower(boolean bool) {
        ObfuscationReflectionHelper.setPrivateValue(BlockRedstoneWire.class, (Object)Block.field_72075_av, (Object)bool, (int)0);
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_71853_i() ? world.func_72805_g(x, y, z) : 0;
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_71855_c(world, x, y, z, side);
    }

    public boolean func_71853_i() {
        return this.shouldPower;
    }
}

