/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.builders.BuildersProxy;
import buildcraft.builders.ItemBptBase;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.BptBase;
import buildcraft.core.blueprints.BptPlayerIndex;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileBlueprintLibrary
extends TileBuildCraft
implements IInventory {
    public static final int COMMAND_NEXT = 1;
    public static final int COMMAND_PREV = 2;
    public static final int COMMAND_LOCK_UPDATE = 3;
    public static final int COMMAND_DELETE = 4;
    public ItemStack[] stack = new ItemStack[4];
    public int progressIn = 0;
    public int progressOut = 0;
    public String owner = "";
    private ArrayList<BptBase> currentPage;
    @TileNetworkData(staticSize=12)
    public String[] currentNames = new String[12];
    @TileNetworkData
    public int selected = -1;
    @TileNetworkData
    public boolean locked = false;

    public TileBlueprintLibrary() {
        for (int i = 0; i < this.currentNames.length; ++i) {
            this.currentNames[i] = "";
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            this.setCurrentPage(this.getNextPage(null));
        }
    }

    public ArrayList<BptBase> getNextPage(String after) {
        ArrayList<BptBase> result = new ArrayList<BptBase>();
        BptPlayerIndex index = BuildCraftBuilders.getPlayerIndex(BuildersProxy.getOwner(this));
        String it = after;
        while (result.size() < 12 && (it = index.nextBpt(it)) != null) {
            BptBase bpt = BuildCraftBuilders.getBptRootIndex().getBluePrint(it);
            if (bpt == null) continue;
            result.add(bpt);
        }
        return result;
    }

    public ArrayList<BptBase> getPrevPage(String before) {
        ArrayList<BptBase> result = new ArrayList<BptBase>();
        BptPlayerIndex index = BuildCraftBuilders.getPlayerIndex(BuildersProxy.getOwner(this));
        String it = before;
        while (result.size() < 12 && (it = index.prevBpt(it)) != null) {
            BptBase bpt = BuildCraftBuilders.getBptRootIndex().getBluePrint(it);
            if (bpt == null) continue;
            result.add(bpt);
        }
        return result;
    }

    public void updateCurrentNames() {
        int i;
        this.currentNames = new String[12];
        for (i = 0; i < this.currentPage.size(); ++i) {
            this.currentNames[i] = this.currentPage.get(i).getName();
        }
        for (i = this.currentPage.size(); i < this.currentNames.length; ++i) {
            this.currentNames[i] = "";
        }
        this.sendNetworkUpdate();
    }

    public ArrayList<BptBase> getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(ArrayList<BptBase> newPage) {
        this.currentPage = newPage;
        this.selected = -1;
        this.updateCurrentNames();
    }

    public void setCurrentPage(boolean nextPage) {
        int index = 0;
        if (nextPage) {
            index = this.currentPage.size() - 1;
        }
        if (this.currentPage.size() > 0) {
            this.setCurrentPage(this.getNextPage(this.currentPage.get((int)index).file.getName()));
        } else {
            this.setCurrentPage(this.getNextPage(null));
        }
    }

    public void deleteSelectedBpt() {
        BptPlayerIndex index = BuildCraftBuilders.getPlayerIndex(BuildersProxy.getOwner(this));
        if (this.selected > -1 && this.selected < this.currentPage.size()) {
            index.deleteBluePrint(this.currentPage.get((int)this.selected).file.getName());
            this.currentPage = this.currentPage.size() > 0 ? this.getNextPage(index.prevBpt(this.currentPage.get((int)0).file.getName())) : this.getNextPage(null);
            this.selected = -1;
            this.updateCurrentNames();
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.owner = nbttagcompound.func_74779_i("owner");
        this.locked = nbttagcompound.func_74767_n("locked");
        Utils.readStacksFromNBT(nbttagcompound, "stack", this.stack);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74757_a("locked", this.locked);
        Utils.writeStacksToNBT(nbttagcompound, "stack", this.stack);
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return this.stack[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.stack[i] == null) {
            return null;
        }
        ItemStack res = this.stack[i].func_77979_a(j);
        if (this.stack[i].field_77994_a == 0) {
            this.stack[i] = null;
        }
        return res;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.stack[i] = itemstack;
        if (i == 0) {
            this.progressIn = this.stack[0] != null && this.stack[0].func_77973_b() instanceof ItemBptBase ? 1 : 0;
        }
        if (i == 2) {
            this.progressOut = this.stack[2] != null && this.stack[2].func_77973_b() instanceof ItemBptBase ? 1 : 0;
        }
    }

    public ItemStack func_70304_b(int slot) {
        if (this.stack[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.stack[slot];
        this.stack[slot] = null;
        return toReturn;
    }

    public String func_70303_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_70316_g() {
        BptBase bpt;
        super.func_70316_g();
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        if (this.progressIn > 0 && this.progressIn < 100) {
            ++this.progressIn;
        }
        if (this.progressOut > 0 && this.progressOut < 100) {
            ++this.progressOut;
        }
        if (this.progressIn == 100 && this.stack[1] == null) {
            this.func_70299_a(1, this.stack[0]);
            this.func_70299_a(0, null);
            bpt = BuildCraftBuilders.getBptRootIndex().getBluePrint(this.stack[1].func_77960_j());
            if (bpt != null) {
                BptPlayerIndex index = BuildCraftBuilders.getPlayerIndex(BuildersProxy.getOwner(this));
                try {
                    index.addBlueprint(bpt.file);
                    this.setCurrentPage(true);
                    this.setCurrentPage(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.progressOut == 100 && this.stack[3] == null) {
            if (this.selected > -1 && this.selected < this.currentPage.size()) {
                bpt = this.currentPage.get(this.selected);
                this.func_70299_a(3, BuildCraftBuilders.getBptItemStack(this.stack[2].field_77993_c, bpt.position, bpt.getName()));
            } else {
                this.func_70299_a(3, BuildCraftBuilders.getBptItemStack(this.stack[2].field_77993_c, 0, null));
            }
            this.func_70299_a(2, null);
        }
    }
}

