/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.filler.pattern;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.IBox;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.filler.IPatternIterator;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.StringUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class FillerPattern
implements IFillerPattern {
    public static final Set<FillerPattern> patterns = new HashSet<FillerPattern>();
    private final String tag;
    private Icon icon;

    public FillerPattern(String tag) {
        this.tag = tag;
        patterns.add(this);
    }

    public boolean iteratePattern(TileEntity tile, IBox box, ItemStack stackToPlace) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.localize("fillerpattern." + this.tag);
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:" + this.tag;
    }

    public void registerIcon(IconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:fillerPatterns/" + this.tag);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public String toString() {
        return "Pattern: " + this.getUniqueTag();
    }

    @Override
    public IPatternIterator createPatternIterator(TileEntity tile, IBox box, ForgeDirection orientation) {
        return new PatternIterator(tile, box);
    }

    public static boolean fill(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, ItemStack stackToPlace, World world) {
        boolean found = false;
        int lastX = 0;
        int lastY = 0;
        int lastZ = 0;
        for (int y = yMin; y <= yMax && !found; ++y) {
            for (int x = xMin; x <= xMax && !found; ++x) {
                for (int z = zMin; z <= zMax && !found; ++z) {
                    if (!BlockUtil.canChangeBlock(world, x, y, z)) {
                        return false;
                    }
                    if (!BlockUtil.isSoftBlock(world, x, y, z)) continue;
                    lastX = x;
                    lastY = y;
                    lastZ = z;
                    found = true;
                }
            }
        }
        if (found && stackToPlace != null) {
            FillerPattern.breakBlock(world, lastX, lastY, lastZ);
            stackToPlace.func_77973_b().func_77648_a(stackToPlace, CoreProxy.proxy.getBuildCraftPlayer(world), world, lastX, lastY - 1, lastZ, 1, 0.0f, 0.0f, 0.0f);
        }
        return found;
    }

    public static boolean empty(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, World world) {
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (int y = yMax; y >= yMin; --y) {
            boolean found = false;
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!BlockUtil.canChangeBlock(world, x, y, z)) {
                        return false;
                    }
                    if (BlockUtil.isSoftBlock(world, x, y, z)) continue;
                    found = true;
                    lastX = x;
                    lastY = y;
                    lastZ = z;
                }
            }
            if (found) break;
        }
        if (lastX != Integer.MAX_VALUE) {
            FillerPattern.breakBlock(world, lastX, lastY, lastZ);
            return true;
        }
        return false;
    }

    public static boolean flatten(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, World world, ItemStack stackToPlace) {
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        boolean found = false;
        for (int x = xMin; x <= xMax && !found; ++x) {
            for (int z = zMin; z <= zMax && !found; ++z) {
                int y = yMax;
                while (y >= yMin && BlockUtil.canChangeBlock(world, x, y, z) && BlockUtil.isSoftBlock(world, x, y, z)) {
                    found = true;
                    lastX = x;
                    lastY = y--;
                    lastZ = z;
                }
            }
        }
        if (found && stackToPlace != null) {
            FillerPattern.breakBlock(world, lastX, lastY, lastZ);
            stackToPlace.func_77973_b().func_77648_a(stackToPlace, CoreProxy.proxy.getBuildCraftPlayer(world), world, lastX, lastY - 1, lastZ, 1, 0.0f, 0.0f, 0.0f);
        }
        return found;
    }

    private static void breakBlock(World world, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block != null) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_72020_cn.func_82593_b(), (block.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, block.field_72020_cn.func_72678_c() * 0.8f);
        }
        if (BuildCraftBuilders.fillerDestroy) {
            world.func_94571_i(x, y, z);
        } else if (BlockUtil.isToughBlock(world, x, y, z)) {
            BlockUtil.breakBlock(world, x, y, z, BuildCraftBuilders.fillerLifespanTough);
        } else {
            BlockUtil.breakBlock(world, x, y, z, BuildCraftBuilders.fillerLifespanNormal);
        }
    }

    protected class PatternIterator
    implements IPatternIterator {
        private final IBox box;
        private final TileEntity tile;

        public PatternIterator(TileEntity tile, IBox box) {
            this.box = box;
            this.tile = tile;
        }

        @Override
        public boolean iteratePattern(ItemStack stackToPlace) {
            return FillerPattern.this.iteratePattern(this.tile, this.box, stackToPlace);
        }
    }
}

