/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketGuiReturn;
import buildcraft.core.network.PacketGuiWidget;
import buildcraft.core.network.PacketTileState;
import buildcraft.core.network.PacketTileUpdate;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandler
implements IPacketHandler {
    private void onTileUpdate(EntityPlayer player, PacketTileUpdate packet) throws IOException {
        World world = player.field_70170_p;
        if (!packet.targetExists(world)) {
            return;
        }
        TileEntity entity = packet.getTarget(world);
        if (!(entity instanceof ISynchronizedTile)) {
            return;
        }
        ISynchronizedTile tile = (ISynchronizedTile)entity;
        tile.handleUpdatePacket(packet);
        tile.postPacketHandling(packet);
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            int packetID = data.read();
            switch (packetID) {
                case 0: {
                    PacketTileUpdate pkt = new PacketTileUpdate();
                    pkt.readData(data);
                    this.onTileUpdate((EntityPlayer)player, pkt);
                    break;
                }
                case 100: {
                    PacketTileState pkt = new PacketTileState();
                    pkt.readData(data);
                    World world = ((EntityPlayer)player).field_70170_p;
                    TileEntity tile = world.func_72796_p(pkt.posX, pkt.posY, pkt.posZ);
                    if (!(tile instanceof ISyncedTile)) break;
                    pkt.applyStates(data, (ISyncedTile)tile);
                    break;
                }
                case 80: {
                    PacketGuiReturn pkt = new PacketGuiReturn((EntityPlayer)player);
                    pkt.readData(data);
                    break;
                }
                case 81: {
                    PacketGuiWidget pkt = new PacketGuiWidget();
                    pkt.readData(data);
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

