/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.PacketCoordinates;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class PacketSlotChange
extends PacketCoordinates {
    public int slot;
    public ItemStack stack;

    public PacketSlotChange() {
    }

    public PacketSlotChange(int id, int x, int y, int z, int slot, ItemStack stack) {
        super(id, x, y, z);
        this.slot = slot;
        this.stack = stack;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.slot);
        if (this.stack != null) {
            data.writeInt(this.stack.field_77993_c);
            data.writeInt(this.stack.field_77994_a);
            data.writeInt(this.stack.func_77960_j());
            if (this.stack.func_77942_o()) {
                byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)this.stack.func_77978_p());
                data.writeShort(compressed.length);
                data.write(compressed);
            } else {
                data.writeShort(0);
            }
        } else {
            data.writeInt(0);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.slot = data.readInt();
        int id = data.readInt();
        if (id != 0) {
            this.stack = new ItemStack(id, data.readInt(), data.readInt());
            short length = data.readShort();
            if (length > 0) {
                byte[] compressed = new byte[length];
                data.readFully(compressed);
                this.stack.func_77982_d(CompressedStreamTools.func_74792_a((byte[])compressed));
            }
        } else {
            this.stack = null;
        }
    }
}

