/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.energy.TileEngine;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public class TileEngineWood
extends TileEngine {
    public static final float OUTPUT = 0.05f;

    @Override
    public ResourceLocation getTextureFile() {
        return WOOD_TEXTURE;
    }

    @Override
    public float explosionRange() {
        return 1.0f;
    }

    @Override
    public float minEnergyReceived() {
        return 0.0f;
    }

    @Override
    public float maxEnergyReceived() {
        return 50.0f;
    }

    @Override
    protected TileEngine.EnergyStage computeEnergyStage() {
        float energyLevel = this.getEnergyLevel();
        if (energyLevel < 0.25f) {
            return TileEngine.EnergyStage.BLUE;
        }
        if (energyLevel < 0.5f) {
            return TileEngine.EnergyStage.GREEN;
        }
        if (energyLevel < 0.75f) {
            return TileEngine.EnergyStage.YELLOW;
        }
        return TileEngine.EnergyStage.RED;
    }

    @Override
    public float getPistonSpeed() {
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            return Math.max(0.08f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case GREEN: {
                return 0.02f;
            }
            case YELLOW: {
                return 0.04f;
            }
            case RED: {
                return 0.08f;
            }
        }
        return 0.01f;
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        if (this.isRedstonePowered && this.field_70331_k.func_82737_E() % 16L == 0L) {
            this.addEnergy(1.0f);
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public int getScaledBurnTime(int i) {
        return 0;
    }

    @Override
    public float getMaxEnergy() {
        return 100.0f;
    }

    @Override
    public float getCurrentOutput() {
        return 0.05f;
    }

    @Override
    public float maxEnergyExtracted() {
        return 1.01f;
    }
}

