/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.gui;

import cpw.mods.fml.client.FMLClientHandler;
import enhancedcore.gui.EnhancedCoreContainer;
import enhancedcore.gui.GuiItemStackButton;
import enhancedcore.gui.button.GuiBetterButton;
import enhancedcore.gui.slots.SlotBase;
import enhancedcore.gui.tooltips.ToolTip;
import enhancedcore.gui.tooltips.ToolTipLine;
import enhancedcore.util.MathHelper;
import enhancedcore.util.Properties;
import enhancedcore.util.SessionVars;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;

public abstract class GuiEnhancedCore
extends GuiContainer {
    protected LedgerManager ledgerManager = new LedgerManager(this);
    protected TileEntity tile;

    protected Minecraft getMinecraft() {
        return this.field_73882_e;
    }

    public GuiEnhancedCore(EnhancedCoreContainer container, IInventory inventory) {
        super((Container)container);
        if (inventory instanceof TileEntity) {
            this.tile = (TileEntity)inventory;
        }
        this.initLedgers(inventory);
    }

    public GuiEnhancedCore(EnhancedCoreContainer container, TileEntity inventory) {
        super((Container)container);
        this.tile = inventory;
        this.initLedgers(inventory);
    }

    protected void func_74189_g(int par1, int par2) {
        this.ledgerManager.drawLedgers(par1, par2);
        for (Object button : this.field_73887_h) {
            if (!(button instanceof GuiItemStackButton)) continue;
            ((GuiItemStackButton)((Object)button)).drawForeground(this.field_73882_e, par1 - this.field_74198_m, par2 - this.field_74197_n);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        boolean mouseOver;
        ToolTip tips;
        super.func_73863_a(mouseX, mouseY, par3);
        int left = this.field_74198_m;
        int top = this.field_74197_n;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        InventoryPlayer playerInv = this.field_73882_e.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o() == null) {
            for (Object button : this.field_73887_h) {
                GuiBetterButton betterButton;
                if (!(button instanceof GuiBetterButton) || (tips = (betterButton = (GuiBetterButton)((Object)button)).getToolTip()) == null) continue;
                mouseOver = betterButton.isMouseOverButton(mouseX, mouseY);
                tips.onTick(mouseOver);
                if (!mouseOver || !tips.isReady()) continue;
                tips.refresh();
                this.drawToolTips(tips, mouseX, mouseY);
            }
        }
        for (Object obj : this.field_74193_d.field_75151_b) {
            SlotBase slot;
            if (!(obj instanceof SlotBase) || (slot = (SlotBase)((Object)obj)).func_75211_c() != null || (tips = slot.getToolTip()) == null) continue;
            mouseOver = this.func_74186_a(slot, mouseX, mouseY);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            this.drawToolTips(tips, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    private void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        if (toolTips.size() > 0) {
            int y;
            int left = this.field_74198_m;
            int top = this.field_74197_n;
            int lenght = 0;
            Iterator i$ = toolTips.iterator();
            while (i$.hasNext()) {
                ToolTipLine tip = (ToolTipLine)i$.next();
                y = this.field_73886_k.func_78256_a(tip.text);
                if (y <= lenght) continue;
                lenght = y;
            }
            int x = mouseX - left + 12;
            y = mouseY - top - 12;
            int var14 = 8;
            if (toolTips.size() > 1) {
                var14 += 2 + (toolTips.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            GuiEnhancedCore.field_74196_a.field_77023_b = 300.0f;
            int var15 = -267386864;
            this.func_73733_a(x - 3, y - 4, x + lenght + 3, y - 3, var15, var15);
            this.func_73733_a(x - 3, y + var14 + 3, x + lenght + 3, y + var14 + 4, var15, var15);
            this.func_73733_a(x - 3, y - 3, x + lenght + 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x - 4, y - 3, x - 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x + lenght + 3, y - 3, x + lenght + 4, y + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x + lenght + 2, y - 3 + 1, x + lenght + 3, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x - 3, y - 3, x + lenght + 3, y - 3 + 1, var16, var16);
            this.func_73733_a(x - 3, y + var14 + 2, x + lenght + 3, y + var14 + 3, var17, var17);
            Iterator i$2 = toolTips.iterator();
            while (i$2.hasNext()) {
                ToolTipLine tip = (ToolTipLine)i$2.next();
                String line = tip.text;
                line = tip.color == -1 ? "\u00a77" + line : "\u00a7" + Integer.toHexString(tip.color) + line;
                this.field_73886_k.func_78261_a(line, x, y, -1);
                y += 10 + tip.getSpacing();
            }
            this.field_73735_i = 0.0f;
            GuiEnhancedCore.field_74196_a.field_77023_b = 0.0f;
        }
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_74194_b);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_73886_k.func_78256_a(string)) / 2;
    }

    protected void initLedgers(IInventory inventory) {
    }

    protected void initLedgers(TileEntity tileEntity) {
    }

    private boolean func_74186_a(Slot slot, int mouseX, int mouseY) {
        int left = this.field_74198_m;
        int top = this.field_74197_n;
        return (mouseX -= left) >= slot.field_75223_e - 1 && mouseX < slot.field_75223_e + 16 + 1 && (mouseY -= top) >= slot.field_75221_f - 1 && mouseY < slot.field_75221_f + 16 + 1;
    }

    protected void func_73864_a(int par1, int par2, int mouseButton) {
        super.func_73864_a(par1, par2, mouseButton);
        this.ledgerManager.handleMouseClicked(par1, par2, mouseButton);
    }

    public int getLeft() {
        return this.field_74198_m;
    }

    public int getTop() {
        return this.field_74197_n;
    }

    public RenderItem getItemRenderer() {
        return field_74196_a;
    }

    protected class RedstoneLedger
    extends Ledger {
        int headerColour;
        int subheaderColour;
        int textColour;
        int selected;

        public RedstoneLedger() {
            this.headerColour = 14797103;
            this.subheaderColour = 11186104;
            this.textColour = 0;
            this.selected = 0;
            this.overlayColor = 13921311;
            this.maxHeight = 47;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Properties.bindTexture(FMLClientHandler.instance().getClient().field_71446_o, 1);
            this.drawIcon(new ItemStack(Item.field_77767_aC).func_77954_c(), x + 3, y + 3);
            if (!this.isFullyOpened()) {
                return;
            }
            int y2 = y + 22;
            int xLoc = x + this.maxWidth / 2 - 44;
            GuiEnhancedCore.this.field_73886_k.func_78261_a("Redstone Control", x + 22, y + 8, this.headerColour);
            Properties.bindTexture(FMLClientHandler.instance().getClient().field_71446_o, "epcore", "textures/gui/buttons.png");
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < 4; ++i) {
                int x2 = xLoc + 3 + 22 * i;
                boolean isActive = false;
                if (i == 0) {
                    isActive = this.selected == 0;
                } else if (i == 1) {
                    isActive = this.selected == 1;
                } else if (i == 2) {
                    isActive = this.selected >= 2;
                } else if (i == 3) {
                    isActive = this.selected == -1;
                }
                GuiEnhancedCore.this.func_73729_b(x2, y2, 0, isActive ? 40 : 20, 10, 10);
                GuiEnhancedCore.this.func_73729_b(x2 + 10, y2, 190, isActive ? 40 : 20, 10, 10);
                GuiEnhancedCore.this.func_73729_b(x2, y2 + 10, 0, isActive ? 50 : 30, 10, 10);
                GuiEnhancedCore.this.func_73729_b(x2 + 10, y2 + 10, 190, isActive ? 50 : 30, 10, 10);
            }
            Properties.bindTexture(FMLClientHandler.instance().getClient().field_71446_o, 0);
            this.drawIcon(new ItemStack(Block.field_72035_aQ).func_77954_c(), xLoc + 5, y + 22);
            this.drawIcon(new ItemStack(Block.field_72049_aP).func_77954_c(), xLoc + 27, y + 22);
            Properties.bindTexture(FMLClientHandler.instance().getClient().field_71446_o, 1);
            this.drawIcon(new ItemStack(Item.field_77767_aC).func_77954_c(), xLoc + 49, y + 24);
            this.drawIcon(new ItemStack(Item.field_77677_M).func_77954_c(), xLoc + 71, y + 24);
            if (this.selected >= 2) {
                GuiEnhancedCore.this.field_73886_k.func_78261_a("" + (this.selected - 2), xLoc + 49 + 17 - GuiEnhancedCore.this.field_73886_k.func_78256_a("" + (this.selected - 2)), y + 33, -1);
            }
        }

        @Override
        public ArrayList<String> getTooltip() {
            ArrayList<String> strList = new ArrayList<String>();
            if (!this.isOpen()) {
                strList.add("Redstone Control");
                strList.add(EnumChatFormatting.GRAY + (this.selected == 0 ? "Normal" : (this.selected == 1 ? "Inverted" : (this.selected >= 2 ? "Analogue (" + (this.selected - 2) + ")" : (this.selected == -1 ? "Disabled" : "Unknown")))));
            }
            return strList;
        }

        @Override
        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            int xLoc = this.currentShiftX + this.maxWidth / 2 - 44;
            int y2 = this.currentShiftY + 22;
            for (int i = 0; i < 4; ++i) {
                int x2 = xLoc + 3 + 22 * i;
                if (x < x2 || x > x2 + 19 || y < y2 || y > y2 + 19) continue;
                if ((i == 0 || i == 1) && mouseButton == 0) {
                    this.selected = i;
                } else if (i == 2) {
                    this.selected = this.selected < 2 ? 3 : MathHelper.clampInt(mouseButton == 0 ? this.selected + 1 : (mouseButton == 1 ? this.selected - 1 : this.selected), 3, 17);
                } else if (i == 3 && mouseButton == 0) {
                    this.selected = -1;
                }
                this.selectedChanged(this.selected);
                GuiEnhancedCore.this.getMinecraft().field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                return true;
            }
            return false;
        }

        protected void setSelected(int i) {
            this.selected = i;
        }

        protected void selectedChanged(int i) {
        }
    }

    protected class TipLedger
    extends Ledger {
        int headerColour;
        int subheaderColour;
        int textColour;
        int tip;

        protected String[] getTipsList() {
            return new String[0];
        }

        public TipLedger() {
            this.headerColour = 14797103;
            this.subheaderColour = 11186104;
            this.textColour = 0;
            this.tip = 0;
            this.overlayColor = 5478106;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEnhancedCore.this.field_73886_k.func_78261_a("Did you know...", x + 22, y + 8, this.headerColour);
            if (this.tip == -1) {
                this.tip = 0;
                List list = GuiEnhancedCore.this.field_73886_k.func_78271_c(this.getTipsList()[this.tip], 115);
                this.maxHeight = 25 + list.size() * GuiEnhancedCore.this.field_73886_k.field_78288_b;
            }
            GuiEnhancedCore.this.field_73886_k.func_78279_b(this.getTipsList()[this.tip], x + 5, y + 20, 115, this.textColour);
        }

        @Override
        public ArrayList<String> getTooltip() {
            ArrayList<String> strList = new ArrayList<String>();
            if (!this.isOpen()) {
                strList.add("Did you know...");
            }
            return strList;
        }

        @Override
        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            if (!this.isOpen()) {
                ++this.tip;
                if (this.tip >= this.getTipsList().length) {
                    this.tip = 0;
                }
                List list = GuiEnhancedCore.this.field_73886_k.func_78271_c(this.getTipsList()[this.tip], 115);
                this.maxHeight = 25 + list.size() * GuiEnhancedCore.this.field_73886_k.field_78288_b;
            }
            return super.handleMouseClicked(x, y, mouseButton);
        }
    }

    protected class LedgerManager {
        private GuiEnhancedCore gui;
        protected ArrayList<Ledger> ledgers = new ArrayList();

        public LedgerManager(GuiEnhancedCore gui) {
            this.gui = gui;
        }

        public void add(Ledger ledger) {
            this.ledgers.add(ledger);
            if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
                ledger.setFullyOpen();
            }
        }

        protected void drawLedgers(int mouseX, int mouseY) {
            int xPos = 8;
            for (Ledger ledger : this.ledgers) {
                ledger.update();
                if (!ledger.isVisible()) continue;
                ledger.draw(GuiEnhancedCore.this.field_74194_b, xPos);
                xPos += ledger.getHeight();
            }
            Ledger ledger = this.getAtPosition(mouseX, mouseY);
            if (ledger != null) {
                int startX = mouseX - (this.gui.field_73880_f - this.gui.field_74194_b) / 2 + 12;
                int startY = mouseY - (this.gui.field_73881_g - this.gui.field_74195_c) / 2 - 12;
                ArrayList<String> tooltip = ledger.getTooltip();
                if (tooltip == null || tooltip.size() == 0) {
                    return;
                }
                this.drawTooltipText(tooltip, startX - 10, startY + 10, GuiEnhancedCore.this.field_73886_k);
            }
        }

        protected void drawTooltipText(List par1List, int par2, int par3, FontRenderer font) {
            if (!par1List.isEmpty()) {
                GL11.glDisable((int)32826);
                RenderHelper.func_74518_a();
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                int k = 0;
                for (String s : par1List) {
                    int l = font.func_78256_a(s);
                    if (l <= k) continue;
                    k = l;
                }
                int i1 = par2 + 12;
                int j1 = par3 - 12;
                int k1 = 8;
                if (par1List.size() > 1) {
                    k1 += 2 + (par1List.size() - 1) * 10;
                }
                if (i1 + k > GuiEnhancedCore.this.field_73880_f) {
                    i1 -= 28 + k;
                }
                if (j1 + k1 + 6 > GuiEnhancedCore.this.field_73881_g) {
                    j1 = GuiEnhancedCore.this.field_73881_g - k1 - 6;
                }
                GuiEnhancedCore.this.field_73735_i = 300.0f;
                field_74196_a.field_77023_b = 300.0f;
                int l1 = -267386864;
                GuiEnhancedCore.this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
                GuiEnhancedCore.this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
                GuiEnhancedCore.this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
                GuiEnhancedCore.this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
                GuiEnhancedCore.this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
                int i2 = 0x505000FF;
                int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
                GuiEnhancedCore.this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
                GuiEnhancedCore.this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
                GuiEnhancedCore.this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
                GuiEnhancedCore.this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
                for (int k2 = 0; k2 < par1List.size(); ++k2) {
                    String s1 = (String)par1List.get(k2);
                    font.func_78261_a(s1, i1, j1, -1);
                    if (k2 == 0) {
                        j1 += 2;
                    }
                    j1 += 10;
                }
                GuiEnhancedCore.this.field_73735_i = 0.0f;
                field_74196_a.field_77023_b = 0.0f;
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                RenderHelper.func_74519_b();
                GL11.glEnable((int)32826);
            }
        }

        protected Ledger getAtPosition(int mX, int mY) {
            int xShift = (this.gui.field_73880_f - this.gui.field_74194_b) / 2 + this.gui.field_74194_b;
            int yShift = (this.gui.field_73881_g - this.gui.field_74195_c) / 2 + 8;
            for (int i = 0; i < this.ledgers.size(); ++i) {
                Ledger ledger = this.ledgers.get(i);
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
            return null;
        }

        public void handleMouseClicked(int x, int y, int mouseButton) {
            Ledger ledger = this.getAtPosition(x, y);
            if (ledger != null && !ledger.handleMouseClicked(x, y, mouseButton) && mouseButton == 0) {
                for (Ledger other : this.ledgers) {
                    if (other == ledger || !other.isOpen()) continue;
                    other.toggleOpen();
                }
                ledger.toggleOpen();
            }
        }

        public void insert(Ledger ledger) {
            this.ledgers.add(this.ledgers.size() - 1, ledger);
        }
    }

    protected abstract class Ledger {
        private boolean open;
        protected int overlayColor = 0xFFFFFF;
        public int currentShiftX = 0;
        public int currentShiftY = 0;
        protected int limitWidth = 128;
        protected int maxWidth = 124;
        protected int minWidth;
        protected int currentWidth = this.minWidth = 24;
        protected int maxHeight = 24;
        protected int minHeight;
        protected int currentHeight = this.minHeight = 24;

        protected Ledger() {
        }

        public abstract void draw(int var1, int var2);

        protected void drawBackground(int x, int y) {
            float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            Properties.bindTexture(GuiEnhancedCore.this.getMinecraft().field_71446_o, "epcore", "textures/gui/ledger.png");
            GuiEnhancedCore.this.func_73729_b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            GuiEnhancedCore.this.func_73729_b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            GuiEnhancedCore.this.func_73729_b(x, y, 0, 0, 4, 4);
            GuiEnhancedCore.this.func_73729_b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        protected void drawIcon(Icon icon, int x, int y) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiEnhancedCore.this.func_94065_a(x, y, icon, 16, 16);
        }

        public int getHeight() {
            return this.currentHeight;
        }

        public abstract ArrayList<String> getTooltip();

        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            return false;
        }

        public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
            return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
        }

        protected boolean isFullyOpened() {
            return this.currentWidth >= this.maxWidth;
        }

        public boolean isOpen() {
            return this.open;
        }

        public boolean isVisible() {
            return true;
        }

        public void setFullyOpen() {
            this.open = true;
            this.currentWidth = this.maxWidth;
            this.currentHeight = this.maxHeight;
        }

        public void toggleOpen() {
            if (this.open) {
                this.open = false;
                SessionVars.setOpenedLedger(null);
            } else {
                this.open = true;
                SessionVars.setOpenedLedger(this.getClass());
            }
        }

        public void update() {
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += 4;
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= 4;
            }
            if (this.open && this.currentHeight < this.maxHeight) {
                this.currentHeight += 4;
            } else if (!this.open && this.currentHeight > this.minHeight) {
                this.currentHeight -= 4;
            }
        }
    }
}

