/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.UV;
import codechicken.lib.render.UVScale;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Iterator;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.EnumPipe;
import mrtjp.projectred.transportation.RoutedPayload;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderPipe {
    private static final ss dummyEntityItem = new ss(null);
    private static final bgw customRenderItem = new bgw(){

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };
    public static CCModel[] sideModels;
    public static CCModel[] centerModels;
    private static LazyLightMatrix dynamicLight;

    public static CCModel finishModel(CCModel m) {
        m.apply((IUVTransformation)new UVScale(0.0625));
        m.shrinkUVs(5.0E-4);
        m.computeNormals();
        m.computeLighting(LightModel.standardLightModel);
        return m;
    }

    public static void reverseOrder(Vertex5[] verts) {
        for (int k = 0; k < verts.length; k += 4) {
            Vertex5 tmp = verts[k + 1];
            verts[k + 1] = verts[k + 3];
            verts[k + 3] = tmp;
        }
    }

    public static void render(BasicPipePart w, Vector3 pos) {
        dynamicLight.setPos((acf)w.world(), w.x(), w.y(), w.z());
        RenderPipe.render(w, pos, dynamicLight);
    }

    public static void render(BasicPipePart p, Vector3 pos, LazyLightMatrix olm) {
        Translation t = new Translation(pos);
        IconTransformation uvt = new IconTransformation(EnumPipe.VALID_PIPE[p.meta].sprites[0]);
        int connMap = p.connMap;
        if (Integer.bitCount(connMap) == 2 && ((connMap & 3) == 3 || (connMap & 0xC) == 12 || (connMap & 0x30) == 48)) {
            for (int a2 = 0; a2 < 3; ++a2) {
                if (connMap >> a2 * 2 != 3) continue;
                centerModels[a2].render((Transformation)t, (IUVTransformation)uvt);
            }
        } else {
            centerModels[3].render((Transformation)t, (IUVTransformation)uvt);
        }
        for (int s = 0; s < 6; ++s) {
            if ((connMap & 1 << s) == 0) continue;
            uvt = new IconTransformation(p.getIcon(s));
            sideModels[s].render((Transformation)t, (IUVTransformation)uvt);
        }
    }

    public static void renderBreakingOverlay(ms icon, BasicPipePart wire) {
        for (Cuboid6 box : wire.getCollisionBoxes()) {
            RenderUtils.renderBlock((Cuboid6)box, (int)0, (Transformation)new Translation((double)wire.x(), (double)wire.y(), (double)wire.z()), (IUVTransformation)new IconTransformation(icon), null);
        }
    }

    public static void renderInv(Transformation t, ms icon) {
        IconTransformation uvt = new IconTransformation(icon);
        CCRenderState.setColour((int)-1);
        centerModels[3].render(t, (IUVTransformation)uvt);
        for (int s = 0; s < 2; ++s) {
            sideModels[s].render(t, (IUVTransformation)uvt);
        }
    }

    public static void renderItemFlow(BasicPipePart p, Vector3 pos, float frame) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        Iterator i$ = p.itemFlow.iterator();
        while (i$.hasNext()) {
            RoutedPayload r = (RoutedPayload)i$.next();
            ForgeDirection dir = r.isEntering ? r.input : r.output;
            double prog = r.progress + r.speed * frame;
            double frameX = pos.x + 0.5;
            double frameY = pos.y + 0.25;
            double frameZ = pos.z + 0.5;
            switch (dir) {
                case UP: {
                    frameY = pos.y - 0.25 + prog;
                    break;
                }
                case DOWN: {
                    frameY = pos.y - 0.25 + (1.0 - prog);
                    break;
                }
                case SOUTH: {
                    frameZ = pos.z + prog;
                    break;
                }
                case NORTH: {
                    frameZ = pos.z + (1.0 - prog);
                    break;
                }
                case EAST: {
                    frameX = pos.x + prog;
                    break;
                }
                case WEST: {
                    frameX = pos.x + (1.0 - prog);
                    break;
                }
            }
            RenderPipe.doRenderItem(r, frameX, frameY, frameZ);
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private static void doRenderItem(RoutedPayload r, double x, double y, double z) {
        if (r == null || r.getItemStack() == null) {
            return;
        }
        float renderScale = 0.7f;
        ye itemstack = r.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        dummyEntityItem.a(itemstack);
        customRenderItem.a(dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        RenderPipe.prepareRenderState();
        GL11.glEnable((int)2896);
        bfq.a.a(PRColors.get((int)r.priority.color).rgb, 32);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RenderUtils.renderBlock((Cuboid6)Cuboid6.full, (int)0, (Transformation)new Translation(-0.5, -0.5, -0.5), null, null);
        RenderPipe.restoreRenderState();
        GL11.glPopMatrix();
    }

    private static void prepareRenderState() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        CCRenderState.reset();
        CCRenderState.startDrawing((int)7);
    }

    private static void restoreRenderState() {
        CCRenderState.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    static {
        customRenderItem.a(bgl.a);
        sideModels = new CCModel[6];
        centerModels = new CCModel[4];
        dynamicLight = new LazyLightMatrix();
        PipeModelGenerator.generateModels();
    }

    private static class PipeModelGenerator {
        double w = 0.25;
        double d = 0.0605;

        private PipeModelGenerator() {
        }

        public static void generateModels() {
            PipeModelGenerator gen_inst = new PipeModelGenerator();
            gen_inst.generateCenterModel();
            gen_inst.generateCrossExclusiveModels();
            gen_inst.generateSideModels();
            gen_inst.finishModels();
        }

        public void generateCenterModel() {
            CCModel model = CCModel.quadModel((int)48);
            model.verts[0] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 - this.w, 4.0, 8.0);
            model.verts[1] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 - this.w, 12.0, 8.0);
            model.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 12.0, 0.0);
            model.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 4.0, 0.0);
            model.verts[4] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 + this.w, 4.0, 8.0);
            model.verts[5] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 + this.w, 12.0, 8.0);
            model.verts[6] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 - this.w, 12.0, 0.0);
            model.verts[7] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 - this.w, 4.0, 0.0);
            model.generateSidedParts(0, Vector3.center);
            RenderPipe.centerModels[3] = model;
        }

        public void generateCrossExclusiveModels() {
            CCModel model = CCModel.quadModel((int)48);
            model.verts[0] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 - this.w, 0.0, 16.0);
            model.verts[1] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 - this.w, 8.0, 16.0);
            model.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 8.0, 8.0);
            model.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 0.0, 8.0);
            model.verts[4] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 + this.w, 0.0, 16.0);
            model.verts[5] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 + this.w, 8.0, 16.0);
            model.verts[6] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 - this.w, 8.0, 8.0);
            model.verts[7] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 - this.w, 0.0, 8.0);
            for (int s = 1; s < 4; ++s) {
                model.generateSidedPart(0, s, Vector3.center, 0, 8 * s, 8);
            }
            for (int i = 0; i < 48; ++i) {
                if (model.verts[i] != null) continue;
                model.verts[i] = new Vertex5();
            }
            RenderPipe.centerModels[0] = model.copy().apply(Rotation.sideOrientation((int)2, (int)1).at(Vector3.center));
            RenderPipe.centerModels[1] = model.copy().apply(Rotation.sideOrientation((int)0, (int)1).at(Vector3.center));
            RenderPipe.centerModels[2] = model;
        }

        public void generateSideModels() {
            CCModel model = CCModel.quadModel((int)36);
            model.verts[0] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 0.0, 0.0);
            model.verts[1] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 0.0, 8.0);
            model.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 4.0, 8.0);
            model.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 4.0, 0.0);
            model.verts[4] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w - this.d, 0.0, 0.0);
            model.verts[5] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w - this.d, 0.0, 8.0);
            model.verts[6] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w - this.d, 4.0, 8.0);
            model.verts[7] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w - this.d, 4.0, 0.0);
            for (int r = 1; r < 4; ++r) {
                model.apply(Rotation.quarterRotations[r].at(Vector3.center), 0, r * 8, 8);
            }
            model.verts[32] = new Vertex5(0.5 - this.w, 0.0, 0.5 - this.w, 8.0, 16.0);
            model.verts[33] = new Vertex5(0.5 + this.w, 0.0, 0.5 - this.w, 16.0, 16.0);
            model.verts[34] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, 8.0);
            model.verts[35] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 8.0, 8.0);
            RenderPipe.sideModels[0] = model;
            for (int s = 1; s < 6; ++s) {
                RenderPipe.sideModels[s] = model.copy().apply(Rotation.sideRotations[s].at(Vector3.center));
                if (s % 2 != 1) continue;
                Vertex5[] verts = RenderPipe.sideModels[s].verts;
                UVT t = new UVT(Rotation.quarterRotations[2].at(new Vector3(8.0, 0.0, 4.0)));
                for (int i = 0; i < 32; ++i) {
                    verts[i].apply((IUVTransformation)t);
                }
            }
        }

        public void finishModels() {
            for (CCModel m : sideModels) {
                RenderPipe.finishModel(m);
            }
            for (CCModel m : centerModels) {
                RenderPipe.finishModel(m);
            }
        }
    }

    public static class UVT
    implements IUVTransformation {
        public Transformation t;
        private Vector3 vec = new Vector3();

        public UVT(Transformation t) {
            this.t = t;
        }

        public void transform(UV uv) {
            this.vec.set(uv.u, 0.0, uv.v).apply(this.t);
            uv.set(this.vec.x, this.vec.z);
        }
    }
}

