/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.utils.HashPair2;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.IWorldBroadcaster;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.RequestBranchNode;

public class RequestBranch
extends RequestBranchNode {
    private HashMap<HashPair2<IWorldBroadcaster, ItemKey>, Integer> totalPromises;

    public RequestBranch(ItemKeyStack requestedPackage, IWorldRequester requester, EnumSet<RequestFlags> type) {
        super(null, requestedPackage, requester, null, type);
    }

    protected void promiseAdded(RequestBranchNode.DeliveryPromise promise) {
        HashPair2 key = new HashPair2((Object)promise.sender, (Object)promise.thePackage);
        this.totalPromises.put((HashPair2<IWorldBroadcaster, ItemKey>)key, this.getExistingPromisesFor((HashPair2<IWorldBroadcaster, ItemKey>)key) + promise.size);
    }

    protected void promiseRemoved(RequestBranchNode.DeliveryPromise promise) {
        HashPair2 key = new HashPair2((Object)promise.sender, (Object)promise.thePackage);
        int newCount = this.getExistingPromisesFor((HashPair2<IWorldBroadcaster, ItemKey>)key) - promise.size;
        if (newCount <= 0) {
            this.totalPromises.remove(key);
        } else {
            this.totalPromises.put((HashPair2<IWorldBroadcaster, ItemKey>)key, newCount);
        }
    }

    protected LinkedList<RequestBranchNode.ExcessPromise> getAllExcessFor(ItemKey item) {
        HashMap<IWorldBroadcaster, List<RequestBranchNode.ExcessPromise>> excessMap = new HashMap<IWorldBroadcaster, List<RequestBranchNode.ExcessPromise>>();
        this.recurse_GatherExcess(item, excessMap);
        this.recurse_RemoveUnusableExcess(item, excessMap);
        LinkedList<RequestBranchNode.ExcessPromise> excessPromises = new LinkedList<RequestBranchNode.ExcessPromise>();
        for (List<RequestBranchNode.ExcessPromise> list : excessMap.values()) {
            excessPromises.addAll(list);
        }
        return excessPromises;
    }

    public int getExistingPromisesFor(HashPair2<IWorldBroadcaster, ItemKey> key) {
        Integer n;
        if (this.totalPromises == null) {
            this.totalPromises = new HashMap();
        }
        if ((n = this.totalPromises.get(key)) == null) {
            return 0;
        }
        return n;
    }

    static enum RequestFlags {
        PULL,
        CRAFT,
        PARTIALS,
        SIMULATE;

        public static final EnumSet<RequestFlags> all;
        public static final EnumSet<RequestFlags> def;

        static {
            all = EnumSet.allOf(RequestFlags.class);
            def = EnumSet.of(PULL, CRAFT);
        }
    }
}

