/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.BitSet;
import java.util.UUID;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.Router;
import mrtjp.projectred.transportation.RouterServices;
import net.minecraftforge.common.ForgeDirection;

public class RoutedPayload {
    ItemKeyStack payload;
    private static int maxID = 0;
    public final int payloadID;
    public float speed = 0.01f;
    public float progress = 0.0f;
    public ForgeDirection input = ForgeDirection.UNKNOWN;
    public ForgeDirection output = ForgeDirection.UNKNOWN;
    public boolean isEntering = true;
    public BasicPipePart parent;
    int destinationIP = -1;
    UUID destinationUUID = null;
    boolean hasArrived = false;
    BitSet travelLog = new BitSet();
    SendPriority priority = SendPriority.WANDERING;

    public RoutedPayload() {
        this(maxID < Short.MAX_VALUE ? (maxID = maxID + 1) : (maxID = Short.MIN_VALUE));
    }

    public RoutedPayload(int id) {
        this.payloadID = id;
    }

    public RoutedPayload(ItemKeyStack stack) {
        this();
        this.payload = stack;
    }

    public void bind(BasicPipePart p) {
        this.parent = p;
    }

    public void reset() {
        this.isEntering = true;
        this.input = ForgeDirection.UNKNOWN;
        this.output = ForgeDirection.UNKNOWN;
    }

    public void moveProgress(float prog) {
        this.progress += prog;
    }

    public ye getItemStack() {
        return this.payload.makeStack();
    }

    public void setItemStack(ye item) {
        this.payload = ItemKeyStack.get((ye)item);
    }

    public boolean isCorrupted() {
        return this.getItemStack() == null || this.getItemStack().b <= 0 || yc.g[this.getItemStack().d] == null;
    }

    public int hashCode() {
        return this.payloadID;
    }

    public boolean equals(Object o) {
        if (o instanceof RoutedPayload) {
            return ((RoutedPayload)o).payloadID == this.payloadID;
        }
        return false;
    }

    public void load(by tag) {
        this.progress = tag.g("prog");
        this.speed = tag.g("speed");
        this.setItemStack(ye.a((by)tag.l("Item")));
        this.isEntering = tag.n("isEnt");
        this.input = ForgeDirection.getOrientation((int)tag.e("input"));
        this.output = ForgeDirection.getOrientation((int)tag.e("output"));
        this.loadRouting(tag);
    }

    public void save(by tag) {
        tag.a("prog", this.progress);
        tag.a("speed", this.speed);
        by nbttagcompound2 = new by();
        this.getItemStack().b(nbttagcompound2);
        tag.a("Item", nbttagcompound2);
        tag.a("isEnt", this.isEntering);
        tag.a("input", this.input.ordinal());
        tag.a("output", this.output.ordinal());
        this.saveRouting(tag);
    }

    public ss getEntityForDrop(int x, int y, int z) {
        ForgeDirection dir = this.isEntering ? this.input : this.output;
        double prog = this.progress;
        double deltaX = (double)x + 0.5;
        double deltaY = (double)y + 0.25;
        double deltaZ = (double)z + 0.5;
        switch (dir) {
            case UP: {
                deltaY = (double)y - 0.25 + prog;
                break;
            }
            case DOWN: {
                deltaY = (double)y - 0.25 + (1.0 - prog);
                break;
            }
            case SOUTH: {
                deltaZ = (double)z + prog;
                break;
            }
            case NORTH: {
                deltaZ = (double)z + (1.0 - prog);
                break;
            }
            case EAST: {
                deltaX = (double)x + prog;
                break;
            }
            case WEST: {
                deltaX = (double)x + (1.0 - prog);
                break;
            }
        }
        ss item = new ss(this.parent.world(), deltaX, deltaY, deltaZ, this.payload.makeStack());
        item.c = 0.0f;
        item.y = item.z = (double)0.0f;
        item.x = item.z;
        switch (dir) {
            case UP: {
                item.y = this.speed;
                break;
            }
            case DOWN: {
                item.y = -this.speed;
                break;
            }
            case SOUTH: {
                item.z = this.speed;
                break;
            }
            case NORTH: {
                item.z = -this.speed;
                break;
            }
            case EAST: {
                item.x = this.speed;
                break;
            }
            case WEST: {
                item.x = -this.speed;
                break;
            }
        }
        item.b = 10;
        item.lifespan = 1600;
        return item;
    }

    public RoutedPayload setDestination(int ip) {
        this.destinationIP = ip;
        Router router = RouterServices.instance.getRouter(ip);
        if (router != null) {
            this.destinationUUID = router.getID();
        } else {
            this.destinationIP = -1;
        }
        return this;
    }

    public RoutedPayload setPriority(SendPriority priority) {
        this.priority = priority;
        return this;
    }

    public RoutedPayload resetTrip() {
        IWorldRouter parent;
        Router r;
        if (this.destinationIP > -1 && (r = RouterServices.instance.getRouter(this.destinationIP)) != null && (parent = r.getParent()) instanceof IWorldRequester) {
            ((IWorldRequester)parent).trackedItemLost(this.payload);
        }
        this.destinationIP = -1;
        this.destinationUUID = null;
        this.hasArrived = false;
        this.priority = SendPriority.WANDERING;
        return this;
    }

    public void refreshIP() {
        Router router = RouterServices.instance.getRouter(this.destinationIP);
        if (router == null || router.getID() != this.destinationUUID) {
            this.destinationIP = RouterServices.instance.getIPforUUID(this.destinationUUID);
        }
    }

    public void saveRouting(by tag) {
    }

    public void loadRouting(by tag) {
    }

    public static enum SendPriority {
        WANDERING("Wandering", 0.02f, 0.05f, PRColors.RED.ordinal()),
        DEFAULT("Default", 0.05f, 0.1f, PRColors.ORANGE.ordinal()),
        TERMINATED("Terminated", 0.02f, 0.05f, PRColors.PURPLE.ordinal()),
        PASSIVE("Passive", 0.1f, 0.2f, PRColors.BLUE.ordinal()),
        ACTIVE("Active", 0.2f, 0.3f, PRColors.GREEN.ordinal());

        public final float speed;
        public final float boost;
        public final int color;
        public final String name;

        private SendPriority(String name, float speed, float boost, int color) {
            this.name = name;
            this.speed = speed;
            this.color = color;
            this.boost = boost;
        }
    }
}

