/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.core.ClientUtils;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import java.util.HashMap;
import mrtjp.projectred.ProjectRedTransportation;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.transportation.GuiChipUpgrade;
import mrtjp.projectred.transportation.GuiCraftingPipe;
import mrtjp.projectred.transportation.GuiExtensionPipe;
import mrtjp.projectred.transportation.GuiInterfacePipe;
import mrtjp.projectred.transportation.GuiRequester;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.ItemRouterUtility;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RouteFX;
import mrtjp.projectred.transportation.RoutedCraftingPipePart;
import mrtjp.projectred.transportation.RoutedExtensionPipePart;
import mrtjp.projectred.transportation.RoutedInterfacePipePart;
import mrtjp.projectred.transportation.RoutingChipGuiFactory;
import mrtjp.projectred.transportation.RoutingChipset;

public class TransportationCPH
implements PacketCustom.IClientPacketHandler {
    public static final Object channel = ProjectRedTransportation.instance;

    public void handlePacket(PacketCustom packet, bcw net, atv mc) {
        switch (packet.getType()) {
            case 1: {
                this.openRoutedInterfacePipeGui(packet, (uf)mc.h);
                break;
            }
            case 2: {
                this.openCraftingPipeGui(packet, (uf)mc.h);
                break;
            }
            case 5: {
                this.openChipsetGui(packet, (uf)mc.h);
                break;
            }
            case 6: {
                this.openRequestGui(packet, mc);
                break;
            }
            case 9: {
                this.receiveRequestList(packet, mc);
                break;
            }
            case 11: {
                RouteFX.handleClientPacket((MCDataInput)packet, (abw)mc.f);
                break;
            }
            case 12: {
                this.openRouterUtilGui(packet, mc);
                break;
            }
            case 14: {
                this.openExtensionPipeGui(packet, mc);
            }
        }
    }

    private void openExtensionPipeGui(PacketCustom packet, atv mc) {
        TMultiPart p = BasicUtils.getMultiPart((acf)mc.f, (BlockCoord)packet.readCoord(), (int)6);
        if (p instanceof RoutedExtensionPipePart) {
            RoutedExtensionPipePart pipe = (RoutedExtensionPipePart)p;
            ClientUtils.openSMPGui((int)packet.readUByte(), (awe)new GuiExtensionPipe(pipe.createContainer((uf)mc.h), packet.readString()));
        }
    }

    private void openRouterUtilGui(PacketCustom packet, atv mc) {
        ClientUtils.openSMPGui((int)packet.readByte(), (awe)new GuiChipUpgrade(new ItemRouterUtility.ChipUpgradeContainer((uf)mc.h)));
    }

    private void receiveRequestList(PacketCustom packet, atv mc) {
        if (mc.n instanceof GuiRequester) {
            GuiRequester gui = (GuiRequester)mc.n;
            int size = packet.readInt();
            HashMap<ItemKey, Integer> map = new HashMap<ItemKey, Integer>(size);
            for (int i = 0; i < size; ++i) {
                ye stack = packet.readItemStack(true);
                map.put(ItemKey.get((ye)stack), stack.b);
            }
            gui.receiveContentList(map);
        }
    }

    private void openRequestGui(PacketCustom packet, atv mc) {
        TMultiPart p = BasicUtils.getMultiPart((acf)mc.h.q, (BlockCoord)packet.readCoord(), (int)6);
        if (p instanceof IWorldRequester) {
            mc.a((awe)new GuiRequester((IWorldRequester)p));
        }
    }

    private void openRoutedInterfacePipeGui(PacketCustom packet, uf player) {
        TMultiPart p = BasicUtils.getMultiPart((acf)player.q, (BlockCoord)packet.readCoord(), (int)6);
        if (p instanceof RoutedInterfacePipePart) {
            RoutedInterfacePipePart pipe = (RoutedInterfacePipePart)p;
            ClientUtils.openSMPGui((int)packet.readUByte(), (awe)new GuiInterfacePipe(pipe.createContainer(player), pipe));
        }
    }

    private void openCraftingPipeGui(PacketCustom packet, uf player) {
        TMultiPart p = BasicUtils.getMultiPart((acf)player.q, (BlockCoord)packet.readCoord(), (int)6);
        if (p instanceof RoutedCraftingPipePart) {
            RoutedCraftingPipePart pipe = (RoutedCraftingPipePart)p;
            ClientUtils.openSMPGui((int)packet.readUByte(), (awe)new GuiCraftingPipe(pipe.createContainer(player), pipe));
            pipe.priority = packet.readInt();
        }
    }

    private void openChipsetGui(PacketCustom packet, uf player) {
        ItemRoutingChip.EnumRoutingChip e;
        byte slot = packet.readByte();
        player.bn.c = slot;
        ye stack = player.bn.a((int)slot);
        if (stack != null && (e = ItemRoutingChip.EnumRoutingChip.get(stack.k())) != null) {
            RoutingChipset r = e.createChipset();
            ClientUtils.openSMPGui((int)packet.readByte(), (awe)RoutingChipGuiFactory.getGui(r.createContainer(player), stack.k()));
        }
    }
}

