/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import java.util.Map;
import mrtjp.projectred.ProjectRedTransportation;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.CollectionPathFinder;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.ItemRouterUtility;
import mrtjp.projectred.transportation.RequestConsole;
import mrtjp.projectred.transportation.RouteFX;
import mrtjp.projectred.transportation.RoutedCraftingPipePart;

public class TransportationSPH
implements PacketCustom.IServerPacketHandler {
    public static final Object channel = ProjectRedTransportation.instance;

    public void handlePacket(PacketCustom packet, ka nethandler, jv sender) {
        switch (packet.getType()) {
            case 4: {
                this.setChipNBT(packet, sender);
                break;
            }
            case 3: {
                this.handleCraftingPipeAction(packet, sender.q);
                break;
            }
            case 7: {
                this.handleRequestAction(packet, sender);
                break;
            }
            case 8: {
                this.handleRequestSubmit(packet, sender);
                break;
            }
            case 10: {
                this.handleRequestListRefresh(packet, sender);
                break;
            }
            case 13: {
                this.handleRouterUtilAction(packet, sender);
            }
        }
    }

    private void handleRouterUtilAction(PacketCustom packet, jv sender) {
        uy c = sender.bp;
        if (c instanceof ItemRouterUtility.ChipUpgradeContainer) {
            ItemRouterUtility.ChipUpgradeContainer r = (ItemRouterUtility.ChipUpgradeContainer)c;
            String action = packet.readString();
            if (action.equals("inst")) {
                r.installPossibleUpgrades();
            }
        }
    }

    private void handleRequestListRefresh(PacketCustom packet, jv sender) {
        BlockCoord bc = packet.readCoord();
        TMultiPart t = BasicUtils.getMultiPart((acf)sender.q, (BlockCoord)bc, (int)6);
        if (t instanceof IWorldRequester) {
            TransportationSPH.sendRequestList((IWorldRequester)t, sender, packet.readBoolean(), packet.readBoolean());
        }
    }

    private void handleRequestAction(PacketCustom packet, jv sender) {
        BlockCoord bc = packet.readCoord();
        TMultiPart t = BasicUtils.getMultiPart((acf)sender.q, (BlockCoord)bc, (int)6);
        if (t instanceof IWorldRequester) {
            String ident = packet.readString();
        }
    }

    private static void sendRequestList(IWorldRequester requester, jv player, boolean collectBroadcast, boolean collectCrafts) {
        CollectionPathFinder cpf = new CollectionPathFinder().setRequester(requester);
        cpf.setCollectBroadcasts(collectBroadcast).setCollectCrafts(collectCrafts);
        Map<ItemKey, Integer> map = cpf.collect().getCollection();
        PacketCustom packet2 = new PacketCustom(channel, 9);
        packet2.writeInt(map.size());
        for (Map.Entry<ItemKey, Integer> entry : map.entrySet()) {
            packet2.writeItemStack(entry.getKey().makeStack(entry.getValue() == null ? 0 : entry.getValue()), true);
        }
        packet2.compressed().sendToPlayer((uf)player);
    }

    private void handleRequestSubmit(PacketCustom packet, jv sender) {
        BlockCoord bc = packet.readCoord();
        TMultiPart t = BasicUtils.getMultiPart((acf)sender.q, (BlockCoord)bc, (int)6);
        if (t instanceof IWorldRequester) {
            RequestConsole r = new RequestConsole().setDestination((IWorldRequester)t);
            boolean pull = packet.readBoolean();
            boolean craft = packet.readBoolean();
            boolean partial = packet.readBoolean();
            r.setCrafting(craft).setPulling(pull).setPartials(partial);
            ItemKeyStack s = ItemKeyStack.get((ye)packet.readItemStack(true));
            r.makeRequest(s);
            if (r.requested() > 0) {
                sender.a("Successfully requested " + r.requested() + " of " + s.key().getName() + ".");
                RouteFX.spawnType1(RouteFX.color_request, 8, bc, sender.q);
            } else {
                sender.a("Could not request " + s.stackSize + " of " + s.key().getName() + ". Missing:");
                for (Map.Entry<ItemKey, Integer> entry : r.getMissing().entrySet()) {
                    sender.a(entry.getValue() + " of " + entry.getKey().getName());
                }
            }
            TransportationSPH.sendRequestList((IWorldRequester)t, sender, pull, craft);
        }
    }

    private void setChipNBT(PacketCustom packet, jv player) {
        byte slot = packet.readByte();
        ye stack = packet.readItemStack();
        player.bn.a((int)slot, stack);
        player.bn.e();
    }

    private void handleCraftingPipeAction(PacketCustom packet, abw w) {
        TMultiPart t = BasicUtils.getMultiPart((acf)w, (BlockCoord)packet.readCoord(), (int)6);
        if (t instanceof RoutedCraftingPipePart) {
            RoutedCraftingPipePart pipe = (RoutedCraftingPipePart)t;
            String action = packet.readString();
            if (action.equals("up")) {
                pipe.priorityUp();
            } else if (action.equals("down")) {
                pipe.priorityDown();
            }
        }
    }
}

