/**
 * TileEntity class of the showcase
 */

package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.utilities.InventoryStatic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileEntityShowcase extends TileEntity implements IInventory  {
	public float	lidAngle;
	public float	prevLidAngle;
	private int		ticksSinceSync;
	public int		numUsingPlayers	= 0;

	InventoryStatic inventory = new InventoryStatic(1) {
		@Override
		public boolean isUseableByPlayer(EntityPlayer entityplayer) {
			if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != TileEntityShowcase.this) {
				return false;
			} else {
				return entityplayer.getDistanceSq(xCoord + 0.5D, yCoord + 0.5D, zCoord + 0.5D) <= 64D;
			}
		}
		
		@Override
		public int getInventoryStackLimit() {
			return 1;
		}
	};


	@Override
	public int getSizeInventory() {
		return inventory.getSizeInventory();
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return inventory.getStackInSlot(i);
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		return inventory.decrStackSize(i, j);
	}

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		inventory.setInventorySlotContents(i, itemstack);
	}

	@Override
	public String getInvName() {
		return "Showcase";
	}

	@Override
	public int getInventoryStackLimit() {
		return inventory.getInventoryStackLimit();
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		return inventory.isUseableByPlayer(entityplayer);
	}

	void readFromNBTLocal(NBTTagCompound nbttagcompound) {
		if(nbttagcompound.hasKey("items")){
			inventory.clear();
			inventory.readFromNBT(nbttagcompound);
		}
	}

	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);
		readFromNBTLocal(nbttagcompound);
	}

	public void writeToNBTLocal(NBTTagCompound nbttagcompound) {
		inventory.writeToNBT(nbttagcompound);
	}

	@Override
	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);
		writeToNBTLocal(nbttagcompound);
	}

	/**
	 * Called when an the contents of an Inventory change, usually
	 */
	@Override
	public void onInventoryChanged() {
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}

	/**
	 * Called when the container is opened
	 */
	@Override
	public void openChest() {
		if (worldObj.isRemote)
			return;

		numUsingPlayers++;
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}

	/**
	 * Called when the container is closed
	 */
	@Override
	public void closeChest() {
		if (worldObj.isRemote)
			return;

		numUsingPlayers--;
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}

	@Override
	public void updateEntity() {
		super.updateEntity();

		if ((++ticksSinceSync % 20) * 4 == 0) {
			;
		}

		prevLidAngle = lidAngle;
		float f = 0.1F;

		if (numUsingPlayers > 0 && lidAngle == 0F) {
			double d = xCoord + 0.5D;
			double d1 = zCoord + 0.5D;

			worldObj.playSoundEffect(d, yCoord + 0.5D, d1, "random.chestopen", 0.5F, worldObj.rand.nextFloat() * 0.1F + 0.9F);
		}

		if ((numUsingPlayers == 0 && lidAngle > 0F) || (numUsingPlayers > 0 && lidAngle < 1F)) {
			float f1 = lidAngle;

			if (numUsingPlayers > 0) {
				lidAngle += f;
			} else {
				lidAngle -= f;
			}

			if (lidAngle > 1F) {
				lidAngle = 1F;
			}
			if (lidAngle < 0F) {
				lidAngle = 0F;
			}

			float f2 = 0.5F;

			if (lidAngle < f2 && f1 >= f2) {
				double d2 = xCoord + 0.5D;
				double d3 = zCoord + 0.5D;

				worldObj.playSoundEffect(d2, yCoord + 0.5D, d3, "random.chestclosed", 0.5F, worldObj.rand.nextFloat() * 0.1F + 0.9F);
			}
		}
	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}

	@Override
	public boolean isItemValidForSlot(int i, ItemStack itemstack) {
		return true;
	}

	@Override
	public Packet getDescriptionPacket() {
		if ((worldObj.getBlockMetadata(xCoord, yCoord, zCoord) & 4) != 0)
			return null;

		NBTTagCompound tag = new NBTTagCompound();
		writeToNBTLocal(tag);
		tag.setInteger("users", numUsingPlayers);
		return new Packet132TileEntityData(xCoord, yCoord, zCoord, 1, tag);
	}

	@Override
	public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
		readFromNBTLocal(pkt.data);
		numUsingPlayers = pkt.data.getInteger("users");
	}

	@Override
	public ItemStack getStackInSlotOnClosing(int i) {
		return null;
	}

}
