/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.fluid;

import cofh.util.ItemHelper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class BucketHandler {
    public static BucketHandler instance = new BucketHandler();
    private static BiMap<Integer, Integer> buckets = HashBiMap.create();

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    private BucketHandler() {
    }

    @ForgeSubscribe
    public void onBucketFill(FillBucketEvent event) {
        if (!event.current.func_77973_b().equals(Item.field_77788_aw)) {
            return;
        }
        ItemStack bucket = BucketHandler.fillBucket(event.world, event.target);
        if (bucket == null) {
            return;
        }
        event.result = bucket;
        event.setResult(Event.Result.ALLOW);
    }

    public static boolean registerBucket(int blockId, int blockMeta, ItemStack bucket) {
        if (blockId <= 0 || blockMeta < 0 || bucket == null || buckets.containsKey((Object)ItemHelper.getHashCode(blockId, blockMeta)) || buckets.inverse().containsKey((Object)ItemHelper.getHashCode(bucket))) {
            return false;
        }
        buckets.put((Object)ItemHelper.getHashCode(blockId, blockMeta), (Object)ItemHelper.getHashCode(bucket));
        return true;
    }

    public static ItemStack fillBucket(World world, MovingObjectPosition pos) {
        return BucketHandler.fillBucket(world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
    }

    public static ItemStack fillBucket(World world, int x, int y, int z) {
        int blockMeta;
        int blockId = world.func_72798_a(x, y, z);
        if (!buckets.containsKey((Object)ItemHelper.getHashCode(blockId, blockMeta = world.func_72805_g(x, y, z)))) {
            return null;
        }
        world.func_94575_c(x, y, z, 0);
        int hashCode = (Integer)buckets.get((Object)ItemHelper.getHashCode(blockId, blockMeta));
        return new ItemStack(ItemHelper.getIDFromHashCode(hashCode), 1, ItemHelper.getMetaFromHashCode(hashCode));
    }

    public static boolean emptyBucket(World world, int x, int y, int z, ItemStack bucket) {
        if (!buckets.inverse().containsKey((Object)ItemHelper.getHashCode(bucket))) {
            return false;
        }
        int hashCode = (Integer)buckets.inverse().get((Object)ItemHelper.getHashCode(bucket));
        world.func_72832_d(x, y, z, ItemHelper.getIDFromHashCode(hashCode), ItemHelper.getMetaFromHashCode(hashCode), 3);
        return true;
    }
}

