/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.Items;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import resonant.lib.content.ContentRegistry;
import resonant.lib.modproxy.ProxyHandler;
import resonant.lib.network.PacketHandler;
import resonant.lib.recipe.UniversalRecipe;
import resonantinduction.core.Settings;
import resonantinduction.core.TabRI;
import resonantinduction.core.resource.ItemResourcePart;
import resonantinduction.electrical.CommonProxy;
import resonantinduction.electrical.MultipartElectrical;
import resonantinduction.electrical.armbot.BlockArmbot;
import resonantinduction.electrical.armbot.TileArmbot;
import resonantinduction.electrical.battery.BlockBattery;
import resonantinduction.electrical.battery.ItemBlockBattery;
import resonantinduction.electrical.battery.TileBattery;
import resonantinduction.electrical.charger.ItemCharger;
import resonantinduction.electrical.generator.BlockMotor;
import resonantinduction.electrical.generator.TileMotor;
import resonantinduction.electrical.generator.solar.TileSolarPanel;
import resonantinduction.electrical.generator.thermopile.BlockThermopile;
import resonantinduction.electrical.generator.thermopile.TileThermopile;
import resonantinduction.electrical.laser.gun.ItemMiningLaser;
import resonantinduction.electrical.levitator.ItemLevitator;
import resonantinduction.electrical.multimeter.ItemMultimeter;
import resonantinduction.electrical.tesla.BlockTesla;
import resonantinduction.electrical.tesla.TileTesla;
import resonantinduction.electrical.transformer.ItemTransformer;
import resonantinduction.electrical.wire.EnumWireMaterial;
import resonantinduction.electrical.wire.ItemWire;
import resonantinduction.quantum.gate.ItemQuantumGlyph;

@Mod(modid="ResonantInduction|Electrical", name="Resonant Induction Electrical", version="0.3.1", dependencies="before:ThermalExpansion;before:Mekanism;after:ResonantInduction|Mechanical;required-after:ResonantInduction|Core")
@NetworkMod(channels={"resonindc"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
public class Electrical {
    public static final String ID = "ResonantInduction|Electrical";
    public static final String NAME = "Resonant Induction Electrical";
    @Mod.Instance(value="ResonantInduction|Electrical")
    public static Electrical INSTANCE;
    @SidedProxy(clientSide="resonantinduction.electrical.ClientProxy", serverSide="resonantinduction.electrical.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Metadata(value="ResonantInduction|Electrical")
    public static ModMetadata metadata;
    public static final ContentRegistry contentRegistry;
    public static Item itemWire;
    public static Item itemMultimeter;
    public static Item itemTransformer;
    public static Item itemCharger;
    public static Block blockTesla;
    public static Block blockBattery;
    public static Block blockEncoder;
    public static Item itemRailing;
    public static Block blockSolarPanel;
    public static Block blockMotor;
    public static Block blockThermopile;
    public static Item itemLevitator;
    public static Block blockArmbot;
    public static Item itemDisk;
    public static Item itemInsulation;
    public static Block blockQuantumGate;
    public static Item itemQuantumGlyph;
    public static Item itemLaserGun;
    public ProxyHandler modproxies;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.modproxies = new ProxyHandler();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        Settings.CONFIGURATION.load();
        itemWire = contentRegistry.createItem(ItemWire.class);
        itemMultimeter = contentRegistry.createItem(ItemMultimeter.class);
        itemTransformer = contentRegistry.createItem(ItemTransformer.class);
        itemCharger = contentRegistry.createItem(ItemCharger.class);
        blockTesla = contentRegistry.createTile(BlockTesla.class, TileTesla.class);
        blockBattery = contentRegistry.createBlock(BlockBattery.class, ItemBlockBattery.class, TileBattery.class);
        blockArmbot = contentRegistry.createBlock(BlockArmbot.class, null, TileArmbot.class);
        itemLevitator = contentRegistry.createItem(ItemLevitator.class);
        itemInsulation = contentRegistry.createItem("insulation", ItemResourcePart.class);
        itemLaserGun = contentRegistry.createItem("laserDrill", ItemMiningLaser.class);
        blockSolarPanel = contentRegistry.newBlock(TileSolarPanel.class);
        blockMotor = contentRegistry.createTile(BlockMotor.class, TileMotor.class);
        blockThermopile = contentRegistry.createTile(BlockThermopile.class, TileThermopile.class);
        itemQuantumGlyph = contentRegistry.createItem(ItemQuantumGlyph.class);
        Settings.CONFIGURATION.save();
        OreDictionary.registerOre((String)"wire", (Item)itemWire);
        OreDictionary.registerOre((String)"motor", (Block)blockMotor);
        OreDictionary.registerOre((String)"battery", (ItemStack)ItemBlockBattery.setTier(new ItemStack(blockBattery, 1, 0), (byte)0));
        OreDictionary.registerOre((String)"batteryBox", (ItemStack)ItemBlockBattery.setTier(new ItemStack(blockBattery, 1, 0), (byte)0));
        TabRI.ITEMSTACK = new ItemStack(itemTransformer);
        for (EnumWireMaterial material : EnumWireMaterial.values()) {
            material.setWire(itemWire);
        }
        proxy.preInit();
        this.modproxies.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        Settings.setModMetadata((ModMetadata)metadata, (String)ID, (String)NAME, (String)"ResonantInduction|Core");
        MultipartElectrical.INSTANCE = new MultipartElectrical();
        proxy.init();
        this.modproxies.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockTesla, new Object[]{"WEW", " C ", "DID", Character.valueOf('W'), "wire", Character.valueOf('E'), Item.field_77748_bA, Character.valueOf('C'), UniversalRecipe.BATTERY.get(), Character.valueOf('D'), Item.field_77702_n, Character.valueOf('I'), UniversalRecipe.PRIMARY_PLATE.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemMultimeter, new Object[]{"WWW", "ICI", Character.valueOf('W'), "wire", Character.valueOf('C'), UniversalRecipe.BATTERY.get(), Character.valueOf('I'), UniversalRecipe.PRIMARY_METAL.get()}));
        ItemStack tierOneBattery = ItemBlockBattery.setTier(new ItemStack(blockBattery, 1, 0), (byte)0);
        ItemStack tierTwoBattery = ItemBlockBattery.setTier(new ItemStack(blockBattery, 1, 0), (byte)1);
        ItemStack tierThreeBattery = ItemBlockBattery.setTier(new ItemStack(blockBattery, 1, 0), (byte)2);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tierOneBattery, new Object[]{"III", "IRI", "III", Character.valueOf('R'), Block.field_94341_cq, Character.valueOf('I'), UniversalRecipe.PRIMARY_METAL.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tierTwoBattery, new Object[]{"RRR", "RIR", "RRR", Character.valueOf('R'), tierOneBattery, Character.valueOf('I'), UniversalRecipe.PRIMARY_PLATE.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tierThreeBattery, new Object[]{"RRR", "RIR", "RRR", Character.valueOf('R'), tierTwoBattery, Character.valueOf('I'), Block.field_72071_ax}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWireMaterial.COPPER.getWire(3), new Object[]{"MMM", Character.valueOf('M'), "ingotCopper"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWireMaterial.TIN.getWire(3), new Object[]{"MMM", Character.valueOf('M'), "ingotTin"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWireMaterial.IRON.getWire(3), new Object[]{"MMM", Character.valueOf('M'), Item.field_77703_o}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWireMaterial.ALUMINUM.getWire(3), new Object[]{"MMM", Character.valueOf('M'), "ingotAluminum"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWireMaterial.SILVER.getWire(), new Object[]{"MMM", Character.valueOf('M'), "ingotSilver"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWireMaterial.SUPERCONDUCTOR.getWire(3), new Object[]{"MMM", Character.valueOf('M'), "ingotSuperconductor"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWireMaterial.SUPERCONDUCTOR.getWire(3), new Object[]{"MMM", "MEM", "MMM", Character.valueOf('M'), Item.field_77717_p, Character.valueOf('E'), Item.field_77748_bA}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemCharger, new Object[]{"WWW", "ICI", Character.valueOf('W'), "wire", Character.valueOf('I'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemTransformer, new Object[]{"WWW", "WWW", "III", Character.valueOf('W'), "wire", Character.valueOf('I'), UniversalRecipe.PRIMARY_METAL.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemQuantumGlyph, 1, 0), new Object[]{" CT", "LBL", "TCT", Character.valueOf('B'), Block.field_72071_ax, Character.valueOf('L'), itemLevitator, Character.valueOf('C'), itemCharger, Character.valueOf('T'), blockTesla}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemQuantumGlyph, 1, 1), new Object[]{"TCT", "LBL", " CT", Character.valueOf('B'), Block.field_72071_ax, Character.valueOf('L'), itemLevitator, Character.valueOf('C'), itemCharger, Character.valueOf('T'), blockTesla}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemQuantumGlyph, 1, 2), new Object[]{"TC ", "LBL", "TCT", Character.valueOf('B'), Block.field_72071_ax, Character.valueOf('L'), itemLevitator, Character.valueOf('C'), itemCharger, Character.valueOf('T'), blockTesla}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemQuantumGlyph, 1, 3), new Object[]{"TCT", "LBL", "TC ", Character.valueOf('B'), Block.field_72071_ax, Character.valueOf('L'), itemLevitator, Character.valueOf('C'), itemCharger, Character.valueOf('T'), blockTesla}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockSolarPanel, new Object[]{"CCC", "WWW", "III", Character.valueOf('W'), "wire", Character.valueOf('C'), Item.field_77705_m, Character.valueOf('I'), UniversalRecipe.PRIMARY_METAL.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockMotor, new Object[]{"SRS", "SMS", "SWS", Character.valueOf('W'), "wire", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('M'), Block.field_72083_ai, Character.valueOf('S'), UniversalRecipe.PRIMARY_METAL.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockThermopile, new Object[]{"ORO", "OWO", "OOO", Character.valueOf('W'), "wire", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemLaserGun, new Object[]{"RDR", "RDR", "ICB", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('I'), Item.field_77717_p, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('B'), ItemBlockBattery.setTier(new ItemStack(blockBattery, 1, 0), (byte)0)}));
        if (Loader.isModLoaded((String)"IC2")) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(EnumWireMaterial.COPPER.getWire(), new Object[]{Items.getItem((String)"copperCableItem")}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(EnumWireMaterial.TIN.getWire(), new Object[]{Items.getItem((String)"tinCableItem")}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(EnumWireMaterial.IRON.getWire(), new Object[]{Items.getItem((String)"ironCableItem")}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.getItem((String)"copperCableItem"), new Object[]{EnumWireMaterial.COPPER.getWire()}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.getItem((String)"tinCableItem"), new Object[]{EnumWireMaterial.TIN.getWire()}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.getItem((String)"ironCableItem"), new Object[]{EnumWireMaterial.IRON.getWire()}));
        }
        if (Loader.isModLoaded((String)"Mekanism")) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(EnumWireMaterial.COPPER.getWire(), new Object[]{"universalCable"}));
        }
        proxy.postInit();
        this.modproxies.postInit();
    }

    static {
        contentRegistry = new ContentRegistry(Settings.CONFIGURATION, Settings.idManager, ID).setPrefix("resonantinduction:").setTab((CreativeTabs)TabRI.DEFAULT);
    }
}

