/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataInput;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.multiblock.IMultiBlock;
import resonant.lib.network.IPacketReceiverWithID;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.tile.TileElectrical;
import resonant.lib.type.Pair;
import resonant.lib.utility.MathUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.ResonantInduction;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.armbot.Program;
import resonantinduction.electrical.armbot.task.TaskDrop;
import resonantinduction.electrical.armbot.task.TaskGOTO;
import resonantinduction.electrical.armbot.task.TaskGrabItem;
import resonantinduction.electrical.armbot.task.TaskReturn;
import resonantinduction.electrical.armbot.task.TaskRotateTo;
import resonantinduction.electrical.encoder.coding.IProgram;
import resonantinduction.electrical.encoder.coding.ProgramHelper;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector2;
import universalelectricity.api.vector.Vector3;

public class TileArmbot
extends TileElectrical
implements IMultiBlock,
IArmbot,
IPacketReceiverWithID {
    protected int ROTATION_SPEED = 6;
    protected int targetPitch = 0;
    protected int targetYaw = 0;
    protected int actualPitch = 0;
    protected int actualYaw = 0;
    protected boolean spawnEntity = false;
    protected String displayText = "";
    protected Object grabbedObject = null;
    protected ProgramHelper programHelper;
    protected Pair<World, Vector3> location;
    public EntityItem renderEntityItem;
    private boolean functioning;
    public static final int ARMBOT_PACKET_ID = 3;
    public static final int ROTATION_PACKET_ID = 4;

    public TileArmbot() {
        this.energy = new EnergyStorageHandler(5000L, 1000L);
        this.programHelper = new ProgramHelper(this).setMemoryLimit(20);
        Program program = new Program();
        program.setTaskAt(0, 0, new TaskDrop());
        program.setTaskAt(0, 1, new TaskRotateTo(180, 0));
        program.setTaskAt(0, 2, new TaskGrabItem());
        program.setTaskAt(0, 3, new TaskReturn());
        program.setTaskAt(0, 4, new TaskGOTO(0, 0));
        this.programHelper.setProgram(program);
    }

    public void func_70316_g() {
        super.func_70316_g();
        Vector3 handPosition = this.getHandPos();
        if (this.location == null || !((World)this.location.left()).equals(this.field_70331_k) || this.field_70329_l != ((Vector3)this.location.right()).intX() || this.field_70330_m != ((Vector3)this.location.right()).intY() || this.field_70327_n != ((Vector3)this.location.right()).intZ()) {
            this.location = new Pair((Object)this.field_70331_k, (Object)new Vector3((TileEntity)this));
        }
        if (this.grabbedObject instanceof Entity) {
            if (this.spawnEntity) {
                this.field_70331_k.func_72838_d((Entity)this.grabbedObject);
                this.spawnEntity = false;
            }
            ((Entity)this.grabbedObject).func_70107_b(handPosition.x, handPosition.y, handPosition.z);
            ((Entity)this.grabbedObject).field_70159_w = 0.0;
            ((Entity)this.grabbedObject).field_70181_x = 0.0;
            ((Entity)this.grabbedObject).field_70179_y = 0.0;
            if (this.grabbedObject instanceof EntityItem) {
                ((EntityItem)this.grabbedObject).field_70293_c = 20;
                ((EntityItem)this.grabbedObject).field_70292_b = 0;
            }
        }
        if (this.energy.checkExtract()) {
            float preYaw = this.targetYaw;
            float prePitch = this.targetPitch;
            if (!this.field_70331_k.field_72995_K && this.ticks % 5L == 0L) {
                this.programHelper.onUpdate(this.field_70331_k, new Vector3((TileEntity)this));
                if ((float)this.targetYaw != preYaw || (float)this.targetPitch != prePitch) {
                    PacketHandler.sendPacketToClients((Packet)this.func_70319_e(), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this).translate((IVector3)new Vector3(0.5, 1.0, 0.5)), (double)64.0);
                }
            }
            this.updateRotation();
            this.energy.extractEnergy();
        }
    }

    public void updateRotation() {
        this.targetYaw = (int)MathUtility.clampAngleTo360((float)this.targetYaw);
        if (this.targetPitch < 0) {
            this.targetPitch = 0;
        }
        if (this.targetPitch > 60) {
            this.targetPitch = 60;
        }
        if (Math.abs(this.actualYaw - this.targetYaw) > 1) {
            float speedYaw = this.actualYaw > this.targetYaw ? (Math.abs(this.actualYaw - this.targetYaw) >= 180 ? (float)this.ROTATION_SPEED : (float)(-this.ROTATION_SPEED)) : (Math.abs(this.actualYaw - this.targetYaw) >= 180 ? (float)(-this.ROTATION_SPEED) : (float)this.ROTATION_SPEED);
            this.actualYaw = (int)((float)this.actualYaw + speedYaw);
            if (Math.abs(this.actualYaw - this.targetYaw) < this.ROTATION_SPEED) {
                this.actualYaw = this.targetYaw;
            }
            this.playRotationSound();
        }
        if (Math.abs(this.actualPitch - this.targetPitch) > 1) {
            this.actualPitch = this.actualPitch > this.targetPitch ? (this.actualPitch -= this.ROTATION_SPEED) : (this.actualPitch += this.ROTATION_SPEED);
            if (Math.abs(this.actualPitch - this.targetPitch) < this.ROTATION_SPEED) {
                this.actualPitch = this.targetPitch;
            }
            this.playRotationSound();
        }
        this.actualYaw = (int)MathUtility.clampAngleTo360((float)this.actualYaw);
        if (this.actualPitch < 0) {
            this.actualPitch = 0;
        }
        if (this.actualPitch > 60) {
            this.actualPitch = 60;
        }
    }

    public void playRotationSound() {
        if (this.ticks % 5L == 0L && this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72980_b((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "mods.assemblyline.conveyor", 2.0f, 2.5f, true);
        }
    }

    public String getCommandDisplayText() {
        return this.displayText;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        ItemStack stack;
        super.func_70307_a(nbt);
        this.targetYaw = nbt.func_74762_e("armYaw");
        this.targetPitch = nbt.func_74762_e("armPitch");
        this.actualYaw = nbt.func_74762_e("armYawActual");
        this.actualPitch = nbt.func_74762_e("armPitchActual");
        if (nbt.func_74764_b("grabbedEntity")) {
            NBTTagCompound tag = nbt.func_74775_l("grabbedEntity");
            Entity entity = EntityList.func_75615_a((NBTTagCompound)tag, (World)this.field_70331_k);
            if (entity != null) {
                this.grabbedObject = entity;
                this.spawnEntity = true;
            }
        } else if (nbt.func_74764_b("grabbedItem") && (stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("grabbedItem"))) != null) {
            this.grabbedObject = stack;
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("armYaw", this.targetYaw);
        nbt.func_74768_a("armPitch", this.targetPitch);
        nbt.func_74768_a("armYawActual", this.actualYaw);
        nbt.func_74768_a("armPitchActual", this.actualPitch);
        if (this.grabbedObject instanceof Entity) {
            NBTTagCompound entityNBT = new NBTTagCompound();
            ((Entity)this.grabbedObject).func_70109_d(entityNBT);
            ((Entity)this.grabbedObject).func_70039_c(entityNBT);
            nbt.func_74766_a("grabbedEntity", entityNBT);
        } else if (this.grabbedObject instanceof ItemStack) {
            nbt.func_74766_a("grabbedItem", ((ItemStack)this.grabbedObject).func_77955_b(new NBTTagCompound()));
        }
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{"armbot", this.energy.checkExtract(), this.targetYaw, this.targetPitch, this.actualYaw, this.actualPitch});
    }

    public void sendGrabItemToClient() {
        if (this.grabbedObject instanceof ItemStack) {
            PacketHandler.sendPacketToClients((Packet)ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{"armbotItem", true, ((ItemStack)this.grabbedObject).func_77955_b(new NBTTagCompound())}), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)64.0);
        } else {
            PacketHandler.sendPacketToClients((Packet)ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{"armbotItem", false}), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)64.0);
        }
    }

    public boolean onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            if (this.field_70331_k.field_72995_K) {
                if (id == 3) {
                    this.functioning = data.readBoolean();
                    this.targetYaw = data.readInt();
                    this.targetPitch = data.readInt();
                    this.actualYaw = data.readInt();
                    this.actualPitch = data.readInt();
                    return true;
                }
                if (id == 4) {
                    this.grabbedObject = data.readBoolean() ? ItemStack.func_77949_a((NBTTagCompound)PacketHandler.readNBTTagCompound((DataInput)data)) : null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Vector3[] getMultiBlockVectors() {
        return new Vector3[]{new Vector3(0.0, 1.0, 0.0)};
    }

    @Override
    public Object getHeldObject() {
        return this.grabbedObject;
    }

    @Override
    public boolean grabObject(Object entity) {
        if (this.getHeldObject() == null) {
            if (entity instanceof ItemStack) {
                this.grabbedObject = entity;
                this.sendGrabItemToClient();
                return true;
            }
            if (entity instanceof EntityItem) {
                this.grabbedObject = ((EntityItem)entity).func_92059_d();
                ((EntityItem)entity).func_70106_y();
                this.sendGrabItemToClient();
                return true;
            }
            if (entity instanceof Entity) {
                this.grabbedObject = entity;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean dropHeldObject() {
        if (this.getHeldObject() != null) {
            if (this.getHeldObject() instanceof ItemStack) {
                Vector3 handPosition = this.getHandPos();
                InventoryUtility.dropItemStack((World)this.field_70331_k, (Vector3)handPosition, (ItemStack)((ItemStack)this.getHeldObject()));
            }
            this.grabbedObject = null;
            this.sendGrabItemToClient();
            return true;
        }
        return false;
    }

    @Override
    public Vector3 getHandPos() {
        Vector3 position = new Vector3((TileEntity)this);
        position.translate(0.5);
        position.translate((IVector3)this.getDeltaHandPosition());
        return position;
    }

    public Vector3 getDeltaHandPosition() {
        double distance = 1.0;
        Vector3 delta = new Vector3();
        delta.y = Math.sin(Math.toRadians(this.actualPitch)) * distance * 2.0;
        double dH = Math.cos(Math.toRadians(this.actualPitch)) * distance;
        delta.x = Math.sin(Math.toRadians(-this.actualYaw)) * dH;
        delta.z = Math.cos(Math.toRadians(-this.actualYaw)) * dH;
        return delta;
    }

    @Override
    public Vector2 getRotation() {
        return new Vector2((double)this.actualYaw, (double)this.actualPitch);
    }

    @Override
    public void setRotation(int yaw, int pitch) {
        if (!this.field_70331_k.field_72995_K) {
            this.actualYaw = yaw;
            this.actualPitch = pitch;
        }
    }

    @Override
    public boolean moveArmTo(int yaw, int pitch) {
        if (!this.field_70331_k.field_72995_K) {
            this.targetYaw = yaw;
            this.targetPitch = pitch;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(ForgeDirection direction) {
        if (direction == ForgeDirection.SOUTH) {
            this.targetYaw = 0;
            return true;
        }
        if (direction == ForgeDirection.EAST) {
            this.targetYaw = 90;
            return true;
        }
        if (direction == ForgeDirection.NORTH) {
            this.targetYaw = 180;
            return true;
        }
        if (direction == ForgeDirection.WEST) {
            this.targetYaw = 270;
            return true;
        }
        return false;
    }

    @Override
    public IProgram getCurrentProgram() {
        if (this.programHelper == null) {
            this.programHelper = new ProgramHelper(this);
        }
        if (this.programHelper != null) {
            return this.programHelper.getProgram();
        }
        return null;
    }

    @Override
    public void setCurrentProgram(IProgram program) {
        if (this.programHelper == null) {
            this.programHelper = new ProgramHelper(this);
        }
        if (this.programHelper != null) {
            this.programHelper.setProgram(program);
        }
    }

    @Override
    public boolean clear(Object object) {
        if (this.grabbedObject != null && this.grabbedObject.equals(object)) {
            this.grabbedObject = null;
            return true;
        }
        return false;
    }

    @Override
    public Pair<World, Vector3> getLocation() {
        return this.location;
    }
}

