/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import resonant.lib.science.units.UnitHelper;
import resonant.lib.type.Pair;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.armbot.TaskBaseArmbot;
import resonantinduction.electrical.armbot.TaskBaseProcess;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.args.ArgumentFloatData;
import universalelectricity.api.vector.Vector3;

public class TaskFire
extends TaskBaseArmbot {
    private static final float MIN_ACTUAL_PITCH = -80.0f;
    private static final float MAX_ACTUAL_PITCH = 80.0f;
    private float actualYaw;
    private float actualPitch;
    private float velocity;
    private Vector3 finalVelocity;

    public TaskFire() {
        super("throw");
        this.args.add(new ArgumentFloatData("velocity", 1.0f, 2.5f, 1.0f));
    }

    @Override
    public IProcessTask.ProcessReturn onMethodCalled() {
        if (super.onMethodCalled() == IProcessTask.ProcessReturn.CONTINUE) {
            this.velocity = UnitHelper.tryToParseFloat((Object)this.getArg("velocity")).floatValue();
            if (this.velocity > 2.5f) {
                this.velocity = 2.5f;
            }
            if (this.velocity < 0.125f) {
                this.velocity = 1.0f;
            }
            this.actualYaw = (float)((IArmbot)this.program.getMachine()).getRotation().x;
            this.actualPitch = 160.0f * ((float)((IArmbot)this.program.getMachine()).getRotation().y / 60.0f) + -80.0f;
            double yaw = Math.toRadians(this.actualYaw);
            double pitch = Math.toRadians(this.actualPitch);
            double x = -Math.sin(yaw) * Math.cos(pitch);
            double y = Math.sin(pitch);
            double z = Math.cos(yaw) * Math.cos(pitch);
            this.finalVelocity = new Vector3(x, y, z);
            Random random = new Random(System.currentTimeMillis());
            this.finalVelocity.x *= (double)(0.995f + random.nextFloat() * 0.01f);
            this.finalVelocity.y *= (double)(0.995f + random.nextFloat() * 0.01f);
            this.finalVelocity.z *= (double)(0.995f + random.nextFloat() * 0.01f);
            this.finalVelocity.scale((double)this.velocity);
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public IProcessTask.ProcessReturn onUpdate() {
        if (super.onUpdate() == IProcessTask.ProcessReturn.CONTINUE) {
            if (this.finalVelocity == null) {
                this.finalVelocity = new Vector3(0.0, 0.0, 0.0);
            }
            if (((IArmbot)this.program.getMachine()).getHeldObject() != null) {
                Entity held = null;
                Object obj = ((IArmbot)this.program.getMachine()).getHeldObject();
                Pair<World, Vector3> location = this.program.getMachine().getLocation();
                if (obj instanceof Entity) {
                    held = (Entity)obj;
                }
                if (held != null) {
                    ((World)location.left()).func_72980_b(((Vector3)location.right()).x, ((Vector3)location.right()).y, ((Vector3)location.right()).z, "random.bow", this.velocity, 2.0f - this.velocity / 4.0f, true);
                    if (held instanceof EntityItem) {
                        EntityItem item = (EntityItem)held;
                        ItemStack stack = item.func_92059_d();
                        ItemStack thrown = stack.func_77946_l();
                        thrown.field_77994_a = 1;
                        if (item.func_92059_d().field_77994_a > 0) {
                            --stack.field_77994_a;
                            item.func_92058_a(stack);
                        } else {
                            ((IArmbot)this.program.getMachine()).dropHeldObject();
                            if (!((World)location.left()).field_72995_K) {
                                ((World)location.left()).func_72900_e(held);
                            }
                        }
                        if (item.func_92059_d().field_77993_c == Item.field_77704_l.field_77779_bT) {
                            EntityArrow arrow = new EntityArrow((World)location.left(), ((IArmbot)this.program.getMachine()).getHandPos().x, ((IArmbot)this.program.getMachine()).getHandPos().y, ((IArmbot)this.program.getMachine()).getHandPos().z);
                            arrow.field_70159_w = this.finalVelocity.x;
                            arrow.field_70181_x = this.finalVelocity.y;
                            arrow.field_70179_y = this.finalVelocity.z;
                            if (!((World)location.left()).field_72995_K) {
                                ((World)location.left()).func_72838_d((Entity)arrow);
                            }
                        } else {
                            EntityItem item2 = new EntityItem((World)location.left(), ((IArmbot)this.program.getMachine()).getHandPos().x, ((IArmbot)this.program.getMachine()).getHandPos().y, ((IArmbot)this.program.getMachine()).getHandPos().z, thrown);
                            item2.field_70159_w = this.finalVelocity.x;
                            item2.field_70181_x = this.finalVelocity.y;
                            item2.field_70179_y = this.finalVelocity.z;
                            if (!((World)location.left()).field_72995_K) {
                                ((World)location.left()).func_72838_d((Entity)item2);
                            }
                        }
                    } else {
                        ((IArmbot)this.program.getMachine()).dropHeldObject();
                        held.field_70159_w = this.finalVelocity.x;
                        held.field_70181_x = this.finalVelocity.y;
                        held.field_70179_y = this.finalVelocity.z;
                    }
                }
            }
            return IProcessTask.ProcessReturn.DONE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public TaskBaseProcess loadProgress(NBTTagCompound taskCompound) {
        super.loadProgress(taskCompound);
        this.actualYaw = taskCompound.func_74760_g("fireYaw");
        this.actualPitch = taskCompound.func_74760_g("firePitch");
        this.velocity = taskCompound.func_74760_g("fireVelocity");
        this.finalVelocity = new Vector3();
        this.finalVelocity.x = taskCompound.func_74769_h("fireVectorX");
        this.finalVelocity.y = taskCompound.func_74769_h("fireVectorY");
        this.finalVelocity.z = taskCompound.func_74769_h("fireVectorZ");
        return this;
    }

    @Override
    public NBTTagCompound saveProgress(NBTTagCompound taskCompound) {
        super.saveProgress(taskCompound);
        taskCompound.func_74776_a("fireYaw", this.actualYaw);
        taskCompound.func_74776_a("firePitch", this.actualPitch);
        taskCompound.func_74776_a("fireVelocity", this.velocity);
        if (this.finalVelocity != null) {
            taskCompound.func_74780_a("fireVectorX", this.finalVelocity.x);
            taskCompound.func_74780_a("fireVectorY", this.finalVelocity.y);
            taskCompound.func_74780_a("fireVectorZ", this.finalVelocity.z);
        }
        return taskCompound;
    }

    @Override
    public String toString() {
        return super.toString() + " " + Float.toString(this.velocity);
    }

    @Override
    public TaskBaseProcess clone() {
        return new TaskFire();
    }
}

