/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import resonant.lib.science.units.UnitHelper;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.armbot.TaskBaseProcess;
import resonantinduction.electrical.armbot.task.TaskGrabPrefab;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.args.ArgumentIntData;

public class TaskGrabItem
extends TaskGrabPrefab {
    ItemStack stack = null;

    public TaskGrabItem() {
        super("Grab-Item");
        this.args.add(new ArgumentIntData("blockID", -1, Block.field_71973_m.length - 1, -1));
        this.args.add(new ArgumentIntData("blockMeta", -1, 15, -1));
        this.args.add(new ArgumentIntData("stackSize", -1, 64, -1));
    }

    @Override
    public IProcessTask.ProcessReturn onMethodCalled() {
        if (super.onMethodCalled() == IProcessTask.ProcessReturn.CONTINUE) {
            int ammount = UnitHelper.tryToParseInt((Object)this.getArg("stackSize"), (int)-1);
            int blockID = UnitHelper.tryToParseInt((Object)this.getArg("blockID"), (int)-1);
            int blockMeta = UnitHelper.tryToParseInt((Object)this.getArg("blockMeta"), (int)Short.MAX_VALUE);
            if (blockID > 0) {
                this.stack = new ItemStack(blockID, ammount <= 0 ? 1 : ammount, blockMeta == -1 ? Short.MAX_VALUE : blockMeta);
            }
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public IProcessTask.ProcessReturn onUpdate() {
        if (super.onUpdate() == IProcessTask.ProcessReturn.CONTINUE) {
            if (((IArmbot)this.program.getMachine()).getHeldObject() != null) {
                return IProcessTask.ProcessReturn.DONE;
            }
            List found = ((World)this.program.getMachine().getLocation().left()).func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.armPos.x - 0.5), (double)(this.armPos.y - 0.5), (double)(this.armPos.z - 0.5), (double)(this.armPos.x + 0.5), (double)(this.armPos.y + 0.5), (double)(this.armPos.z + 0.5)));
            if (found != null && found.size() > 0) {
                for (EntityItem item : found) {
                    if (this.stack != null && !item.func_92059_d().func_77969_a(this.stack) || !((IArmbot)this.program.getMachine()).grabObject(item)) continue;
                    if (this.belt != null) {
                        this.belt.ignoreEntity((Entity)item);
                    }
                    return IProcessTask.ProcessReturn.DONE;
                }
            }
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public TaskBaseProcess clone() {
        return new TaskGrabItem();
    }
}

