/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.armbot.task;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.lib.science.units.UnitHelper;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.armbot.IArmbotUseable;
import resonantinduction.electrical.armbot.TaskBaseArmbot;
import resonantinduction.electrical.armbot.TaskBaseProcess;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.args.ArgumentIntData;

public class TaskUse
extends TaskBaseArmbot {
    protected int times;
    protected int curTimes;

    public TaskUse() {
        super("use");
        this.args.add(new ArgumentIntData("repeat", 1, Integer.MAX_VALUE, 1));
    }

    @Override
    public IProcessTask.ProcessReturn onMethodCalled() {
        if (super.onMethodCalled() == IProcessTask.ProcessReturn.CONTINUE) {
            this.curTimes = 0;
            this.times = UnitHelper.tryToParseInt((Object)this.getArg("repeat"));
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public IProcessTask.ProcessReturn onUpdate() {
        if (super.onUpdate() == IProcessTask.ProcessReturn.CONTINUE) {
            Block block = Block.field_71973_m[((IArmbot)this.program.getMachine()).getHandPos().getBlockID((IBlockAccess)this.program.getMachine().getLocation().left())];
            TileEntity targetTile = ((IArmbot)this.program.getMachine()).getHandPos().getTileEntity((IBlockAccess)this.program.getMachine().getLocation().left());
            if (targetTile != null) {
                if (targetTile instanceof IArmbotUseable) {
                    ((IArmbotUseable)targetTile).onUse((IArmbot)this.program.getMachine(), this.getArgs());
                }
            } else if (block != null) {
                try {
                    boolean f = block.func_71903_a((World)this.program.getMachine().getLocation().left(), ((IArmbot)this.program.getMachine()).getHandPos().intX(), ((IArmbot)this.program.getMachine()).getHandPos().intY(), ((IArmbot)this.program.getMachine()).getHandPos().intZ(), null, 0, 0.0f, 0.0f, 0.0f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++this.curTimes;
            if (this.curTimes >= this.times) {
                return IProcessTask.ProcessReturn.DONE;
            }
            return IProcessTask.ProcessReturn.CONTINUE;
        }
        return IProcessTask.ProcessReturn.GENERAL_ERROR;
    }

    @Override
    public String toString() {
        return "USE " + Integer.toString(this.times);
    }

    @Override
    public void load(NBTTagCompound taskCompound) {
        super.load(taskCompound);
        this.times = taskCompound.func_74762_e("useTimes");
    }

    @Override
    public void save(NBTTagCompound taskCompound) {
        super.save(taskCompound);
        taskCompound.func_74768_a("useTimes", this.times);
    }

    @Override
    public IProcessTask loadProgress(NBTTagCompound nbt) {
        this.curTimes = nbt.func_74762_e("useCurTimes");
        return this;
    }

    @Override
    public NBTTagCompound saveProgress(NBTTagCompound nbt) {
        nbt.func_74768_a("useCurTimes", this.curTimes);
        return nbt;
    }

    @Override
    public TaskBaseProcess clone() {
        return new TaskUse();
    }

    @Override
    public void getToolTips(List<String> list) {
        super.getToolTips(list);
        list.add(" Repeat:   " + this.times);
    }
}

