/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.battery;

import java.util.Arrays;
import java.util.LinkedHashSet;
import resonantinduction.electrical.battery.TileEnergyDistribution;
import universalelectricity.core.net.Network;

public class EnergyDistributionNetwork
extends Network<EnergyDistributionNetwork, TileEnergyDistribution> {
    public long totalEnergy = 0L;
    public long totalCapacity = 0L;

    public EnergyDistributionNetwork() {
        super(TileEnergyDistribution.class);
    }

    public void redistribute(TileEnergyDistribution ... exclusion) {
        int lowestY = 255;
        int highestY = 0;
        this.totalEnergy = 0L;
        this.totalCapacity = 0L;
        for (TileEnergyDistribution connector : this.getConnectors()) {
            this.totalEnergy += connector.getEnergyHandler().getEnergy();
            this.totalCapacity += connector.getEnergyHandler().getEnergyCapacity();
            lowestY = Math.min(connector.field_70330_m, lowestY);
            highestY = Math.max(connector.field_70330_m, highestY);
            connector.renderEnergyAmount = 0L;
        }
        long remainingRenderEnergy = this.totalEnergy;
        for (int y = lowestY; y <= highestY; ++y) {
            LinkedHashSet<TileEnergyDistribution> connectorsInlevel = new LinkedHashSet<TileEnergyDistribution>();
            for (TileEnergyDistribution connector : this.getConnectors()) {
                if (connector.field_70330_m != y) continue;
                connectorsInlevel.add(connector);
            }
            int levelSize = connectorsInlevel.size();
            long used = 0L;
            for (TileEnergyDistribution connector : connectorsInlevel) {
                long tryInject;
                connector.renderEnergyAmount = tryInject = Math.min(remainingRenderEnergy / (long)levelSize, connector.getEnergyHandler().getEnergyCapacity());
                used += tryInject;
            }
            if ((remainingRenderEnergy -= used) <= 0L) break;
        }
        double percentageLoss = 0.0;
        long energyLoss = (long)(percentageLoss * 100.0);
        this.totalEnergy -= energyLoss;
        int amountOfNodes = this.getConnectors().size() - exclusion.length;
        if (this.totalEnergy > 0L && amountOfNodes > 0) {
            long remainingEnergy = this.totalEnergy;
            TileEnergyDistribution firstNode = (TileEnergyDistribution)this.getFirstConnector();
            for (TileEnergyDistribution node : this.getConnectors()) {
                if (node == firstNode || Arrays.asList(exclusion).contains((Object)node)) continue;
                double percentage = (double)node.getEnergyHandler().getEnergyCapacity() / (double)this.totalCapacity;
                long energyForBattery = Math.max(Math.round((double)this.totalEnergy * percentage), 0L);
                node.getEnergyHandler().setEnergy(energyForBattery);
                remainingEnergy -= energyForBattery;
            }
            firstNode.getEnergyHandler().setEnergy(Math.max(remainingEnergy, 0L));
        }
    }

    protected void reconstructConnector(TileEnergyDistribution node) {
        node.setNetwork(this);
    }

    public EnergyDistributionNetwork newInstance() {
        return new EnergyDistributionNetwork();
    }
}

