/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.battery;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import resonant.lib.render.EnumColor;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.electrical.battery.TileBattery;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalClass;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.energy.UnitDisplay;
import universalelectricity.api.item.IEnergyItem;
import universalelectricity.api.item.IVoltageItem;

@UniversalClass
public class ItemBlockBattery
extends ItemBlock
implements IEnergyItem,
IVoltageItem {
    public ItemBlockBattery(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        list.add(LanguageUtility.getLocal((String)"tooltip.tier") + ": " + (ItemBlockBattery.getTier(itemStack) + 1));
        String color = "";
        long joules = this.getEnergy(itemStack);
        color = joules <= this.getEnergyCapacity(itemStack) / 3L ? "\u00a74" : (joules > this.getEnergyCapacity(itemStack) * 2L / 3L ? "\u00a72" : "\u00a76");
        itemStack.func_77952_i();
        list.add(LanguageUtility.getLocal((String)"tooltip.battery.energy").replace("%0", color).replace("%1", EnumColor.GREY.toString()).replace("%v0", UnitDisplay.getDisplayShort((double)joules, (UnitDisplay.Unit)UnitDisplay.Unit.JOULES)).replace("%v1", UnitDisplay.getDisplayShort((double)this.getEnergyCapacity(itemStack), (UnitDisplay.Unit)UnitDisplay.Unit.JOULES)));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setEnergy(itemStack, 0L);
    }

    public long recharge(ItemStack itemStack, long energy, boolean doReceive) {
        long rejectedElectricity = Math.max(this.getEnergy(itemStack) + energy - this.getEnergyCapacity(itemStack), 0L);
        long energyToReceive = Math.min(energy - rejectedElectricity, this.getTransferRate(itemStack));
        if (doReceive) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public long discharge(ItemStack itemStack, long energy, boolean doTransfer) {
        long energyToExtract = Math.min(Math.min(this.getEnergy(itemStack), energy), this.getTransferRate(itemStack));
        if (doTransfer) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) - energyToExtract);
        }
        return energyToExtract;
    }

    public long getVoltage(ItemStack itemStack) {
        return UniversalElectricity.DEFAULT_VOLTAGE;
    }

    public void setEnergy(ItemStack itemStack, long joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        long electricityStored = Math.max(Math.min(joules, this.getEnergyCapacity(itemStack)), 0L);
        itemStack.func_77978_p().func_74772_a("electricity", electricityStored);
    }

    public long getTransfer(ItemStack itemStack) {
        return this.getEnergyCapacity(itemStack) - this.getEnergy(itemStack);
    }

    public long getEnergy(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        long energyStored = itemStack.func_77978_p().func_74763_f("electricity");
        return energyStored;
    }

    public static ItemStack setTier(ItemStack itemStack, byte tier) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74774_a("tier", tier);
        return itemStack;
    }

    public static byte getTier(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p().func_74771_c("tier");
    }

    public int getDisplayDamage(ItemStack stack) {
        return (int)(100.0 - (double)this.getEnergy(stack) / (double)this.getEnergyCapacity(stack) * 100.0);
    }

    public long getEnergyCapacity(ItemStack theItem) {
        return TileBattery.getEnergyForTier(ItemBlockBattery.getTier(theItem));
    }

    public long getTransferRate(ItemStack itemStack) {
        return this.getEnergyCapacity(itemStack) / 100L;
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (byte tier = 0; tier <= 2; tier = (byte)(tier + 1)) {
            par3List.add(CompatibilityModule.getItemWithCharge((ItemStack)ItemBlockBattery.setTier(new ItemStack((Item)this), tier), (long)0L));
            par3List.add(CompatibilityModule.getItemWithCharge((ItemStack)ItemBlockBattery.setTier(new ItemStack((Item)this), tier), (long)TileBattery.getEnergyForTier(tier)));
        }
    }
}

