/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.charger;

import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.utility.WrenchUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.prefab.part.PartInventoryPanel;
import resonantinduction.electrical.Electrical;
import resonantinduction.electrical.charger.RenderCharger;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalClass;
import universalelectricity.api.energy.IEnergyInterface;

@UniversalClass
public class PartCharger
extends PartInventoryPanel
implements IEnergyInterface {
    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (WrenchUtility.isUsableWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)this.x(), (int)this.y(), (int)this.z())) {
            if (!this.world().field_72995_K) {
                WrenchUtility.damageWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)this.x(), (int)this.y(), (int)this.z());
                this.facing = (byte)((this.facing + 1) % 4);
                this.sendDescUpdate();
                this.tile().notifyPartChange((TMultiPart)this);
            }
            return true;
        }
        if (item != null && this.func_70301_a(0) == null && item != null && CompatibilityModule.isHandler((Object)item.func_77973_b())) {
            this.func_70299_a(0, item);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            if (!this.world().field_72995_K) {
                this.sendDescUpdate();
            }
            return true;
        }
        if (this.func_70301_a(0) != null) {
            InventoryUtility.dropItemStack((World)this.world(), (universalelectricity.api.vector.Vector3)new universalelectricity.api.vector.Vector3((Entity)player), (ItemStack)this.func_70301_a(0), (int)0);
            this.func_70299_a(0, null);
            if (!this.world().field_72995_K) {
                this.sendDescUpdate();
            }
        }
        return true;
    }

    public boolean canConnect(ForgeDirection direction, Object obj) {
        return obj instanceof IEnergyInterface && this.placementSide != direction.getOpposite();
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        if (receive > 0L) {
            long energyUsed = 0L;
            for (int slot = 0; slot < this.func_70302_i_() && (energyUsed += CompatibilityModule.chargeItem((ItemStack)this.func_70301_a(slot), (long)(receive - energyUsed), (boolean)doReceive)) < receive; ++slot) {
            }
            if (energyUsed > 0L) {
                this.markedForUpdate = true;
            }
            return energyUsed;
        }
        return 0L;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        return 0L;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderCharger.INSTANCE.render(this, pos.x, pos.y, pos.z);
        }
    }

    protected ItemStack getItem() {
        return new ItemStack(Electrical.itemCharger);
    }

    public String getType() {
        return "resonant_induction_charger";
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItem());
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            drops.add(this.func_70301_a(i));
        }
        return drops;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return slot < this.func_70302_i_() && stack != null && CompatibilityModule.isHandler((Object)stack.func_77973_b());
    }

    public String toString() {
        return "[PartCharger]" + this.x() + "x " + this.y() + "y " + this.z() + "z " + this.getSlotMask() + "s ";
    }
}

