/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.encoder.coding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import resonantinduction.electrical.armbot.IArmbot;
import resonantinduction.electrical.encoder.coding.IProcessTask;
import resonantinduction.electrical.encoder.coding.ITask;

public class TaskRegistry {
    private static final HashMap<String, ITask> COMMANDS = new HashMap();
    private static final HashMap<String, IArmbot> SUDO_BOTS = new HashMap();

    public static void registerCommand(ITask task) {
        if (!COMMANDS.containsKey(task.getMethodName())) {
            COMMANDS.put(task.getMethodName(), task);
        }
    }

    public static void registerCommand(String registryName, IProcessTask task) {
        if (!COMMANDS.containsKey(registryName)) {
            COMMANDS.put(registryName, task);
        }
    }

    public static ITask getCommand(String name) {
        for (Map.Entry<String, ITask> command : COMMANDS.entrySet()) {
            if (!command.getKey().equalsIgnoreCase(name)) continue;
            return command.getValue();
        }
        return null;
    }

    public static List<ITask> getCommands(String name) {
        ArrayList<ITask> tasks = new ArrayList<ITask>();
        for (Map.Entry<String, ITask> command : COMMANDS.entrySet()) {
            if (!command.getValue().getMethodName().equalsIgnoreCase(name)) continue;
            tasks.add(command.getValue());
        }
        return tasks;
    }

    public static void registerMachine(String name, IArmbot bot) {
        if (!SUDO_BOTS.containsKey(name)) {
            SUDO_BOTS.put(name, bot);
        }
    }

    public static HashMap<String, IArmbot> getSudoMachines() {
        return SUDO_BOTS;
    }

    public static IArmbot getBot(String string) {
        return SUDO_BOTS.get(string);
    }
}

