/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.generator;

import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IMechanicalNode;
import resonant.api.IRotatable;
import resonant.api.grid.INode;
import resonant.api.grid.INodeProvider;
import resonant.lib.grid.NodeRegistry;
import resonant.lib.prefab.tile.TileElectrical;
import universalelectricity.api.energy.EnergyStorageHandler;

public class TileMotor
extends TileElectrical
implements IRotatable,
INodeProvider {
    protected IMechanicalNode node;
    public boolean isInversed = true;
    private byte gearRatio;

    public TileMotor() {
        this.energy = new EnergyStorageHandler(1000000L);
        this.node = (IMechanicalNode)NodeRegistry.get((INodeProvider)this, IMechanicalNode.class);
        if (this.node != null) {
            this.node.setLoad(0.5);
        }
    }

    public byte toggleGearRatio() {
        this.gearRatio = (byte)((this.gearRatio + 1) % 3);
        return this.gearRatio;
    }

    public void initiate() {
        super.initiate();
        if (this.node != null) {
            this.node.reconstruct();
        }
    }

    public void func_70313_j() {
        this.node.deconstruct();
        super.func_70313_j();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.node != null) {
            if (!this.isInversed) {
                this.receiveMechanical();
                this.produce();
            } else {
                this.produceMechanical();
            }
        }
    }

    public void receiveMechanical() {
        double power = this.node.getEnergy();
        long receive = this.energy.receiveEnergy((long)power, true);
        if (receive > 0L) {
            double percentageUsed = (double)receive / power;
            this.node.apply((Object)this, -this.node.getTorque() * percentageUsed, -this.node.getAngularVelocity() * percentageUsed);
        }
    }

    public void produceMechanical() {
        long torqueRatio;
        long extract = this.energy.extractEnergy(this.energy.getEnergy(), false);
        if (extract > 0L && (torqueRatio = (long)((double)(this.gearRatio + 1) / 2.2 * (double)extract)) > 0L) {
            double currentVelo;
            double maxAngularVelocity = (float)extract / (float)torqueRatio;
            double maxTorque = (double)extract / maxAngularVelocity;
            double setAngularVelocity = maxAngularVelocity;
            double setTorque = maxTorque;
            double currentTorque = Math.abs(this.node.getTorque());
            if (currentTorque != 0.0) {
                setTorque = Math.min(setTorque, maxTorque) * (this.node.getTorque() / currentTorque);
            }
            if ((currentVelo = Math.abs(this.node.getAngularVelocity())) != 0.0) {
                setAngularVelocity = Math.min(setAngularVelocity, maxAngularVelocity) * (this.node.getAngularVelocity() / currentVelo);
            }
            this.node.apply((Object)this, setTorque - this.node.getTorque(), setAngularVelocity - this.node.getAngularVelocity());
            this.energy.extractEnergy((long)Math.abs(setTorque * setAngularVelocity), true);
        }
    }

    public EnumSet<ForgeDirection> getInputDirections() {
        return this.getOutputDirections();
    }

    public EnumSet<ForgeDirection> getOutputDirections() {
        EnumSet<ForgeDirection> dirs = EnumSet.allOf(ForgeDirection.class);
        dirs.remove(this.getDirection());
        dirs.remove(this.getDirection().getOpposite());
        return dirs;
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.func_70322_n());
    }

    public void setDirection(ForgeDirection dir) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, dir.ordinal(), 3);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.isInversed = nbt.func_74767_n("isInversed");
        this.gearRatio = nbt.func_74771_c("gear");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("isInversed", this.isInversed);
        nbt.func_74774_a("gear", this.gearRatio);
    }

    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if ((from == this.getDirection() || from == this.getDirection().getOpposite()) && nodeType.isAssignableFrom(this.node.getClass())) {
            return this.node;
        }
        return null;
    }
}

