/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.generator.thermopile;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.prefab.tile.TileElectrical;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.Vector3;

public class TileThermopile
extends TileElectrical {
    private final int MAX_USE_TICKS = 2400;
    private int usingTicks = 0;

    public TileThermopile() {
        this.energy = new EnergyStorageHandler(300L);
        this.ioMap = (short)728;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            int heatSources = 0;
            int coolingSources = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Vector3 checkPos = new Vector3((TileEntity)this).translate(dir);
                int blockID = checkPos.getBlockID((IBlockAccess)this.field_70331_k);
                if (blockID == Block.field_71943_B.field_71990_ca) {
                    ++coolingSources;
                    continue;
                }
                if (blockID == Block.field_72037_aS.field_71990_ca) {
                    coolingSources += 2;
                    continue;
                }
                if (blockID == Block.field_72036_aT.field_71990_ca) {
                    coolingSources += 2;
                    continue;
                }
                if (blockID == Block.field_72067_ar.field_71990_ca) {
                    ++heatSources;
                    continue;
                }
                if (blockID != Block.field_71938_D.field_71990_ca) continue;
                heatSources += 2;
            }
            int multiplier = 3 - Math.abs(heatSources - coolingSources);
            if (multiplier > 0 && coolingSources > 0 && heatSources > 0) {
                this.energy.receiveEnergy((long)(15 * multiplier), true);
                if (++this.usingTicks >= 2400) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        Vector3 checkPos = new Vector3((TileEntity)this).translate(dir);
                        int blockID = checkPos.getBlockID((IBlockAccess)this.field_70331_k);
                        if (blockID == Block.field_71943_B.field_71990_ca) {
                            checkPos.setBlock(this.field_70331_k, 0);
                            continue;
                        }
                        if (blockID == Block.field_72036_aT.field_71990_ca) {
                            checkPos.setBlock(this.field_70331_k, Block.field_71943_B.field_71990_ca);
                            continue;
                        }
                        if (blockID == Block.field_72067_ar.field_71990_ca) {
                            checkPos.setBlock(this.field_70331_k, 0);
                            continue;
                        }
                        if (blockID != Block.field_71938_D.field_71990_ca) continue;
                        checkPos.setBlock(this.field_70331_k, Block.field_71981_t.field_71990_ca);
                    }
                    this.usingTicks = 0;
                }
            }
            this.produce();
        }
    }
}

