/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.laser.gun;

import java.awt.Color;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import resonant.api.event.LaserEvent;
import resonant.lib.prefab.vector.RayTraceHelper;
import resonant.lib.type.Pair;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.prefab.items.ItemEnergyTool;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class ItemMiningLaser
extends ItemEnergyTool {
    long joulesPerTick = 100L;
    float damageToEntities = 3.3f;
    int blockRange = 50;
    int breakTime = 15;
    HashMap<EntityPlayer, Pair<Vector3, Integer>> miningMap = new HashMap();
    HashMap<EntityPlayer, Long> energyUsedMap = new HashMap();
    public static final int MODE_REMOVE = 0;
    public static final int MODE_SMELT = 1;
    public static final int MODE_DAMAGE = 2;

    public ItemMiningLaser(int id) {
        super(id);
        this.hasModes = true;
        this.energyTiers = 1;
        this.toolModes = new String[]{"laser.toolmode.remove", "laser.toolmode.smelt", "laser.toolmode.damage"};
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean currentHeldItem) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!currentHeldItem) {
                if (this.miningMap.containsKey(player)) {
                    this.miningMap.remove(player);
                }
                if (this.energyUsedMap.containsKey(player)) {
                    this.energyUsedMap.remove(player);
                }
            }
        }
    }

    public void onUsingItemTick(ItemStack stack, EntityPlayer player, int count) {
        if (count > 5 && (player.field_71075_bZ.field_75098_d || this.discharge(stack, this.joulesPerTick, false) >= this.joulesPerTick && (!this.energyUsedMap.containsKey(player) || this.energyUsedMap.get(player) <= this.getEnergy(stack)))) {
            Vec3 playerPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
            Vec3 playerLook = RayTraceHelper.getLook((Entity)player, (float)1.0f);
            Vec3 p = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a), (double)(playerPosition.field_72448_b + playerLook.field_72448_b), (double)(playerPosition.field_72449_c + playerLook.field_72449_c));
            Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * (double)this.blockRange), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * (double)this.blockRange), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * (double)this.blockRange));
            MovingObjectPosition hit = RayTraceHelper.do_rayTraceFromEntity((Entity)player, (Vec3)new Vector3().toVec3(), (double)this.blockRange, (boolean)true);
            if (!player.field_71075_bZ.field_75098_d) {
                long energyUsed = this.energyUsedMap.containsKey(player) ? this.energyUsedMap.get(player) : 0L;
                switch (this.getMode(stack)) {
                    case 0: {
                        energyUsed += this.joulesPerTick;
                    }
                    case 1: {
                        energyUsed += this.joulesPerTick / 2L;
                    }
                    case 2: {
                        energyUsed += this.joulesPerTick / 3L;
                    }
                }
                this.energyUsedMap.put(player, energyUsed);
            }
            if (hit != null) {
                LaserEvent.LaserFiredPlayerEvent event = new LaserEvent.LaserFiredPlayerEvent(player, hit, stack);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!player.field_70170_p.field_72995_K && !event.isCanceled()) {
                    if (hit.field_72313_a == EnumMovingObjectType.ENTITY && hit.field_72308_g != null) {
                        DamageSource damageSource = DamageSource.func_76358_a((EntityLivingBase)player);
                        hit.field_72308_g.func_70097_a(damageSource, this.damageToEntities);
                        hit.field_72308_g.func_70015_d(5);
                    } else if (hit.field_72313_a == EnumMovingObjectType.TILE) {
                        Block b;
                        Pair<Vector3, Integer> lastHit;
                        int time = 1;
                        boolean mined = false;
                        if (this.miningMap.containsKey(player) && (lastHit = this.miningMap.get(player)) != null && lastHit.left() != null && ((Vector3)lastHit.left()).equals((Object)new Vector3(hit)) && (b = Block.field_71973_m[player.field_70170_p.func_72798_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d)]) != null && b.func_71934_m(player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d) > -1.0f) {
                            time = (Integer)lastHit.right() + 1;
                            if (time >= this.breakTime && this.getMode(stack) == 0) {
                                LaserEvent.onBlockMinedByLaser((World)player.field_70170_p, (Object)player, (Vector3)new Vector3(hit));
                                mined = true;
                                this.miningMap.remove(player);
                            } else if (this.getMode(stack) == 1) {
                                LaserEvent.onLaserHitBlock((World)player.field_70170_p, (Object)player, (Vector3)new Vector3(hit), (ForgeDirection)ForgeDirection.UP);
                                player.field_70170_p.func_72888_f(player.field_70157_k, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, time);
                            }
                        }
                        if (!mined) {
                            this.miningMap.put(player, (Pair<Vector3, Integer>)new Pair((Object)new Vector3(hit), (Object)time));
                        }
                    }
                }
                playerViewOffset = hit.field_72307_f;
            }
            if (player.field_70170_p.field_72995_K) {
                float x = (float)((double)MathHelper.func_76134_b((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.4 - (double)MathHelper.func_76126_a((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.1);
                float z = (float)((double)MathHelper.func_76126_a((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.4 + (double)MathHelper.func_76134_b((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.1);
                ResonantInduction.proxy.renderBeam(player.field_70170_p, (IVector3)new Vector3(p).translate((IVector3)new Vector3((double)x, -0.25, (double)z)), (IVector3)new Vector3(playerViewOffset), Color.red, 5);
                ResonantInduction.proxy.renderBeam(player.field_70170_p, (IVector3)new Vector3(p).translate((IVector3)new Vector3((double)x, -0.45, (double)z)), (IVector3)new Vector3(playerViewOffset), Color.red, 5);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        return super.func_77659_a(itemStack, world, player);
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int par4) {
        if (this.miningMap.containsKey(player)) {
            Pair<Vector3, Integer> vec = this.miningMap.get(player);
            if (vec != null && vec.left() != null) {
                player.field_70170_p.func_72888_f(player.field_70157_k, ((Vector3)vec.left()).intX(), ((Vector3)vec.left()).intY(), ((Vector3)vec.left()).intZ(), -1);
            }
            this.miningMap.remove(player);
        }
        if (this.energyUsedMap.containsKey(player)) {
            this.discharge(stack, this.energyUsedMap.get(player), true);
            this.energyUsedMap.remove(player);
        }
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }
}

