/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.levitator;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.path.IPathCallBack;
import resonant.lib.path.Pathfinder;
import resonant.lib.path.PathfinderAStar;
import resonantinduction.electrical.levitator.PartLevitator;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class PathfinderLevitator
extends PathfinderAStar {
    private World world;
    private double maxSearchDistance;

    public PathfinderLevitator(final World world, final Vector3 goal) {
        super(new IPathCallBack(){

            public Set<Vector3> getConnectedNodes(Pathfinder finder, Vector3 currentNode) {
                HashSet<Vector3> neighbors = new HashSet<Vector3>();
                for (int i = 0; i < 6; ++i) {
                    Vector3 neighbor = currentNode.clone().translate(ForgeDirection.getOrientation((int)i));
                    if (!PartLevitator.canBePath(world, neighbor) && !neighbor.equals((Object)goal)) continue;
                    neighbors.add(neighbor);
                }
                return neighbors;
            }

            public boolean onSearch(Pathfinder finder, Vector3 start, Vector3 node) {
                return !(start.distance((IVector3)node) < start.distance((IVector3)goal) * 2.0);
            }
        }, goal);
        this.world = world;
    }

    public boolean findNodes(Vector3 start) {
        int blockCount = 0;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)i);
            Vector3 neighbor = this.goal.clone().translate((IVector3)new Vector3((double)direction.offsetX, (double)direction.offsetY, (double)direction.offsetZ));
            if (PartLevitator.canBePath(this.world, neighbor)) continue;
            ++blockCount;
        }
        if (blockCount >= 6) {
            return false;
        }
        return super.findNodes(start);
    }
}

