/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.multimeter;

import net.minecraft.nbt.NBTTagCompound;
import resonant.lib.type.EvictingList;

public abstract class Graph<V extends Comparable<V>> {
    public final String name;
    private final int maxPoints;
    protected final EvictingList<V> points;
    private V peak = this.getDefault();
    protected V queue = this.getDefault();

    public Graph(String name, int maxPoints) {
        this.name = name;
        this.maxPoints = maxPoints;
        this.points = new EvictingList(maxPoints);
    }

    public void add(V y) {
        this.points.add(y);
        this.peak = this.getDefault();
        for (Comparable point : this.points) {
            if (point.compareTo(this.peak) <= 0) continue;
            this.peak = y;
        }
    }

    public V getPeak() {
        return this.peak;
    }

    public V get(int x) {
        return (V)(this.points.size() > x ? (Comparable)this.points.get(x) : this.getDefault());
    }

    public V get() {
        return this.get(0);
    }

    public abstract void queue(V var1);

    public void doneQueue() {
        this.add(this.queue);
    }

    protected abstract V getDefault();

    public void load(NBTTagCompound nbt) {
        this.points.clear();
    }

    public abstract NBTTagCompound save();

    public abstract double getDouble();

    public abstract V getAverage();
}

