/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.multimeter;

import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import resonantinduction.electrical.multimeter.Graph;

public class GraphF
extends Graph<Float> {
    public GraphF(String name, int maxPoints) {
        super(name, maxPoints);
    }

    @Override
    public void queue(Float value) {
        this.queue = Float.valueOf(((Float)this.queue).floatValue() + value.floatValue());
    }

    @Override
    public void doneQueue() {
        super.doneQueue();
        this.queue = Float.valueOf(0.0f);
    }

    @Override
    public Float getDefault() {
        return Float.valueOf(0.0f);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        NBTTagList nbtList = nbt.func_74761_m("DataPoints");
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbtPoint = (NBTTagCompound)nbtList.func_74743_b(i);
            this.points.add((Object)Float.valueOf(nbtPoint.func_74760_g("data")));
        }
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList data = new NBTTagList();
        for (Float value : this.points) {
            NBTTagCompound nbtPoint = new NBTTagCompound();
            nbtPoint.func_74776_a("data", value.floatValue());
            data.func_74742_a((NBTBase)nbtPoint);
        }
        nbt.func_74782_a("DataPoints", (NBTBase)data);
        return nbt;
    }

    @Override
    public double getDouble() {
        return ((Float)this.get()).floatValue();
    }

    @Override
    public Float getAverage() {
        if (this.points.size() > 0) {
            float average = 0.0f;
            Iterator i$ = this.points.iterator();
            while (i$.hasNext()) {
                float point = ((Float)i$.next()).floatValue();
                average += point;
            }
            return Float.valueOf(average /= (float)this.points.size());
        }
        return Float.valueOf(0.0f);
    }
}

