/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.multimeter;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.electrical.multimeter.Graph;
import resonantinduction.electrical.multimeter.GraphD;
import resonantinduction.electrical.multimeter.GraphF;
import resonantinduction.electrical.multimeter.GraphI;
import resonantinduction.electrical.multimeter.GraphL;
import resonantinduction.electrical.multimeter.PartMultimeter;
import universalelectricity.api.energy.UnitDisplay;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.IUpdate;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.core.net.Network;
import universalelectricity.core.net.NetworkTickHandler;

public class MultimeterNetwork
extends Network<MultimeterNetwork, PartMultimeter>
implements IUpdate {
    public final List<String> displayInformation = new ArrayList<String>();
    private int maxData = 1;
    public final List<Graph> graphs = new ArrayList<Graph>();
    public final GraphL energyGraph = new GraphL("energy", this.maxData);
    public final GraphL powerGraph = new GraphL("power", this.maxData);
    public final GraphL energyCapacityGraph = new GraphL("capacity", 1);
    public final GraphL voltageGraph = new GraphL("voltage", this.maxData);
    public final GraphD torqueGraph = new GraphD("torque", this.maxData);
    public final GraphD angularVelocityGraph = new GraphD("speed", this.maxData);
    public final GraphI fluidGraph = new GraphI("fluid", this.maxData);
    public final GraphF thermalGraph = new GraphF("temperature", this.maxData);
    public final GraphI pressureGraph = new GraphI("pressure", this.maxData);
    public Vector3 center = new Vector3();
    public Vector3 upperBound = new Vector3();
    public Vector3 lowerBound = new Vector3();
    public Vector3 size = new Vector3();
    private long queueGraphValue = 0L;
    private long queueGraphCapacity = 0L;
    private boolean doUpdate = false;
    public boolean isEnabled = true;
    public PartMultimeter primaryMultimeter = null;

    public MultimeterNetwork() {
        super(PartMultimeter.class);
        this.graphs.add(this.energyGraph);
        this.graphs.add(this.powerGraph);
        this.graphs.add(this.energyCapacityGraph);
        this.graphs.add(this.voltageGraph);
        this.graphs.add(this.torqueGraph);
        this.graphs.add(this.angularVelocityGraph);
        this.graphs.add(this.fluidGraph);
        this.graphs.add(this.thermalGraph);
        this.graphs.add(this.pressureGraph);
    }

    public String getDisplay(int graphID) {
        Graph graph = this.graphs.get(graphID);
        String graphValue = "";
        if (graph == this.energyGraph) {
            graphValue = UnitDisplay.getDisplay((double)((Long)this.energyGraph.get()).longValue(), (UnitDisplay.Unit)UnitDisplay.Unit.JOULES);
        }
        if (graph == this.powerGraph) {
            graphValue = UnitDisplay.getDisplay((double)((Long)this.powerGraph.get()).longValue(), (UnitDisplay.Unit)UnitDisplay.Unit.WATT);
        }
        if (graph == this.energyCapacityGraph) {
            graphValue = UnitDisplay.getDisplay((double)((Long)this.energyCapacityGraph.get()).longValue(), (UnitDisplay.Unit)UnitDisplay.Unit.JOULES);
        }
        if (graph == this.voltageGraph) {
            graphValue = UnitDisplay.getDisplay((double)((Long)this.voltageGraph.get()).longValue(), (UnitDisplay.Unit)UnitDisplay.Unit.VOLTAGE);
        }
        if (graph == this.torqueGraph) {
            graphValue = UnitDisplay.getDisplayShort((double)((Double)this.torqueGraph.get()), (UnitDisplay.Unit)UnitDisplay.Unit.NEWTON_METER);
        }
        if (graph == this.angularVelocityGraph) {
            graphValue = UnitDisplay.roundDecimals((double)((Double)this.angularVelocityGraph.get())) + " rad/s";
        }
        if (graph == this.fluidGraph) {
            graphValue = UnitDisplay.getDisplay((double)((Integer)this.fluidGraph.get()).intValue(), (UnitDisplay.Unit)UnitDisplay.Unit.LITER);
        }
        if (graph == this.thermalGraph) {
            graphValue = UnitDisplay.roundDecimals((double)((Float)this.thermalGraph.get()).floatValue()) + " K";
        }
        if (graph == this.pressureGraph) {
            graphValue = UnitDisplay.roundDecimals((double)((Integer)this.pressureGraph.get()).intValue()) + " Pa";
        }
        return this.getLocalized(graph) + ": " + graphValue;
    }

    public String getLocalized(Graph graph) {
        return LanguageUtility.getLocal((String)("tooltip.graph." + graph.name));
    }

    public boolean isPrimary(PartMultimeter check) {
        return this.primaryMultimeter == check;
    }

    public void addConnector(PartMultimeter connector) {
        super.addConnector((IConnector)connector);
        NetworkTickHandler.addNetwork((IUpdate)this);
    }

    public void update() {
        for (Graph graph : this.graphs) {
            graph.doneQueue();
        }
        this.doUpdate = false;
    }

    public void markUpdate() {
        this.doUpdate = true;
    }

    public boolean canUpdate() {
        return this.doUpdate && this.continueUpdate();
    }

    public boolean continueUpdate() {
        return this.getConnectors().size() > 0;
    }

    public boolean isValidConnector(Object node) {
        return node instanceof PartMultimeter && ((PartMultimeter)((Object)node)).world() != null && ((PartMultimeter)((Object)node)).tile() != null;
    }

    public void reconstruct() {
        if (this.getConnectors().size() > 0) {
            this.primaryMultimeter = null;
            this.upperBound = null;
            this.lowerBound = null;
            super.reconstruct();
            this.center = this.upperBound.midPoint(this.lowerBound);
            this.upperBound.subtract((IVector3)this.center);
            this.lowerBound.subtract((IVector3)this.center);
            this.size = new Vector3(Math.abs(this.upperBound.x) + Math.abs(this.lowerBound.x), Math.abs(this.upperBound.y) + Math.abs(this.lowerBound.y), Math.abs(this.upperBound.z) + Math.abs(this.lowerBound.z));
            double area = (this.size.x != 0.0 ? this.size.x : 1.0) * (this.size.y != 0.0 ? this.size.y : 1.0) * (this.size.z != 0.0 ? this.size.z : 1.0);
            this.isEnabled = area == (double)this.getConnectors().size();
            NetworkTickHandler.addNetwork((IUpdate)this);
            for (PartMultimeter connector : this.getConnectors()) {
                connector.updateDesc();
                connector.updateGraph();
            }
            this.doUpdate = true;
        }
    }

    protected void reconstructConnector(PartMultimeter node) {
        node.setNetwork(this);
        if (this.primaryMultimeter == null) {
            this.primaryMultimeter = node;
        }
        if (this.upperBound == null) {
            this.upperBound = node.getPosition().translate(1.0);
        }
        if (this.lowerBound == null) {
            this.lowerBound = node.getPosition();
        }
        this.upperBound = this.upperBound.max(node.getPosition().translate(1.0));
        this.lowerBound = this.lowerBound.min(node.getPosition());
    }

    public MultimeterNetwork newInstance() {
        return new MultimeterNetwork();
    }

    public void load(NBTTagCompound nbt) {
        NBTTagList nbtList = nbt.func_74761_m("graphs");
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbtCompound = (NBTTagCompound)nbtList.func_74743_b(i);
            this.graphs.get(i).load(nbtCompound);
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList data = new NBTTagList();
        for (Graph graph : this.graphs) {
            data.func_74742_a((NBTBase)graph.save());
        }
        nbt.func_74782_a("graphs", (NBTBase)data);
        return nbt;
    }
}

