/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.tesla;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.DataInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.multiblock.IMultiBlockStructure;
import resonant.lib.multiblock.MultiBlockHandler;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.IPacketSender;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.damage.ElectricalDamage;
import resonant.lib.prefab.tile.TileElectrical;
import resonant.lib.render.EnumColor;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.Settings;
import resonantinduction.electrical.Electrical;
import resonantinduction.electrical.tesla.ITesla;
import resonantinduction.electrical.tesla.TeslaGrid;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class TileTesla
extends TileElectrical
implements IMultiBlockStructure<TileTesla>,
ITesla,
IPacketSender,
IPacketReceiver {
    public static final int DEFAULT_COLOR = 12;
    public final long TRANSFER_CAP = 10000L;
    private int dyeID = 12;
    private boolean canReceive = true;
    private boolean attackEntities = true;
    private boolean doTransfer = true;
    private final Set<TileTesla> outputBlacklist = new HashSet<TileTesla>();
    private final Set<TileTesla> connectedTeslas = new HashSet<TileTesla>();
    public Vector3 linked;
    public int linkDim;
    private int zapCounter = 0;
    private boolean isLinkedClient;
    private boolean isTransfering;
    private TileTesla topCache;
    private MultiBlockHandler<TileTesla> multiBlock;

    public TileTesla() {
        this.energy = new EnergyStorageHandler(10000L);
        this.saveIOMap = true;
    }

    public void initiate() {
        super.initiate();
        TeslaGrid.instance().register(this);
    }

    public void func_70316_g() {
        block8: {
            block9: {
                block12: {
                    Vector3 topTeslaVector;
                    TileTesla topTesla;
                    block10: {
                        block11: {
                            TileEntity transferTile;
                            boolean doPacketUpdate;
                            super.func_70316_g();
                            boolean bl = doPacketUpdate = this.energy.getEnergy() > 0L;
                            if (!this.getMultiBlock().isPrimary()) break block8;
                            this.produce();
                            if (this.ticks % (long)(4 + this.field_70331_k.field_73012_v.nextInt(2)) != 0L || (!this.field_70331_k.field_72995_K || !this.isTransfering) && (this.energy.isEmpty() || this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n))) break block9;
                            topTesla = this.getTopTelsa();
                            topTeslaVector = new Vector3((TileEntity)topTesla);
                            if (this.linked == null && !this.isLinkedClient) break block10;
                            if (this.field_70331_k.field_72995_K) break block11;
                            WorldServer dimWorld = MinecraftServer.func_71276_C().func_71218_a(this.linkDim);
                            if (dimWorld == null || !((transferTile = this.linked.getTileEntity((IBlockAccess)dimWorld)) instanceof TileTesla) || transferTile.func_70320_p()) break block12;
                            this.transfer((TileTesla)transferTile, Math.min(this.energy.getEnergy(), 10000L));
                            if (this.zapCounter % 5 != 0 || !Settings.SOUND_FXS) break block12;
                            this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "resonantinduction:electricshock", (float)this.energy.getEnergy() / 10000.0f, 1.3f - 0.5f * ((float)this.dyeID / 16.0f));
                            break block12;
                        }
                        Electrical.proxy.renderElectricShock(this.field_70331_k, topTeslaVector.clone().translate(0.5), topTeslaVector.clone().translate((IVector3)new Vector3(0.5, Double.POSITIVE_INFINITY, 0.5)), false);
                        break block12;
                    }
                    PriorityQueue<ITesla> teslaToTransfer = new PriorityQueue<ITesla>(1024, new Comparator(){

                        public int compare(ITesla o1, ITesla o2) {
                            double distance2;
                            double distance1 = new Vector3((TileEntity)topTesla).distance((IVector3)new Vector3((TileEntity)o1));
                            if (distance1 < (distance2 = new Vector3((TileEntity)topTesla).distance((IVector3)new Vector3((TileEntity)o2)))) {
                                return 1;
                            }
                            if (distance1 > distance2) {
                                return -1;
                            }
                            return 0;
                        }

                        public int compare(Object obj, Object obj1) {
                            return this.compare((ITesla)obj, (ITesla)obj1);
                        }
                    });
                    for (ITesla otherTesla : TeslaGrid.instance().get()) {
                        Vector3 vector3 = new Vector3((TileEntity)otherTesla);
                        Vector3 vector32 = new Vector3((TileEntity)this);
                        if (!(vector3.distance((IVector3)vector32) < (double)this.getRange()) || otherTesla == this) continue;
                        if (otherTesla instanceof TileTesla) {
                            if (((TileTesla)otherTesla).getHeight() <= 1) continue;
                            otherTesla = (ITesla)((TileTesla)otherTesla).getMultiBlock().get();
                        }
                        if (this.connectedTeslas.contains(otherTesla) || otherTesla == this || !otherTesla.canTeslaTransfer((TileEntity)this) || !this.canTeslaTransfer((TileEntity)otherTesla)) continue;
                        teslaToTransfer.add(otherTesla);
                    }
                    if (teslaToTransfer.size() > 0) {
                        long transferEnergy = this.energy.getEnergy() / (long)teslaToTransfer.size();
                        boolean sentPacket = false;
                        for (int count = 0; count < 10; ++count) {
                            MovingObjectPosition mop;
                            if (teslaToTransfer.isEmpty()) continue;
                            ITesla tesla = (ITesla)teslaToTransfer.poll();
                            if (this.zapCounter % 5 == 0 && Settings.SOUND_FXS) {
                                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "resonantinduction:electricshock", (float)this.energy.getEnergy() / 10000.0f, 1.3f - 0.5f * ((float)this.dyeID / 16.0f));
                            }
                            Vector3 targetVector = new Vector3((TileEntity)tesla);
                            int heightRange = 1;
                            if (tesla instanceof TileTesla) {
                                ((TileTesla)this.getMultiBlock().get()).outputBlacklist.add(this);
                                targetVector = new Vector3((TileEntity)((TileTesla)tesla).getTopTelsa());
                                heightRange = ((TileTesla)tesla).getHeight();
                            }
                            double distance = topTeslaVector.distance((IVector3)targetVector);
                            Electrical.proxy.renderElectricShock(this.field_70331_k, new Vector3((TileEntity)topTesla).translate((IVector3)new Vector3(0.5)), targetVector.translate((IVector3)new Vector3(0.5, Math.random() * (double)heightRange / 3.0 - (double)(heightRange / 3), 0.5)), EnumColor.DYES[this.dyeID].toColor());
                            this.transfer(tesla, Math.min(transferEnergy, 10000L));
                            if (!sentPacket && transferEnergy > 0L) {
                                this.sendPacket(3);
                            }
                            if (!this.attackEntities || this.zapCounter % 5 != 0 || (mop = topTeslaVector.clone().translate(0.5).rayTraceEntities(this.field_70331_k, targetVector.clone().translate(0.5))) == null || mop.field_72308_g == null || !(mop.field_72308_g instanceof EntityLivingBase)) continue;
                            ElectricalDamage.electrocuteEntity((Entity)mop.field_72308_g, (Object)this, (long)(UniversalElectricity.DEFAULT_VOLTAGE * 4L), (float)1.0f);
                            Electrical.proxy.renderElectricShock(this.field_70331_k, new Vector3((TileEntity)topTesla).clone().translate(0.5), new Vector3(mop.field_72308_g));
                        }
                    }
                }
                ++this.zapCounter;
                this.outputBlacklist.clear();
                this.doTransfer = false;
            }
            if (!this.field_70331_k.field_72995_K && this.energy.didEnergyStateChange()) {
                this.sendPacket(2);
            }
        }
        this.topCache = null;
    }

    private void transfer(ITesla tesla, long transferEnergy) {
        if (transferEnergy > 0L) {
            tesla.teslaTransfer(transferEnergy, true);
            this.teslaTransfer(-transferEnergy, true);
        }
    }

    @Override
    public boolean canTeslaTransfer(TileEntity tileEntity) {
        if (tileEntity instanceof TileTesla) {
            TileTesla otherTesla = (TileTesla)tileEntity;
            if (otherTesla.dyeID != this.dyeID && otherTesla.dyeID != 12 && this.dyeID != 12) {
                return false;
            }
        }
        return this.canReceive && tileEntity != this.getMultiBlock().get() && !this.outputBlacklist.contains(tileEntity);
    }

    public boolean canConnect(ForgeDirection direction, Object obj) {
        return super.canConnect(direction, obj) && this.getMultiBlock().isPrimary() && !(obj instanceof TileTesla);
    }

    public void sendPacket(int type) {
        PacketDispatcher.sendPacketToAllInDimension((Packet)ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, this.getPacketData(type).toArray()), (int)this.field_70331_k.field_73011_w.field_76574_g);
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, this.getPacketData(1).toArray());
    }

    public ArrayList getPacketData(int type) {
        ArrayList<Serializable> data = new ArrayList<Serializable>();
        data.add(Byte.valueOf((byte)type));
        switch (type) {
            case 1: {
                data.add(Integer.valueOf(this.dyeID));
                data.add(Boolean.valueOf(this.canReceive));
                data.add(Boolean.valueOf(this.attackEntities));
                data.add(Boolean.valueOf(this.linked != null));
                NBTTagCompound nbt = new NBTTagCompound();
                this.getMultiBlock().save(nbt);
                data.add((Serializable)nbt);
                break;
            }
            case 2: {
                data.add(Boolean.valueOf(this.energy.getEnergy() > 0L));
            }
        }
        return data;
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            switch (data.readByte()) {
                case 1: {
                    this.dyeID = data.readInt();
                    this.canReceive = data.readBoolean();
                    this.attackEntities = data.readBoolean();
                    this.isLinkedClient = data.readBoolean();
                    this.getMultiBlock().load(PacketHandler.readNBTTagCompound((DataInput)data));
                    break;
                }
                case 2: {
                    this.isTransfering = data.readBoolean();
                    break;
                }
                case 3: {
                    this.doTransfer = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long teslaTransfer(long transferEnergy, boolean doTransfer) {
        if (this.getMultiBlock().isPrimary()) {
            if (doTransfer) {
                this.energy.receiveEnergy(transferEnergy, true);
                if (this.energy.didEnergyStateChange()) {
                    this.sendPacket(2);
                }
            }
            return transferEnergy;
        }
        if (this.energy.getEnergy() > 0L) {
            transferEnergy += this.energy.getEnergy();
            this.energy.setEnergy(0L);
        }
        return ((TileTesla)this.getMultiBlock().get()).teslaTransfer(transferEnergy, doTransfer);
    }

    public int getRange() {
        return Math.min(4 * (this.getHeight() - 1), 50);
    }

    public void updatePositionStatus() {
        TileTesla mainTile = this.getLowestTesla();
        mainTile.getMultiBlock().deconstruct();
        mainTile.getMultiBlock().construct();
        boolean isTop = new Vector3((TileEntity)this).translate((IVector3)new Vector3(0.0, 1.0, 0.0)).getTileEntity((IBlockAccess)this.field_70331_k) instanceof TileTesla;
        boolean isBottom = new Vector3((TileEntity)this).translate((IVector3)new Vector3(0.0, -1.0, 0.0)).getTileEntity((IBlockAccess)this.field_70331_k) instanceof TileTesla;
        if (isTop && isBottom) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, 3);
        } else if (isBottom) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, 3);
        } else {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 3);
        }
    }

    public TileTesla getTopTelsa() {
        TileEntity t;
        if (this.topCache != null) {
            return this.topCache;
        }
        this.connectedTeslas.clear();
        Vector3 checkPosition = new Vector3((TileEntity)this);
        TileTesla returnTile = this;
        while ((t = checkPosition.getTileEntity((IBlockAccess)this.field_70331_k)) instanceof TileTesla) {
            this.connectedTeslas.add((TileTesla)t);
            returnTile = (TileTesla)t;
            checkPosition.y += 1.0;
        }
        this.topCache = returnTile;
        return returnTile;
    }

    public int getHeight() {
        TileEntity t;
        this.connectedTeslas.clear();
        int y = 0;
        while ((t = new Vector3((TileEntity)this).translate((IVector3)new Vector3(0.0, (double)y, 0.0)).getTileEntity((IBlockAccess)this.field_70331_k)) instanceof TileTesla) {
            this.connectedTeslas.add((TileTesla)t);
            ++y;
        }
        return y;
    }

    public void func_70313_j() {
        TeslaGrid.instance().unregister(this);
        super.func_70313_j();
    }

    public void setDye(int id) {
        this.dyeID = id;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean toggleReceive() {
        this.canReceive = !this.canReceive;
        return this.canReceive;
    }

    public boolean toggleEntityAttack() {
        this.attackEntities = !this.attackEntities;
        boolean returnBool = this.attackEntities;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return returnBool;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.dyeID = nbt.func_74762_e("dyeID");
        this.canReceive = nbt.func_74767_n("canReceive");
        this.attackEntities = nbt.func_74767_n("attackEntities");
        if (nbt.func_74764_b("link_x") && nbt.func_74764_b("link_y") && nbt.func_74764_b("link_z")) {
            this.linked = new Vector3((double)nbt.func_74762_e("link_x"), (double)nbt.func_74762_e("link_y"), (double)nbt.func_74762_e("link_z"));
            this.linkDim = nbt.func_74762_e("linkDim");
        }
        this.getMultiBlock().load(nbt);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("dyeID", this.dyeID);
        nbt.func_74757_a("canReceive", this.canReceive);
        nbt.func_74757_a("attackEntities", this.attackEntities);
        if (this.linked != null) {
            nbt.func_74768_a("link_x", (int)this.linked.x);
            nbt.func_74768_a("link_y", (int)this.linked.y);
            nbt.func_74768_a("link_z", (int)this.linked.z);
            nbt.func_74768_a("linkDim", this.linkDim);
        }
        this.getMultiBlock().save(nbt);
    }

    public void setLink(Vector3 vector3, int dimID, boolean setOpponent) {
        if (!this.field_70331_k.field_72995_K) {
            TileEntity tileEntity;
            TileEntity tileEntity2;
            WorldServer otherWorld = MinecraftServer.func_71276_C().func_71218_a(this.linkDim);
            if (setOpponent && this.linked != null && otherWorld != null && (tileEntity2 = this.linked.getTileEntity((IBlockAccess)otherWorld)) instanceof TileTesla) {
                ((TileTesla)tileEntity2).setLink(null, this.linkDim, false);
            }
            this.linked = vector3;
            this.linkDim = dimID;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            WorldServer newOtherWorld = MinecraftServer.func_71276_C().func_71218_a(this.linkDim);
            if (setOpponent && newOtherWorld != null && this.linked != null && (tileEntity = this.linked.getTileEntity((IBlockAccess)newOtherWorld)) instanceof TileTesla) {
                ((TileTesla)tileEntity).setLink(new Vector3((TileEntity)this), this.field_70331_k.field_73011_w.field_76574_g, false);
            }
        }
    }

    public boolean tryLink(VectorWorld vector) {
        if (vector != null) {
            if (vector.getTileEntity() instanceof TileTesla) {
                this.setLink((Vector3)vector, vector.world.field_73011_w.field_76574_g, true);
            }
            return true;
        }
        return false;
    }

    public void onMultiBlockChanged() {
    }

    public Vector3[] getMultiBlockVectors() {
        TileEntity t;
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        Vector3 checkPosition = new Vector3((TileEntity)this);
        while ((t = checkPosition.getTileEntity((IBlockAccess)this.field_70331_k)) instanceof TileTesla) {
            vectors.add(checkPosition.clone().subtract((IVector3)this.getPosition()));
            checkPosition.y += 1.0;
        }
        return vectors.toArray(new Vector3[0]);
    }

    public TileTesla getLowestTesla() {
        TileEntity t;
        TileTesla lowest = this;
        Vector3 checkPosition = new Vector3((TileEntity)this);
        while ((t = checkPosition.getTileEntity((IBlockAccess)this.field_70331_k)) instanceof TileTesla) {
            lowest = (TileTesla)t;
            checkPosition.y -= 1.0;
        }
        return lowest;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public Vector3 getPosition() {
        return new Vector3((TileEntity)this);
    }

    public MultiBlockHandler<TileTesla> getMultiBlock() {
        if (this.multiBlock == null) {
            this.multiBlock = new MultiBlockHandler((IMultiBlockStructure)this);
        }
        return this.multiBlock;
    }

    public void setIO(ForgeDirection dir, int type) {
        if (this.getMultiBlock().isPrimary()) {
            super.setIO(dir, type);
        } else {
            ((TileTesla)this.getMultiBlock().get()).setIO(dir, type);
        }
    }

    public int getIO(ForgeDirection dir) {
        if (this.getMultiBlock().isPrimary()) {
            return super.getIO(dir);
        }
        return ((TileTesla)this.getMultiBlock().get()).getIO(dir);
    }

    public EnumSet<ForgeDirection> getOutputDirections() {
        EnumSet dirs = super.getOutputDirections();
        dirs.remove(ForgeDirection.UP);
        return dirs;
    }
}

