/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.transformer;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.RenderUtility;
import resonantinduction.electrical.transformer.PartTransformer;

@SideOnly(value=Side.CLIENT)
public class RenderTransformer
implements ISimpleItemRenderer {
    public static final RenderTransformer INSTANCE = new RenderTransformer();
    public static final WavefrontObject MODEL = (WavefrontObject)AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/transformer.obj");
    public static final ResourceLocation TEXTURE_COIL = new ResourceLocation("resonantinduction", "models/transformer_winding.png");
    public static final ResourceLocation TEXTURE_STONE = new ResourceLocation("textures/blocks/stone.png");
    public static final ResourceLocation TEXTURE_IRON = new ResourceLocation("textures/blocks/iron_block.png");

    public void renderInventoryItem(ItemStack itemStack) {
        GL11.glTranslated((double)0.0, (double)-0.2f, (double)0.0);
        this.doRender();
    }

    public void doRender() {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_COIL);
        MODEL.renderAllExcept(new String[]{"core", "base"});
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_IRON);
        MODEL.renderOnly(new String[]{"core"});
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_STONE);
        MODEL.renderOnly(new String[]{"base"});
    }

    public void render(PartTransformer part, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        RenderUtility.rotateFaceBlockToSide((ForgeDirection)part.placementSide);
        RenderUtility.rotateBlockBasedOnDirection((ForgeDirection)part.getFacing());
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_COIL);
        switch (part.multiplier) {
            case 0: {
                MODEL.renderOnly(new String[]{"InsulatorLayerLow", "OuterWindingLowBox", "InnerWindingLowBox"});
                break;
            }
            case 1: {
                MODEL.renderOnly(new String[]{"InsulatorLayerMed", "OuterWindingMedBox", "InnerWindingMedBox"});
                break;
            }
            case 2: {
                MODEL.renderOnly(new String[]{"InnerWindingHighBox", "InsulatorLayerHigh", "OuterWindingHighBox"});
            }
        }
        MODEL.renderOnly(new String[]{"OuterWindingConnector", "InnerWindingConnector"});
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_IRON);
        MODEL.renderOnly(new String[]{"core"});
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_STONE);
        MODEL.renderOnly(new String[]{"base"});
        GL11.glPopMatrix();
    }
}

