/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.ControlKeyModifer;
import codechicken.multipart.JItemMultiPart;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.input.Keyboard;
import resonant.lib.render.EnumColor;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.core.MultipartUtility;
import resonantinduction.core.TabRI;
import resonantinduction.electrical.wire.EnumWireMaterial;
import resonantinduction.electrical.wire.flat.PartFlatWire;
import resonantinduction.electrical.wire.flat.RenderFlatWire;
import resonantinduction.electrical.wire.framed.PartFramedWire;
import resonantinduction.electrical.wire.framed.RenderFramedWire;
import universalelectricity.api.energy.UnitDisplay;

public class ItemWire
extends JItemMultiPart {
    public ItemWire(int id) {
        super(id);
        this.func_77655_b("resonantinduction:wire");
        this.func_111206_d("resonantinduction:wire");
        this.func_77637_a((CreativeTabs)TabRI.DEFAULT);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public TMultiPart newPart(ItemStack itemStack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 hit) {
        BlockCoord onPos = pos.copy().offset(side ^ 1);
        if (player.func_70093_af() && !ControlKeyModifer.isControlDown((EntityPlayer)player)) {
            PartFramedWire wire = (PartFramedWire)MultiPartRegistry.createPart((String)"resonant_induction_wire", (boolean)false);
            if (wire != null) {
                wire.preparePlacement(itemStack.func_77960_j());
            }
            return wire;
        }
        if (!MultipartUtility.canPlaceWireOnSide((World)world, (int)onPos.x, (int)onPos.y, (int)onPos.z, (ForgeDirection)ForgeDirection.getOrientation((int)side), (boolean)false)) {
            return null;
        }
        PartFlatWire wire = (PartFlatWire)MultiPartRegistry.createPart((String)"resonant_induction_flat_wire", (boolean)false);
        if (wire != null) {
            wire.preparePlacement(side, itemStack.func_77960_j());
        }
        return wire;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + "." + EnumWireMaterial.values()[itemStack.func_77960_j()].getName().toLowerCase();
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42)) {
            list.add(LanguageUtility.getLocal((String)"tooltip.noShift").replace("%0", EnumColor.AQUA.toString()).replace("%1", EnumColor.GREY.toString()));
        } else {
            list.add(EnumColor.AQUA + LanguageUtility.getLocal((String)"tooltip.wire.resistance").replace("%v", "" + EnumColor.ORANGE + UnitDisplay.getDisplay((double)EnumWireMaterial.values()[itemstack.func_77960_j()].resistance, (UnitDisplay.Unit)UnitDisplay.Unit.RESISTANCE)));
            list.add(EnumColor.AQUA + LanguageUtility.getLocal((String)"tooltip.wire.current").replace("%v", "" + EnumColor.ORANGE + UnitDisplay.getDisplay((double)EnumWireMaterial.values()[itemstack.func_77960_j()].maxAmps, (UnitDisplay.Unit)UnitDisplay.Unit.AMPERE)));
            list.add(EnumColor.AQUA + LanguageUtility.getLocal((String)"tooltip.wire.damage").replace("%v", "" + EnumColor.ORANGE + EnumWireMaterial.values()[itemstack.func_77960_j()].damage));
            list.addAll(LanguageUtility.splitStringPerWord((String)LanguageUtility.getLocal((String)"tooltip.wire.helpText"), (int)5));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        RenderFlatWire.flatWireTexture = register.func_94245_a("resonantinduction:models/flatWire");
        RenderFramedWire.wireIcon = register.func_94245_a("resonantinduction:models/wire");
        RenderFramedWire.insulationIcon = register.func_94245_a("resonantinduction:models/insulation");
        super.func_94581_a(register);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int par2) {
        return new Color(EnumWireMaterial.values()[itemStack.func_77960_j()].color.rgb()).darker().getRGB();
    }

    public void func_77633_a(int itemID, CreativeTabs tab, List listToAddTo) {
        for (EnumWireMaterial mat : EnumWireMaterial.values()) {
            listToAddTo.add(new ItemStack(itemID, 1, mat.ordinal()));
        }
    }
}

