/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.TMultiPart;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.prefab.damage.ElectricalDamage;
import resonantinduction.core.MultipartUtility;
import resonantinduction.electrical.wire.EnumWireMaterial;
import resonantinduction.electrical.wire.PartConductor;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.electricity.IElectricalNetwork;
import universalelectricity.api.energy.IConductor;

@Deprecated
public abstract class PartAdvancedWire
extends PartConductor {
    public static final int DEFAULT_COLOR = 15;
    public int color = 15;
    public EnumWireMaterial material = EnumWireMaterial.COPPER;
    public boolean isInsulated = false;
    protected ItemStack insulationType = new ItemStack(Block.field_72101_ab);

    @Override
    public boolean canConnectTo(Object obj) {
        if (obj != null && (obj.getClass().isAssignableFrom(((Object)((Object)this)).getClass()) || ((Object)((Object)this)).getClass().isAssignableFrom(obj.getClass()))) {
            PartAdvancedWire wire = (PartAdvancedWire)((Object)obj);
            if (this.getMaterial() == wire.getMaterial()) {
                if (this.isInsulated() && wire.isInsulated()) {
                    return this.getColor() == wire.getColor() || this.getColor() == 15 || wire.getColor() == 15;
                }
                return true;
            }
        } else if (!(obj instanceof IConductor)) {
            return CompatibilityModule.isHandler((Object)obj);
        }
        return false;
    }

    protected boolean canConnectTo(Object obj, ForgeDirection dir) {
        if (obj != null && (obj.getClass().isAssignableFrom(((Object)((Object)this)).getClass()) || ((Object)((Object)this)).getClass().isAssignableFrom(obj.getClass()))) {
            PartAdvancedWire wire = (PartAdvancedWire)((Object)obj);
            if (this.getMaterial() == wire.getMaterial()) {
                if (this.isInsulated() && wire.isInsulated()) {
                    return this.getColor() == wire.getColor() || this.getColor() == 15 || wire.getColor() == 15;
                }
                return true;
            }
        } else if (!(obj instanceof IConductor)) {
            return CompatibilityModule.canConnect((Object)obj, (ForgeDirection)dir.getOpposite(), (Object)((Object)this));
        }
        return false;
    }

    public void onEntityCollision(Entity entity) {
        if (!this.isInsulated() && this.getNetwork() instanceof IElectricalNetwork) {
            ElectricalDamage.handleElectrocution((Entity)entity, (Object)((Object)this), (IElectricalNetwork)((IElectricalNetwork)this.getNetwork()));
        }
    }

    public float getResistance() {
        return this.getMaterial().resistance;
    }

    public long getCurrentCapacity() {
        return this.getMaterial().maxAmps;
    }

    public EnumWireMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(EnumWireMaterial material) {
        this.material = material;
    }

    public void setMaterial(int id) {
        this.setMaterial(EnumWireMaterial.values()[id]);
    }

    public int getMaterialID() {
        return this.material.ordinal();
    }

    public void setInsulated(boolean insulated) {
        this.isInsulated = insulated;
        this.color = 15;
        if (!this.world().field_72995_K) {
            this.tile().notifyPartChange((TMultiPart)this);
            this.sendInsulationUpdate();
        }
    }

    public void setInsulated(int dyeColour) {
        this.isInsulated = true;
        this.color = dyeColour;
        if (!this.world().field_72995_K) {
            this.tile().notifyPartChange((TMultiPart)this);
            this.sendInsulationUpdate();
            this.sendColorUpdate();
        }
    }

    public boolean isInsulated() {
        return this.isInsulated;
    }

    public void sendInsulationUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(1).writeBoolean(this.isInsulated);
    }

    public int getColor() {
        return this.isInsulated ? this.color : -1;
    }

    public void setColor(int dye) {
        if (this.isInsulated) {
            this.color = dye;
            if (!this.world().field_72995_K) {
                this.tile().notifyPartChange((TMultiPart)this);
                this.sendColorUpdate();
            }
        }
    }

    public void sendColorUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(2).writeInt(this.color);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack itemStack) {
        if (itemStack != null) {
            int dyeColor = MultipartUtility.isDye((ItemStack)itemStack);
            if (dyeColor != -1 && this.isInsulated()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
                this.setColor(dyeColor);
                return true;
            }
            if (itemStack.field_77993_c == this.insulationType.field_77993_c) {
                if (this.isInsulated()) {
                    if (!this.world().field_72995_K && player.field_71075_bZ.field_75098_d) {
                        this.tile().dropItems(Collections.singletonList(this.insulationType));
                    }
                    this.setInsulated(false);
                    return true;
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
                this.setInsulated(BlockColored.func_72239_d((int)itemStack.func_77960_j()));
                return true;
            }
            if (itemStack.func_77973_b() instanceof ItemShears && this.isInsulated()) {
                if (!this.world().field_72995_K && !player.field_71075_bZ.field_75098_d) {
                    this.tile().dropItems(Collections.singletonList(this.insulationType));
                }
                this.setInsulated(false);
                return true;
            }
        }
        return false;
    }

    protected ItemStack getItem() {
        return EnumWireMaterial.values()[this.getMaterialID()].getWire();
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItem());
        if (this.isInsulated) {
            drops.add(this.insulationType.func_77946_l());
        }
        return drops;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public void readDesc(MCDataInput packet) {
        this.setMaterial(packet.readByte());
        this.color = packet.readByte();
        this.isInsulated = packet.readBoolean();
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)((byte)this.getMaterialID()));
        packet.writeByte((int)((byte)this.color));
        packet.writeBoolean(this.isInsulated);
    }

    public void read(MCDataInput packet, int packetID) {
        switch (packetID) {
            case 1: {
                this.isInsulated = packet.readBoolean();
                this.tile().markRender();
                break;
            }
            case 2: {
                this.color = packet.readInt();
                this.tile().markRender();
            }
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("typeID", this.getMaterialID());
        nbt.func_74757_a("isInsulated", this.isInsulated);
        nbt.func_74768_a("dyeID", this.color);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.setMaterial(nbt.func_74762_e("typeID"));
        this.isInsulated = nbt.func_74767_n("isInsulated");
        this.color = nbt.func_74762_e("dyeID");
    }

    protected boolean checkRedstone(int side) {
        if (this.world().func_72864_z(this.x(), this.y(), this.z())) {
            return true;
        }
        for (TMultiPart tp : this.tile().jPartList()) {
            IRedstonePart rp;
            if (!(tp instanceof IRedstonePart) || Math.max((rp = (IRedstonePart)tp).strongPowerLevel(side), rp.weakPowerLevel(side)) << 4 <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[PartAdvancedWire]" + this.x() + "x " + this.y() + "y " + this.z() + "z ";
    }
}

