/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire.flat;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonantinduction.core.MultipartUtility;
import resonantinduction.electrical.wire.EnumWireMaterial;
import resonantinduction.electrical.wire.PartAdvancedWire;
import resonantinduction.electrical.wire.flat.PartFlatSwitchWire;
import resonantinduction.electrical.wire.flat.RenderFlatWire;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.INetwork;

public class PartFlatWire
extends PartAdvancedWire
implements TFacePart,
JNormalOcclusion {
    public static Cuboid6[][] selectionBounds = new Cuboid6[3][6];
    public static Cuboid6[][] occlusionBounds = new Cuboid6[3][6];
    public byte side;
    public int connMap;

    public PartFlatWire() {
    }

    public PartFlatWire(int typeID) {
        this(EnumWireMaterial.values()[typeID]);
    }

    public PartFlatWire(EnumWireMaterial type) {
        this.material = type;
    }

    public void preparePlacement(int side, int meta) {
        this.side = (byte)(side ^ 1);
        this.setMaterial(meta);
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.side = tag.func_74771_c("side");
        this.connMap = tag.func_74762_e("connMap");
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74774_a("side", this.side);
        tag.func_74768_a("connMap", this.connMap);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.side = packet.readByte();
        this.connMap = packet.readInt();
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.side);
        packet.writeInt(this.connMap);
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    @Override
    public void read(MCDataInput packet, int packetID) {
        if (packetID == 0) {
            this.connMap = packet.readInt();
            this.tile().markRender();
        } else {
            super.read(packet, packetID);
        }
    }

    public void sendConnUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeInt(this.connMap);
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().field_72995_K) {
            for (int r = 0; r < 4; ++r) {
                if (!this.maskConnects(r)) continue;
                if ((this.connMap & 1 << r) != 0) {
                    this.notifyCornerChange(r);
                    continue;
                }
                if ((this.connMap & 16 << r) == 0) continue;
                this.notifyStraightChange(r);
            }
        }
    }

    public void onChunkLoad() {
        if ((this.connMap & Integer.MIN_VALUE) != 0) {
            if (this.dropIfCantStay()) {
                return;
            }
            this.connMap = 0;
            this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                this.updateExternalConnections();
            }
            this.tile().markDirty();
        }
        this.recalculateConnections();
        super.onChunkLoad();
    }

    public void onAdded() {
        super.onAdded();
        if (!this.world().field_72995_K) {
            this.updateOpenConnections();
            boolean changed = this.updateInternalConnections();
            if (changed |= this.updateExternalConnections()) {
                this.sendConnUpdate();
            }
            this.recalculateConnections();
        }
    }

    public void onPartChanged(TMultiPart part) {
        if (!this.world().field_72995_K) {
            boolean changed = this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                changed |= this.updateExternalConnections();
            }
            if (changed) {
                this.sendConnUpdate();
            }
            this.recalculateConnections();
        }
        super.onPartChanged(part);
    }

    public void onNeighborChanged() {
        if (!this.world().field_72995_K) {
            if (this.dropIfCantStay()) {
                return;
            }
            if (this.updateExternalConnections()) {
                this.sendConnUpdate();
            }
            this.recalculateConnections();
        }
        super.onNeighborChanged();
    }

    @Override
    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (item != null && item.func_77973_b().field_77779_bT == Block.field_72043_aJ.field_71990_ca) {
            TileMultipart tile = this.tile();
            World w = this.world();
            if (!w.field_72995_K) {
                PartFlatSwitchWire wire = (PartFlatSwitchWire)MultiPartRegistry.createPart((String)"resonant_induction_flat_switch_wire", (boolean)false);
                wire.copyFrom(this);
                if (tile.canReplacePart((TMultiPart)this, (TMultiPart)wire)) {
                    tile.remPart((TMultiPart)this);
                    TileMultipart.addPart((World)w, (BlockCoord)new BlockCoord((TileEntity)tile), (TMultiPart)wire);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                }
            }
            return true;
        }
        return super.activate(player, part, item);
    }

    @Override
    public void recalculateConnections() {
        int absDir;
        int r;
        this.updateOpenConnections();
        boolean[] calculatedSides = new boolean[6];
        for (r = 0; r < 4; r = (int)((byte)(r + 1))) {
            if (!this.maskOpen(r)) continue;
            absDir = Rotation.rotateSide((int)this.side, (int)r);
            if (this.setExternalConnection(r, absDir)) {
                calculatedSides[absDir] = true;
            }
            BlockCoord cornerPos = new BlockCoord((TileEntity)this.tile());
            cornerPos.offset(absDir);
            if (this.canConnectThroughCorner(cornerPos, absDir ^ 1, this.side)) {
                TMultiPart tp;
                cornerPos.offset((int)this.side);
                TileMultipart tpCorner = MultipartUtility.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)cornerPos);
                if (tpCorner != null && this.canConnectTo(tp = tpCorner.partMap(absDir ^ 1), ForgeDirection.getOrientation((int)absDir))) {
                    this.connections[absDir] = tp;
                    if (tp instanceof PartFlatWire) {
                        this.getNetwork().merge((INetwork)((PartFlatWire)tp).getNetwork());
                    }
                    calculatedSides[absDir] = true;
                    continue;
                }
            }
            if (calculatedSides[absDir]) continue;
            this.disconnect(absDir);
        }
        for (r = 0; r < 4; r = (int)((byte)(r + 1))) {
            TMultiPart tp;
            absDir = Rotation.rotateSide((int)this.side, (int)r);
            if (this.tile().partMap(PartMap.edgeBetween((int)absDir, (int)this.side)) == null && this.canConnectTo(tp = this.tile().partMap(absDir))) {
                this.connections[absDir] = tp;
                if (!(tp instanceof PartFlatWire)) continue;
                this.getNetwork().merge((INetwork)((PartFlatWire)tp).getNetwork());
                continue;
            }
            if (calculatedSides[absDir]) continue;
            this.disconnect(absDir);
        }
        this.setExternalConnection(-1, this.side);
        this.getNetwork().reconstruct();
    }

    public boolean setExternalConnection(int r, int absSide) {
        TileEntity tileEntity;
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absSide);
        TileMultipart tileMultiPart = MultipartUtility.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (tileMultiPart != null && r != -1) {
            TMultiPart tp = tileMultiPart.partMap((int)this.side);
            if (this.canConnectTo(tp, ForgeDirection.getOrientation((int)absSide))) {
                int otherR = (r + 2) % 4;
                if (tp instanceof PartFlatWire && ((PartFlatWire)tp).canConnectTo((Object)this, ForgeDirection.getOrientation((int)absSide).getOpposite()) && ((PartFlatWire)tp).maskOpen(otherR)) {
                    this.connections[absSide] = tp;
                    this.getNetwork().merge((INetwork)((PartFlatWire)tp).getNetwork());
                    return true;
                }
                if (this.canConnectTo(tp)) {
                    this.connections[absSide] = tp;
                    return true;
                }
            }
            this.disconnect(absSide);
        }
        if (this.canConnectTo(tileEntity = this.world().func_72796_p(pos.x, pos.y, pos.z), ForgeDirection.getOrientation((int)absSide))) {
            this.connections[absSide] = tileEntity;
            return true;
        }
        this.disconnect(absSide);
        return false;
    }

    private synchronized void disconnect(int i) {
        if (!this.world().field_72995_K && this.connections[i] != null) {
            if (this.connections[i] instanceof PartFlatWire) {
                PartFlatWire wire = (PartFlatWire)((Object)this.connections[i]);
                this.connections[i] = null;
                this.getNetwork().split((IConnector)this, (IConnector)wire);
            } else {
                this.connections[i] = null;
            }
        }
    }

    @Override
    public Object[] getConnections() {
        return this.connections;
    }

    public boolean canStay() {
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset((int)this.side);
        return MultipartUtility.canPlaceWireOnSide((World)this.world(), (int)pos.x, (int)pos.y, (int)pos.z, (ForgeDirection)ForgeDirection.getOrientation((int)(this.side ^ 1)), (boolean)false);
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        TileMultipart.dropItem((ItemStack)this.getItem(), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    protected boolean updateExternalConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.maskOpen(r)) continue;
            if (this.connectStraight(r)) {
                newConn |= 16 << r;
                continue;
            }
            int cnrMode = this.connectCorner(r);
            if (cnrMode == 0) continue;
            newConn |= 1 << r;
            if (cnrMode != 2) continue;
            newConn |= 0x100000 << r;
        }
        if (newConn != (this.connMap & 0xF000FF)) {
            int diff = this.connMap ^ newConn;
            this.connMap = this.connMap & 0xFF0FFF00 | newConn;
            for (int r = 0; r < 4; ++r) {
                if ((diff & 1 << r) == 0) continue;
                this.notifyCornerChange(r);
            }
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.connectInternal(r)) continue;
            newConn |= 256 << r;
        }
        if (this.connectCenter()) {
            newConn |= 0x10000;
        }
        if (newConn != (this.connMap & 0x10F00)) {
            this.connMap = this.connMap & 0xFFFEF0FF | newConn;
            return true;
        }
        return false;
    }

    protected boolean updateOpenConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.connectionOpen(r)) continue;
            newConn |= 4096 << r;
        }
        if (newConn != (this.connMap & 0xF000)) {
            this.connMap = this.connMap & 0xFFFF0FFF | newConn;
            return true;
        }
        return false;
    }

    public boolean connectionOpen(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        TMultiPart facePart = this.tile().partMap(absDir);
        if (!(facePart == null || facePart instanceof PartFlatWire && this.canConnectTo(facePart, ForgeDirection.getOrientation((int)absDir)))) {
            return false;
        }
        return this.tile().partMap(PartMap.edgeBetween((int)this.side, (int)absDir)) == null;
    }

    public int connectCorner(int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile());
        pos.offset(absDir);
        if (!this.canConnectThroughCorner(pos, absDir ^ 1, this.side)) {
            return 0;
        }
        pos.offset((int)this.side);
        TileMultipart t = MultipartUtility.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null && this.canConnectTo(tp = t.partMap(absDir ^ 1), ForgeDirection.getOrientation((int)absDir))) {
            boolean b;
            if (tp instanceof PartFlatWire && (b = ((PartFlatWire)tp).connectCorner(this, Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side ^ 1))))) {
                if (!this.renderThisCorner((PartFlatWire)tp)) {
                    return 1;
                }
                return 2;
            }
            return 2;
        }
        return 0;
    }

    public boolean canConnectThroughCorner(BlockCoord pos, int side1, int side2) {
        if (this.world().func_72799_c(pos.x, pos.y, pos.z)) {
            return true;
        }
        TileMultipart t = MultipartUtility.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            return t.partMap(side1) == null && t.partMap(side2) == null && t.partMap(PartMap.edgeBetween((int)side1, (int)side2)) == null;
        }
        return false;
    }

    public boolean connectStraight(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        TileMultipart t = MultipartUtility.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap((int)this.side);
            if (this.canConnectTo(tp, ForgeDirection.getOrientation((int)absDir))) {
                if (tp instanceof PartFlatWire) {
                    return ((PartFlatWire)tp).connectStraight(this, (r + 2) % 4);
                }
                return true;
            }
        } else {
            TileEntity tileEntity = this.world().func_72796_p(pos.x, pos.y, pos.z);
            return this.canConnectTo(tileEntity, ForgeDirection.getOrientation((int)absDir));
        }
        return false;
    }

    public boolean connectInternal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        if (this.tile().partMap(PartMap.edgeBetween((int)absDir, (int)this.side)) != null) {
            return false;
        }
        TMultiPart tp = this.tile().partMap(absDir);
        if (this.canConnectTo(tp, ForgeDirection.getOrientation((int)absDir))) {
            return ((PartFlatWire)tp).connectInternal(this, Rotation.rotationTo((int)absDir, (int)this.side));
        }
        return this.connectInternalOverride(tp, r);
    }

    public boolean connectInternalOverride(TMultiPart p, int r) {
        return false;
    }

    public boolean connectCenter() {
        TMultiPart tp = this.tile().partMap(6);
        if (this.canConnectTo(tp)) {
            if (tp instanceof PartFlatWire) {
                return ((PartFlatWire)tp).connectInternal(this, this.side);
            }
            return true;
        }
        return false;
    }

    public boolean renderThisCorner(PartFlatWire part) {
        if (!(part instanceof PartFlatWire)) {
            return false;
        }
        PartFlatWire wire = part;
        if (wire.getThickness() == this.getThickness()) {
            return this.side < wire.side;
        }
        return wire.getThickness() > this.getThickness();
    }

    public boolean connectCorner(PartFlatWire wire, int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        if (this.canConnectTo((Object)wire, ForgeDirection.getOrientation((int)absDir)) && this.maskOpen(r)) {
            int oldConn = this.connMap;
            this.connMap |= 1 << r;
            if (this.renderThisCorner(wire)) {
                this.connMap |= 0x100000 << r;
            }
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectStraight(PartFlatWire wire, int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        if (this.canConnectTo((Object)wire, ForgeDirection.getOrientation((int)absDir)) && this.maskOpen(r)) {
            int oldConn = this.connMap;
            this.connMap |= 16 << r;
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectInternal(PartFlatWire wire, int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        if (this.canConnectTo((Object)wire, ForgeDirection.getOrientation((int)absDir))) {
            int oldConn = this.connMap;
            this.connMap |= 256 << r;
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean canConnectCorner(int r) {
        return true;
    }

    public void notifyCornerChange(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir).offset((int)this.side);
        this.world().func_72821_m(pos.x, pos.y, pos.z, this.tile().func_70311_o().field_71990_ca);
    }

    public void notifyStraightChange(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        this.world().func_72821_m(pos.x, pos.y, pos.z, this.tile().func_70311_o().field_71990_ca);
    }

    public boolean maskConnects(int r) {
        return (this.connMap & 273 << r) != 0;
    }

    public boolean maskOpen(int r) {
        return (this.connMap & 4096 << r) != 0;
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return 4.0f;
    }

    public int getSlotMask() {
        return 1 << this.side;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        return Arrays.asList(new IndexedCuboid6((Object)0, selectionBounds[this.getThickness()][this.side]));
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(occlusionBounds[this.getThickness()][this.side]);
    }

    public int getThickness() {
        return this.isInsulated ? 2 : 1;
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public boolean solid(int arg0) {
        return false;
    }

    public String getType() {
        return "resonant_induction_flat_wire";
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return RenderFlatWire.flatWireTexture;
    }

    public Colour getColour() {
        if (this.isInsulated) {
            ColourARGB color = new ColourARGB(ItemDye.field_77859_b[this.color]);
            color.a = (byte)-1;
            return color;
        }
        return this.getMaterial().color;
    }

    public boolean useStaticRenderer() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        if (pass == 0 && this.useStaticRenderer()) {
            CCRenderState.setBrightness((IBlockAccess)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            RenderFlatWire.render(this, pos);
            CCRenderState.setColour((int)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0 && !this.useStaticRenderer()) {
            GL11.glDisable((int)2896);
            TextureUtils.bindAtlas((int)0);
            CCRenderState.useModelColours((boolean)true);
            CCRenderState.startDrawing((int)7);
            RenderFlatWire.render(this, pos);
            CCRenderState.draw();
            CCRenderState.setColour((int)-1);
            GL11.glEnable((int)2896);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(RenderBlocks renderBlocks) {
        CCRenderState.reset();
        RenderFlatWire.renderBreakingOverlay(renderBlocks.field_78664_d, this);
    }

    public void copyFrom(PartFlatWire otherCable) {
        this.isInsulated = otherCable.isInsulated;
        this.color = otherCable.color;
        this.connections = otherCable.connections;
        this.material = otherCable.material;
        this.side = otherCable.side;
        this.connMap = otherCable.connMap;
        this.setNetwork(otherCable.getNetwork());
        this.getNetwork().setBufferFor((IConductor)this, otherCable.getNetwork().getBufferOf((IConductor)otherCable));
    }

    @Override
    public String toString() {
        return "[PartFlatWire]" + this.x() + "x " + this.y() + "y " + this.z() + "z " + this.getSlotMask() + "s ";
    }

    static {
        for (int t = 0; t < 3; ++t) {
            Cuboid6 selection = new Cuboid6(0.0, 0.0, 0.0, 1.0, (double)(t + 2) / 16.0, 1.0).expand(-0.005);
            Cuboid6 occlusion = new Cuboid6(0.25, 0.0, 0.25, 0.75, (double)(t + 2) / 16.0, 0.75);
            for (int s = 0; s < 6; ++s) {
                PartFlatWire.selectionBounds[t][s] = selection.copy().apply(Rotation.sideRotations[s].at(Vector3.center));
                PartFlatWire.occlusionBounds[t][s] = occlusion.copy().apply(Rotation.sideRotations[s].at(Vector3.center));
            }
        }
    }
}

