/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire.flat;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.ColourModifier;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.UV;
import codechicken.lib.render.UVScale;
import codechicken.lib.render.UVTranslation;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.util.Icon;
import resonantinduction.electrical.wire.flat.PartFlatWire;

public class RenderFlatWire {
    public static Icon flatWireTexture;
    public static int[] reorientSide;
    public static CCModel[] wireModels;
    public static CCModel[] invModels;
    private static WireModelGenerator gen_inst;

    public static int addVerts(CCModel m, Vertex5[] verts, int k) {
        for (int i = 0; i < verts.length; ++i) {
            m.verts[k + i] = verts[i];
        }
        return k + verts.length;
    }

    public static CCModel finishModel(CCModel m) {
        m.apply((IUVTransformation)new UVScale(0.03125));
        m.shrinkUVs(5.0E-4);
        m.computeNormals();
        m.computeLighting(LightModel.standardLightModel);
        return m;
    }

    public static int modelKey(int side, int thickness, int connMap) {
        int key = connMap & 0xFF;
        int renderCorner = connMap >> 20 & 0xF;
        key |= (renderCorner ^ key & 0xF) << 4;
        key &= 0xFFFFFFF0 | renderCorner;
        int internal = (connMap & 0xF00) >> 8;
        key |= internal << 4 | internal;
        return key |= side + thickness * 6 << 8;
    }

    public static int modelKey(PartFlatWire w) {
        return RenderFlatWire.modelKey(w.side, w.getThickness(), w.connMap);
    }

    public static CCModel getOrGenerateModel(int key) {
        CCModel m = wireModels[key];
        if (m == null) {
            RenderFlatWire.wireModels[key] = m = gen_inst.generateModel(key, false);
        }
        return m;
    }

    public static void render(PartFlatWire w, Vector3 pos) {
        ColourModifier m = w.getColour().pack() == -1 ? ColourModifier.instance : new ColourMultiplier(w.getColour());
        CCModel model = RenderFlatWire.getOrGenerateModel(RenderFlatWire.modelKey(w));
        model.render((Transformation)new Translation(pos), (IUVTransformation)new IconTransformation(w.getIcon()), (IVertexModifier)m);
    }

    public static void renderInv(int thickness, Transformation t, Icon icon) {
        CCModel m = invModels[thickness];
        if (m == null) {
            RenderFlatWire.invModels[thickness] = m = gen_inst.generateInvModel(thickness);
        }
        m.render(t, (IUVTransformation)new IconTransformation(icon));
    }

    public static void renderBreakingOverlay(Icon icon, PartFlatWire wire) {
        int key = RenderFlatWire.modelKey(wire);
        int side = (key >> 8) % 6;
        double w = (double)((key >> 8) / 6 + 1) / 16.0;
        double h = w + 0.0625;
        int mask = key & 0xFF;
        int connMask = (mask & 0xF0) >> 4 | mask & 0xF;
        int connCount = WireModelGenerator.countConnections(connMask);
        LinkedList<Cuboid6> boxes = new LinkedList<Cuboid6>();
        boxes.add(new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, h, 0.5 + w).apply(Rotation.sideRotations[side].at(Vector3.center)));
        for (int r = 0; r < 4; ++r) {
            int length;
            if (connCount == 0) {
                length = r % 2 == 1 ? 4 : 0;
            } else if (connCount == 1) {
                length = connMask == 1 << (r + 2) % 4 ? 4 : (connMask == 1 << r ? 8 : 0);
            } else {
                int n = length = (connMask & 1 << r) != 0 ? 8 : 0;
            }
            if (length <= 0) continue;
            double l = (double)length / 16.0;
            boxes.add(new Cuboid6(0.5 - w, 0.0, 0.5 + w, 0.5 + w, h, 0.5 + l).apply(Rotation.sideOrientation((int)side, (int)r).at(Vector3.center)));
        }
        for (Cuboid6 box : boxes) {
            RenderUtils.renderBlock((Cuboid6)box, (int)0, (Transformation)new Translation((double)wire.x(), (double)wire.y(), (double)wire.z()), (IUVTransformation)new IconTransformation(icon), null);
        }
    }

    static {
        reorientSide = new int[]{0, 3, 3, 0, 0, 3};
        wireModels = new CCModel[4608];
        invModels = new CCModel[3];
        gen_inst = new WireModelGenerator();
    }

    private static class WireModelGenerator {
        int side;
        int tw;
        int th;
        double w;
        double h;
        int mask;
        int connMask;
        int connCount;
        CCModel model;
        int i = 0;
        boolean inv;
        private static UVT sideReflect = new UVT(Rotation.quarterRotations[2].at(new Vector3(8.0, 0.0, 16.0)));

        private WireModelGenerator() {
        }

        public static int countConnections(int connMask) {
            int n = 0;
            for (int r = 0; r < 4; ++r) {
                if ((connMask & 1 << r) == 0) continue;
                ++n;
            }
            return n;
        }

        public int numFaces() {
            if (this.inv) {
                return 22;
            }
            int conns = this.connCount <= 2 ? 2 : this.connCount;
            int faces = conns * 3 + 5;
            for (int i = 0; i < 4; ++i) {
                if ((this.mask >> i & 0x11) != 1) continue;
                ++faces;
            }
            return faces;
        }

        public CCModel generateInvModel(int thickness) {
            return this.generateModel(RenderFlatWire.modelKey(0, thickness, 240), true);
        }

        public CCModel generateModel(int key, boolean inv) {
            this.inv = inv;
            this.side = (key >> 8) % 6;
            this.tw = (key >> 8) / 6 + 1;
            this.w = (double)this.tw / 16.0;
            this.th = this.tw + 1;
            this.h = (double)this.th / 16.0;
            this.mask = key & 0xFF;
            this.connMask = (this.mask & 0xF0) >> 4 | this.mask & 0xF;
            this.connCount = WireModelGenerator.countConnections(this.connMask);
            this.model = CCModel.quadModel((int)(this.numFaces() * 4));
            this.i = 0;
            this.generateCenter();
            for (int r = 0; r < 4; ++r) {
                this.generateSide(r);
            }
            this.model.apply(Rotation.sideOrientation((int)this.side, (int)0).at(Vector3.center));
            return RenderFlatWire.finishModel(this.model);
        }

        private void generateSide(int r) {
            int type = this.mask >> r & 0x11;
            Vertex5[] verts = this.inv ? this.generateSideInv(r) : (this.connCount == 0 ? (r % 2 == 1 ? this.generateStub(r) : this.generateFlat(r)) : (this.connCount == 1 ? (this.connMask == 1 << (r + 2) % 4 ? this.generateStub(r) : this.generateSideFromType(type, r)) : this.generateSideFromType(type, r)));
            Transformation t = Rotation.quarterRotations[r].at(Vector3.center);
            for (Vertex5 vert : verts) {
                vert.apply(t);
            }
            this.i = RenderFlatWire.addVerts(this.model, verts, this.i);
        }

        private Vertex5[] generateSideInv(int r) {
            return this.withBottom(this.generateStraight(r), 4, 4);
        }

        private Vertex5[] generateSideFromType(int type, int r) {
            if (type == 0) {
                return this.generateFlat(r);
            }
            if (type == 1) {
                return this.generateCorner(r);
            }
            if (type == 16) {
                return this.generateStraight(r);
            }
            return this.generateInternal(r);
        }

        private Vertex5[] generateFlat(int r) {
            Vertex5[] verts = new Vertex5[]{new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 - this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 + this.tw))};
            if (Rotation.rotateSide((int)this.side, (int)r) % 2 == 0) {
                UVT uvt = new UVT(Rotation.quarterRotations[2].at(new Vector3(8.0, 0.0, 16.0)));
                for (Vertex5 vert : verts) {
                    vert.apply((IUVTransformation)uvt);
                }
            }
            return verts;
        }

        private Vertex5[] generateStub(int r) {
            Vertex5[] verts = this.generateExtension(4);
            for (int i = 0; i < 4; ++i) {
                verts[i].vec.z -= 0.002;
            }
            this.reflectSide(verts, r);
            return verts;
        }

        private Vertex5[] generateStraight(int r) {
            Vertex5[] verts = this.generateExtension(8);
            this.reflectSide(verts, r);
            return verts;
        }

        private Vertex5[] generateCorner(int r) {
            Vertex5[] verts = this.generateExtension(8 + this.th);
            for (int i = 0; i < 4; ++i) {
                verts[i].apply((IUVTransformation)new UVTranslation(0.0, (double)(-this.th)));
            }
            verts = Arrays.copyOf(verts, 20);
            verts[16] = new Vertex5(0.5 - this.w, 0.0, 1.0, (double)(8 - this.tw), (double)(24 + 2 * this.th));
            verts[17] = new Vertex5(0.5 + this.w, 0.0, 1.0, (double)(8 + this.tw), (double)(24 + 2 * this.th));
            verts[18] = new Vertex5(0.5 + this.w, 0.0, 1.0 + this.h, (double)(8 + this.tw), (double)(24 + this.th));
            verts[19] = new Vertex5(0.5 - this.w, 0.0, 1.0 + this.h, (double)(8 - this.tw), (double)(24 + this.th));
            this.reflectSide(verts, r);
            return verts;
        }

        private Vertex5[] generateInternal(int r) {
            Vertex5[] verts = this.generateExtension(8);
            verts[0].uv.set((double)(8 + this.tw), 24.0);
            verts[1].uv.set((double)(8 - this.tw), 24.0);
            verts[2].uv.set((double)(8 - this.tw), (double)(24 + this.tw));
            verts[3].uv.set((double)(8 + this.tw), (double)(24 + this.tw));
            this.reflectSide(verts, r);
            for (int i = 4; i < 16; ++i) {
                verts[i].apply((IUVTransformation)new UVTranslation(16.0, 0.0));
            }
            return verts;
        }

        private Vertex5[] generateExtension(int tl) {
            double l = (double)tl / 16.0;
            return new Vertex5[]{new Vertex5(0.5 - this.w, 0.0, 0.5 + l, (double)(8 - this.tw), (double)(24 + 2 * this.th)), new Vertex5(0.5 + this.w, 0.0, 0.5 + l, (double)(8 + this.tw), (double)(24 + 2 * this.th)), new Vertex5(0.5 + this.w, this.h, 0.5 + l, (double)(8 + this.tw), (double)(24 + this.th)), new Vertex5(0.5 - this.w, this.h, 0.5 + l, (double)(8 - this.tw), (double)(24 + this.th)), new Vertex5(0.5 - this.w, this.h, 0.5 + l, (double)(8 - this.tw), (double)(16 + tl)), new Vertex5(0.5 + this.w, this.h, 0.5 + l, (double)(8 + this.tw), (double)(16 + tl)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 0.0, (double)(16 + this.tw)), new Vertex5(0.5 - this.w, 0.0, 0.5 + l, 0.0, (double)(16 + tl)), new Vertex5(0.5 - this.w, this.h, 0.5 + l, (double)this.th, (double)(16 + tl)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)this.th, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, 0.0, 0.5 + l, 16.0, (double)(16 + tl)), new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + l, (double)(16 - this.th), (double)(16 + tl))};
        }

        private void generateCenter() {
            Object uvt;
            int tex = this.connCount == 0 ? 1 : (this.connCount == 1 ? ((this.connMask & 5) != 0 ? 0 : 1) : (this.connMask == 5 ? 0 : (this.connMask == 10 ? 1 : 2)));
            Vertex5[] verts = new Vertex5[]{new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 - this.w, (double)(8 + this.tw), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 - this.w, (double)(8 - this.tw), (double)(16 - this.tw))};
            if (tex == 0 || tex == 1) {
                tex = (tex + reorientSide[this.side]) % 2;
            }
            int r = reorientSide[this.side];
            if (tex == 1) {
                r += 3;
            }
            if (r != 0) {
                uvt = new UVT(Rotation.quarterRotations[r % 4].at(new Vector3(8.0, 0.0, 16.0)));
                for (Vertex5 vert : verts) {
                    vert.apply((IUVTransformation)uvt);
                }
            }
            if (tex == 2) {
                uvt = new UVTranslation(16.0, 0.0);
                for (Vertex5 vert : verts) {
                    vert.apply((IUVTransformation)uvt);
                }
            }
            if (this.inv) {
                verts = this.withBottom(verts, 0, 4);
            }
            this.i = RenderFlatWire.addVerts(this.model, verts, this.i);
        }

        private void reflectSide(Vertex5[] verts, int r) {
            if ((r + reorientSide[this.side]) % 4 >= 2) {
                for (Vertex5 vert : verts) {
                    vert.apply((IUVTransformation)sideReflect);
                }
            }
        }

        private Vertex5[] withBottom(Vertex5[] verts, int start, int count) {
            Vertex5[] i_verts = new Vertex5[verts.length + count];
            Transformation r = new Rotation(Math.PI, 0.0, 0.0, 1.0).at(new Vector3(0.5, this.h / 2.0, 0.0));
            for (int i = 0; i < count; ++i) {
                i_verts[i] = verts[i + start].copy().apply(r);
            }
            System.arraycopy(verts, 0, i_verts, count, verts.length);
            return i_verts;
        }
    }

    public static class UVT
    implements IUVTransformation {
        public Transformation t;
        private Vector3 vec = new Vector3();

        public UVT(Transformation t) {
            this.t = t;
        }

        public void transform(UV uv) {
            this.vec.set(uv.u, 0.0, uv.v).apply(this.t);
            uv.set(this.vec.x, this.vec.z);
        }
    }
}

