/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire.framed;

import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IHollowConnect;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import resonant.lib.prefab.damage.ElectricalDamage;
import resonantinduction.core.prefab.part.PartFramedConnection;
import resonantinduction.electrical.Electrical;
import resonantinduction.electrical.wire.EnumWireMaterial;
import resonantinduction.electrical.wire.framed.PartFramedSwitchWire;
import resonantinduction.electrical.wire.framed.RenderFramedWire;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalClass;
import universalelectricity.api.electricity.IElectricalNetwork;
import universalelectricity.api.energy.EnergyNetworkLoader;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyNetwork;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.INodeNetwork;

@UniversalClass
public class PartFramedWire
extends PartFramedConnection<EnumWireMaterial, IConductor, IEnergyNetwork>
implements IConductor,
TSlottedPart,
JNormalOcclusion,
IHollowConnect {
    public PartFramedWire() {
        super(Electrical.itemInsulation);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.breakIcon = RenderFramedWire.breakIcon;
        }
    }

    public PartFramedWire(EnumWireMaterial type) {
        this();
        this.material = type;
    }

    public PartFramedWire(int typeID) {
        this(EnumWireMaterial.values()[typeID]);
    }

    public String getType() {
        return "resonant_induction_wire";
    }

    public void onWorldJoin() {
        if (this.tile() instanceof IEnergyTile && !this.world().field_72995_K) {
            boolean foundAnotherPart = false;
            for (int i = 0; i < this.tile().partList().size(); ++i) {
                TMultiPart part = this.tile().partMap(i);
                if (!(part instanceof IEnergyTile) || part == this) continue;
                foundAnotherPart = true;
                break;
            }
            if (!foundAnotherPart) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.tile()));
            }
        }
        super.onWorldJoin();
    }

    public void preRemove() {
        if (!this.world().field_72995_K) {
            this.getNetwork().split((IConnector)this);
            if (this.tile() instanceof IEnergyTile) {
                boolean foundAnotherPart = false;
                for (int i = 0; i < this.tile().partList().size(); ++i) {
                    TMultiPart part = this.tile().partMap(i);
                    if (!(part instanceof IEnergyTile) || part == this) continue;
                    foundAnotherPart = true;
                    break;
                }
                if (!foundAnotherPart) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.tile()));
                }
            }
        }
        super.preRemove();
    }

    public boolean doesTick() {
        return false;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (!this.world().field_72995_K) {
            System.out.println(this.getNetwork());
        }
        if (item != null && item.func_77973_b().field_77779_bT == Block.field_72043_aJ.field_71990_ca) {
            TileMultipart tile = this.tile();
            World w = this.world();
            if (!w.field_72995_K) {
                PartFramedSwitchWire wire = (PartFramedSwitchWire)MultiPartRegistry.createPart((String)"resonant_induction_switch_wire", (boolean)false);
                wire.copyFrom(this);
                if (tile.canReplacePart((TMultiPart)this, (TMultiPart)wire)) {
                    tile.remPart((TMultiPart)this);
                    TileMultipart.addPart((World)w, (BlockCoord)new BlockCoord((TileEntity)tile), (TMultiPart)wire);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                }
            }
            return true;
        }
        return super.activate(player, part, item);
    }

    public void preparePlacement(int meta) {
        this.setMaterial(meta);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        HashSet<Cuboid6> collisionBoxes = new HashSet<Cuboid6>();
        collisionBoxes.addAll((Collection)this.getSubParts());
        return collisionBoxes;
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        if (pass == 0) {
            RenderFramedWire.INSTANCE.renderStatic(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (this.getMaterial() == EnumWireMaterial.SILVER) {
            RenderFramedWire.INSTANCE.renderShine(this, pos.x, pos.y, pos.z, frame);
        }
    }

    public void drawBreaking(RenderBlocks renderBlocks) {
        CCRenderState.reset();
        RenderUtils.renderBlock((Cuboid6)sides[6], (int)0, (Transformation)new Translation((double)this.x(), (double)this.y(), (double)this.z()), (IUVTransformation)new IconTransformation(renderBlocks.field_78664_d), null);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public int getSlotMask() {
        return PartMap.CENTER.mask;
    }

    public int getHollowSize() {
        return this.isInsulated ? 8 : 6;
    }

    protected boolean canConnectTo(TileEntity tile, ForgeDirection side) {
        TileEntity obj = tile instanceof TileMultipart ? ((TileMultipart)tile).partMap(ForgeDirection.UNKNOWN.ordinal()) : tile;
        return this.canConnect(side, obj);
    }

    public IConductor getConnector(TileEntity tile) {
        if (tile instanceof IConductor) {
            return (IConductor)((IConductor)tile).getInstance(ForgeDirection.UNKNOWN);
        }
        return null;
    }

    public boolean canConnect(ForgeDirection from, Object obj) {
        if (this.isBlockedOnSide(from)) {
            return false;
        }
        if (obj instanceof PartFramedWire) {
            if (this.world().func_72864_z(this.x(), this.y(), this.z())) {
                return false;
            }
            PartFramedWire wire = (PartFramedWire)((Object)obj);
            if (this.getMaterial() == wire.getMaterial()) {
                if (this.isInsulated() && wire.isInsulated()) {
                    return this.getColor() == wire.getColor() || this.getColor() == 15 || wire.getColor() == 15;
                }
                return true;
            }
            return false;
        }
        return CompatibilityModule.canConnect((Object)obj, (ForgeDirection)from.getOpposite(), (Object)((Object)this));
    }

    public float getResistance() {
        return ((EnumWireMaterial)this.getMaterial()).resistance;
    }

    public void copyFrom(PartFramedWire otherCable) {
        this.isInsulated = otherCable.isInsulated;
        this.color = otherCable.color;
        this.connections = otherCable.connections;
        this.material = otherCable.material;
        this.currentWireConnections = otherCable.currentWireConnections;
        this.currentAcceptorConnections = otherCable.currentAcceptorConnections;
        this.setNetwork((INodeNetwork)otherCable.getNetwork());
        this.getNetwork().setBufferFor((IConductor)this, ((IEnergyNetwork)otherCable.getInstance(ForgeDirection.UNKNOWN).getNetwork()).getBufferOf((IConductor)otherCable));
    }

    public IEnergyNetwork getNetwork() {
        if (this.network == null) {
            this.setNetwork((INodeNetwork)EnergyNetworkLoader.getNewNetwork((IConductor[])new IConductor[]{this}));
        }
        return (IEnergyNetwork)this.network;
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        return this.getNetwork().produce((IConductor)this, from.getOpposite(), receive, doReceive);
    }

    public long onExtractEnergy(ForgeDirection from, long request, boolean doExtract) {
        return 0L;
    }

    public long getCurrentCapacity() {
        return ((EnumWireMaterial)this.getMaterial()).maxAmps;
    }

    public void setMaterial(int i) {
        this.setMaterial(EnumWireMaterial.values()[i]);
    }

    protected ItemStack getItem() {
        return new ItemStack(Electrical.itemWire, 1, this.getMaterialID());
    }

    public void onEntityCollision(Entity entity) {
        if (!this.isInsulated() && this.getNetwork() instanceof IElectricalNetwork) {
            ElectricalDamage.handleElectrocution((Entity)entity, (Object)((Object)this), (IElectricalNetwork)((IElectricalNetwork)this.getNetwork()));
        }
    }

    public String toString() {
        return "[PartFramedWire]" + this.x() + "x " + this.y() + "y " + this.z() + "z " + this.getSlotMask() + "s ";
    }
}

